/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.profile;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.server.MinecraftServer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Server;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.profile.GameProfileCache;
import org.spongepowered.api.profile.GameProfileManager;
import org.spongepowered.api.profile.GameProfileProvider;
import org.spongepowered.common.SpongeServer;
import org.spongepowered.common.applaunch.config.core.SpongeConfigs;
import org.spongepowered.common.bridge.server.management.PlayerProfileCacheBridge;
import org.spongepowered.common.bridge.server.management.PlayerProfileCache_ProfileEntryBridge;
import org.spongepowered.common.profile.SpongeGameProfile;
import org.spongepowered.common.profile.UncachedGameProfileProvider;
import org.spongepowered.common.util.UsernameCache;

public final class SpongeGameProfileManager
implements GameProfileManager {
    private final UsernameCache usernameCache;
    private final PlayerProfileCacheBridge cache;
    private final UncachedGameProfileProvider uncached = new UncachedGameProfileProvider();
    private final ExecutorService gameLookupExecutorService;

    public SpongeGameProfileManager(Server server) {
        this.usernameCache = ((SpongeServer)server).getUsernameCache();
        this.cache = (PlayerProfileCacheBridge)((MinecraftServer)server).func_152358_ax();
        this.gameLookupExecutorService = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("Sponge - Async User Lookup Thread").build());
    }

    @Override
    public GameProfileCache getCache() {
        return this.cache;
    }

    @Override
    public GameProfileProvider uncached() {
        return this.uncached;
    }

    @Override
    public CompletableFuture<GameProfile> getBasicProfile(UUID uniqueId) {
        Objects.requireNonNull(uniqueId, "uniqueId");
        Optional<PlayerProfileCache_ProfileEntryBridge> entry = this.cache.bridge$getEntry(uniqueId);
        if (entry.isPresent()) {
            return CompletableFuture.completedFuture(entry.get().bridge$getBasic());
        }
        String cachedName = this.usernameCache.getLastKnownUsername(uniqueId);
        if (cachedName != null) {
            SpongeGameProfile profile2 = new SpongeGameProfile(uniqueId, cachedName);
            this.cache.bridge$addBasic(profile2);
            return CompletableFuture.completedFuture(profile2);
        }
        return this.uncached().getBasicProfile(uniqueId).thenApply(profile -> {
            this.cache.bridge$addBasic((GameProfile)profile);
            return profile;
        });
    }

    @Override
    public CompletableFuture<GameProfile> getBasicProfile(String name, @Nullable Instant time) {
        Objects.requireNonNull(name, "name");
        if (time != null) {
            return this.uncached().getBasicProfile(name, time);
        }
        return this.cache.bridge$getEntry(name).flatMap(entry -> Optional.ofNullable(entry.bridge$getBasic())).map(CompletableFuture::completedFuture).orElseGet(() -> this.uncached().getBasicProfile(name).thenApply(profile -> {
            this.cache.bridge$addBasic((GameProfile)profile);
            return profile;
        }));
    }

    @Override
    public CompletableFuture<Map<String, GameProfile>> getBasicProfiles(Iterable<String> names, @Nullable Instant time) {
        Objects.requireNonNull(names, "names");
        if (time != null) {
            return this.uncached().getBasicProfiles(names, time);
        }
        HashMap result = new HashMap();
        ArrayList<String> toLookup = new ArrayList<String>();
        for (String name : names) {
            Optional profile = this.cache.bridge$getEntry(name).flatMap(entry -> Optional.ofNullable(entry.bridge$getBasic()));
            if (profile.isPresent()) {
                result.put(name, profile.get());
                continue;
            }
            toLookup.add(name);
        }
        if (toLookup.isEmpty()) {
            return CompletableFuture.completedFuture(result);
        }
        return this.uncached().getBasicProfiles(toLookup).thenApply(lookedUp -> {
            for (GameProfile profile : lookedUp.values()) {
                this.cache.bridge$addBasic(profile);
            }
            result.putAll(lookedUp);
            return result;
        });
    }

    @Override
    public CompletableFuture<GameProfile> getProfile(String name, boolean signed) {
        Objects.requireNonNull(name, "name");
        return this.cache.bridge$getEntry(name).flatMap(entry -> Optional.ofNullable(entry.bridge$getFull(signed))).map(CompletableFuture::completedFuture).orElseGet(() -> this.uncached().getProfile(name, signed).thenApply(profile -> {
            this.cache.bridge$add((GameProfile)profile, true, signed);
            return profile;
        }));
    }

    @Override
    public CompletableFuture<GameProfile> getProfile(UUID uniqueId, boolean signed) {
        Objects.requireNonNull(uniqueId, "uniqueId");
        return this.cache.bridge$getEntry(uniqueId).flatMap(entry -> Optional.ofNullable(entry.bridge$getFull(signed))).map(CompletableFuture::completedFuture).orElseGet(() -> this.uncached().getProfile(uniqueId, signed).thenApply(profile -> {
            this.cache.bridge$add((GameProfile)profile, true, signed);
            return profile;
        }));
    }

    public void lookupUserAsync(UUID uniqueId) {
        Objects.requireNonNull(uniqueId, "uniqueId");
        this.gameLookupExecutorService.execute(() -> {
            try {
                this.getBasicProfile(uniqueId).get();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
            try {
                Thread.sleep((long)SpongeConfigs.getCommon().get().world.gameProfileQueryTaskInterval * 1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        });
    }
}

