/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.raid;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Optional;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.world.raid.Raid;
import org.spongepowered.api.entity.living.monster.raider.Raider;
import org.spongepowered.api.raid.RaidWave;
import org.spongepowered.common.accessor.world.raid.RaidAccessor;

public final class SpongeRaidWave
implements RaidWave {
    private final Raid raid;
    private final int waveId;

    public SpongeRaidWave(Raid raid, int waveId) {
        this.raid = raid;
        this.waveId = waveId;
    }

    @Override
    public org.spongepowered.api.raid.Raid getRaid() {
        return (org.spongepowered.api.raid.Raid)this.raid;
    }

    @Override
    public boolean isBonus() {
        return !this.isFinal() && this.waveId >= ((RaidAccessor)this.raid).accessor$numGroups();
    }

    @Override
    public boolean isFinal() {
        return this.waveId == ((RaidAccessor)this.raid).accessor$numGroups();
    }

    @Override
    public Optional<Raider> getLeader() {
        return Optional.ofNullable((Raider)this.raid.func_221332_b(this.waveId));
    }

    @Override
    public boolean addRaider(Raider raider, boolean addToRaidHealth) {
        Preconditions.checkNotNull((Object)raider, (Object)"Raider cannot be null.");
        return this.raid.func_221300_a(this.waveId, (AbstractRaiderEntity)raider, addToRaidHealth);
    }

    @Override
    public boolean removeRaider(Raider raider) {
        Preconditions.checkNotNull((Object)raider, (Object)"Raider cannot be null.");
        if (raider.raidWave().isPresent() && this.equals(raider.raidWave().get().get())) {
            this.raid.func_221322_a((AbstractRaiderEntity)raider, true);
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SpongeRaidWave) {
            SpongeRaidWave other = (SpongeRaidWave)obj;
            if (this.waveId == other.waveId && this.raid.func_221316_i() == other.raid.func_221316_i() && this.raid.func_221325_u() == other.raid.func_221325_u()) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("raid", (Object)this.raid).add("wave", this.waveId).toString();
    }
}

