/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry;

import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.SimpleRegistry;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.registry.DuplicateRegistrationException;
import org.spongepowered.api.registry.RegistryHolder;
import org.spongepowered.api.registry.RegistryRoots;
import org.spongepowered.api.registry.RegistryType;
import org.spongepowered.api.registry.ValueNotFoundException;
import org.spongepowered.common.accessor.util.RegistryKeyAccessor;
import org.spongepowered.common.accessor.util.registry.DynamicRegistriesAccessor;
import org.spongepowered.common.bridge.util.registry.MutableRegistryBridge;
import org.spongepowered.common.registry.CallbackRegistry;

public final class SpongeRegistryHolder
implements RegistryHolder {
    private final Map<ResourceKey, Registry<Registry<?>>> roots = new Object2ObjectOpenHashMap();

    public SpongeRegistryHolder() {
        this.roots.put((ResourceKey)new ResourceLocation("minecraft", "root"), (Registry<Registry<?>>)new SimpleRegistry(RegistryKey.func_240904_a_((ResourceLocation)((ResourceLocation)RegistryRoots.MINECRAFT)), Lifecycle.experimental()));
        ResourceLocation sponge = new ResourceLocation("sponge", "root");
        this.roots.put((ResourceKey)sponge, (Registry<Registry<?>>)new SimpleRegistry(RegistryKeyAccessor.invoker$create(sponge, sponge), Lifecycle.stable()));
    }

    public SpongeRegistryHolder(DynamicRegistries.Impl dynamicAccess) {
        this();
        MutableRegistry root = (MutableRegistry)this.roots.get(new ResourceLocation("minecraft", "root"));
        for (RegistryKey<? extends Registry<?>> registryKey : DynamicRegistriesAccessor.accessor$REGISTRIES().keySet()) {
            MutableRegistry registry = dynamicAccess.func_243612_b(registryKey);
            root.func_218381_a(registryKey, (Object)registry, Lifecycle.stable());
        }
    }

    public void setRootMinecraftRegistry(Registry<Registry<?>> rootRegistry) {
        this.roots.put(RegistryRoots.MINECRAFT, rootRegistry);
    }

    @Override
    public <T> org.spongepowered.api.registry.Registry<T> registry(RegistryType<T> type) {
        Objects.requireNonNull(type, "type");
        Registry<Registry<?>> root = this.roots.get(type.root());
        if (root == null) {
            throw new ValueNotFoundException(String.format("No '%s' root registry has been defined", type.root()));
        }
        Registry registry = (Registry)root.func_82594_a((ResourceLocation)type.location());
        if (registry == null) {
            throw new ValueNotFoundException(String.format("No '%s' registry has been defined in root '%s'", type.location(), type.root()));
        }
        return (org.spongepowered.api.registry.Registry)registry;
    }

    @Override
    public <T> Optional<org.spongepowered.api.registry.Registry<T>> findRegistry(RegistryType<T> type) {
        Objects.requireNonNull(type, "type");
        Registry<Registry<?>> root = this.roots.get(type.root());
        if (root == null) {
            return Optional.empty();
        }
        return root.func_241873_b((ResourceLocation)type.location());
    }

    @Override
    public Stream<org.spongepowered.api.registry.Registry<?>> stream(ResourceKey root) {
        Objects.requireNonNull(root, "root");
        Registry<Registry<?>> rootRegistry = this.roots.get(root);
        if (rootRegistry == null) {
            return Stream.empty();
        }
        return rootRegistry.func_201756_e();
    }

    public <T> org.spongepowered.api.registry.Registry<T> createRegistry(RegistryType<T> type, @Nullable Map<ResourceKey, T> defaultValues) {
        return this.createRegistry(type, defaultValues != null ? () -> defaultValues : null, false);
    }

    public <T> org.spongepowered.api.registry.Registry<T> createRegistry(RegistryType<T> type, @Nullable Supplier<Map<ResourceKey, T>> defaultValues) {
        return this.createRegistry(type, defaultValues, false);
    }

    public <T> org.spongepowered.api.registry.Registry<T> createRegistry(RegistryType<T> type, @Nullable Supplier<Map<ResourceKey, T>> defaultValues, boolean isDynamic) {
        return this.createRegistry(type, defaultValues, isDynamic, null);
    }

    public <T> org.spongepowered.api.registry.Registry<T> createRegistry(RegistryType<T> type, @Nullable Supplier<Map<ResourceKey, T>> defaultValues, boolean isDynamic, @Nullable BiConsumer<RegistryKey<T>, T> callback) {
        Objects.requireNonNull(type, "type");
        Registry<Registry<?>> root = this.roots.get(type.root());
        if (root == null) {
            throw new ValueNotFoundException(String.format("No '%s' root registry has been defined", type.root()));
        }
        Object registry = (Registry)root.func_82594_a((ResourceLocation)type.location());
        if (registry != null) {
            throw new DuplicateRegistrationException(String.format("Registry '%s' in root '%s' has already been defined", type.location(), type.root()));
        }
        RegistryKey key = Registry.field_239706_f_.equals((Object)type.root()) ? RegistryKey.func_240904_a_((ResourceLocation)((ResourceLocation)type.location())) : RegistryKeyAccessor.invoker$create((ResourceLocation)RegistryRoots.SPONGE, (ResourceLocation)type.location());
        registry = callback == null ? new SimpleRegistry(key, Lifecycle.stable()) : new CallbackRegistry<T>(key, Lifecycle.stable(), callback);
        ((MutableRegistryBridge)registry).bridge$setDynamic(isDynamic);
        if (defaultValues != null) {
            for (Map.Entry<ResourceKey, T> entry : defaultValues.get().entrySet()) {
                ((SimpleRegistry)registry).func_218381_a(RegistryKey.func_240903_a_(key, (ResourceLocation)((ResourceLocation)entry.getKey())), entry.getValue(), Lifecycle.stable());
            }
        }
        ((MutableRegistry)root).func_218381_a(key, registry, Lifecycle.stable());
        if (registry instanceof CallbackRegistry) {
            ((CallbackRegistry)((Object)registry)).setCallbackEnabled(true);
        }
        return (org.spongepowered.api.registry.Registry)registry;
    }
}

