/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.boss.dragon.phase.PhaseType;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.monster.PhantomEntity;
import net.minecraft.entity.monster.SpellcastingIllagerEntity;
import net.minecraft.entity.passive.FoxEntity;
import net.minecraft.entity.passive.MooshroomEntity;
import net.minecraft.entity.passive.PandaEntity;
import net.minecraft.entity.passive.fish.TropicalFishEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.DyeColor;
import net.minecraft.item.FireworkRocketItem;
import net.minecraft.item.ItemTier;
import net.minecraft.scoreboard.ScoreCriteria;
import net.minecraft.scoreboard.Team;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.state.properties.ChestType;
import net.minecraft.state.properties.ComparatorMode;
import net.minecraft.state.properties.DoorHingeSide;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.NoteBlockInstrument;
import net.minecraft.state.properties.PistonType;
import net.minecraft.state.properties.RailShape;
import net.minecraft.state.properties.RedstoneSide;
import net.minecraft.state.properties.SlabType;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.state.properties.StructureMode;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.world.Difficulty;
import net.minecraft.world.GameType;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.raid.Raid;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.advancement.criteria.trigger.Trigger;
import org.spongepowered.api.advancement.criteria.trigger.Triggers;
import org.spongepowered.api.item.FireworkShape;
import org.spongepowered.api.item.FireworkShapes;
import org.spongepowered.api.registry.DefaultedRegistryReference;
import org.spongepowered.api.registry.Registry;
import org.spongepowered.api.registry.RegistryKey;
import org.spongepowered.api.registry.RegistryType;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.scoreboard.criteria.Criteria;
import org.spongepowered.api.scoreboard.criteria.Criterion;
import org.spongepowered.common.accessor.advancements.CriteriaTriggersAccessor;
import org.spongepowered.common.accessor.entity.passive.MooshroomEntity_TypeAccessor;
import org.spongepowered.common.accessor.item.ArmorMaterialAccessor;
import org.spongepowered.common.accessor.tileentity.BannerPatternAccessor;
import org.spongepowered.common.advancement.criterion.SpongeDummyTrigger;
import org.spongepowered.common.advancement.criterion.SpongeScoreTrigger;
import org.spongepowered.common.registry.RegistryLoader;
import org.spongepowered.common.registry.SpongeRegistryHolder;

final class VanillaRegistryLoader {
    private final SpongeRegistryHolder holder;

    public static void load(SpongeRegistryHolder holder) {
        VanillaRegistryLoader loader = new VanillaRegistryLoader(holder);
        loader.loadEnumRegistries();
        loader.loadInstanceRegistries();
    }

    private VanillaRegistryLoader(SpongeRegistryHolder holder) {
        this.holder = holder;
    }

    private void loadInstanceRegistries() {
        this.holder.createRegistry(RegistryTypes.CRITERION, VanillaRegistryLoader.criterion().values());
        this.manualName(RegistryTypes.DRAGON_PHASE_TYPE, PhaseType.func_188739_c(), (Manual<A, I> map) -> {
            map.put(PhaseType.field_188741_a, "holding_pattern");
            map.put(PhaseType.field_188742_b, "strafe_player");
            map.put(PhaseType.field_188743_c, "landing_approach");
            map.put(PhaseType.field_188744_d, "landing");
            map.put(PhaseType.field_188745_e, "takeoff");
            map.put(PhaseType.field_188746_f, "sitting_flaming");
            map.put(PhaseType.field_188747_g, "sitting_scanning");
            map.put(PhaseType.field_188748_h, "sitting_attacking");
            map.put(PhaseType.field_188749_i, "charging_player");
            map.put(PhaseType.field_188750_j, "dying");
            map.put(PhaseType.field_188751_k, "hover");
        });
        this.holder.createRegistry(RegistryTypes.FIREWORK_SHAPE, VanillaRegistryLoader.fireworkShape().values());
        this.holder.createRegistry(RegistryTypes.TRIGGER, () -> VanillaRegistryLoader.trigger().values(), true, (k, trigger) -> CriteriaTriggersAccessor.invoker$register((ICriterionTrigger)trigger));
    }

    private void loadEnumRegistries() {
        this.knownName(RegistryTypes.ARMOR_MATERIAL, (Enum[])ArmorMaterial.values(), am -> ((ArmorMaterialAccessor)am).accessor$name());
        this.knownName(RegistryTypes.ATTACHMENT_SURFACE, (Enum[])AttachFace.values(), AttachFace::func_176610_l);
        this.manualName(RegistryTypes.ATTRIBUTE_OPERATION, (Enum[])AttributeModifier.Operation.values(), map -> {
            map.put(AttributeModifier.Operation.ADDITION, "addition");
            map.put(AttributeModifier.Operation.MULTIPLY_BASE, "multiply_base");
            map.put(AttributeModifier.Operation.MULTIPLY_TOTAL, "multiply_total");
        });
        this.knownName(RegistryTypes.BOAT_TYPE, (Enum[])BoatEntity.Type.values(), BoatEntity.Type::func_184980_a);
        this.knownName(RegistryTypes.CHEST_ATTACHMENT_TYPE, (Enum[])ChestType.values(), ChestType::func_176610_l);
        this.manualName(RegistryTypes.COLLISION_RULE, (Enum[])Team.CollisionRule.values(), map -> {
            map.put(Team.CollisionRule.ALWAYS, "always");
            map.put(Team.CollisionRule.NEVER, "never");
            map.put(Team.CollisionRule.PUSH_OTHER_TEAMS, "push_other_teams");
            map.put(Team.CollisionRule.PUSH_OWN_TEAM, "push_own_team");
        });
        this.knownName(RegistryTypes.COMPARATOR_MODE, (Enum[])ComparatorMode.values(), ComparatorMode::func_176610_l);
        this.knownName(RegistryTypes.DIFFICULTY, (Enum[])Difficulty.values(), Difficulty::func_151526_b);
        this.knownName(RegistryTypes.DYE_COLOR, (Enum[])DyeColor.values(), DyeColor::func_176610_l);
        this.knownName(RegistryTypes.DOOR_HINGE, (Enum[])DoorHingeSide.values(), DoorHingeSide::func_176610_l);
        this.manualName(RegistryTypes.EQUIPMENT_GROUP, (Enum[])EquipmentSlotType.Group.values(), map -> {
            map.put(EquipmentSlotType.Group.ARMOR, "worn");
            map.put(EquipmentSlotType.Group.HAND, "held");
        });
        this.manualName(RegistryTypes.EQUIPMENT_TYPE, (Enum[])EquipmentSlotType.values(), map -> {
            map.put(EquipmentSlotType.CHEST, "chest");
            map.put(EquipmentSlotType.FEET, "feet");
            map.put(EquipmentSlotType.HEAD, "head");
            map.put(EquipmentSlotType.LEGS, "legs");
            map.put(EquipmentSlotType.MAINHAND, "main_hand");
            map.put(EquipmentSlotType.OFFHAND, "off_hand");
        });
        this.knownName(RegistryTypes.FOX_TYPE, (Enum[])FoxEntity.Type.values(), FoxEntity.Type::func_221082_a);
        this.manualName(RegistryTypes.GAME_MODE, (Enum[])GameType.values(), map -> {
            map.put(GameType.NOT_SET, "not_set");
            map.put(GameType.SURVIVAL, GameType.SURVIVAL.func_77149_b());
            map.put(GameType.CREATIVE, GameType.CREATIVE.func_77149_b());
            map.put(GameType.ADVENTURE, GameType.ADVENTURE.func_77149_b());
            map.put(GameType.SPECTATOR, GameType.SPECTATOR.func_77149_b());
        });
        this.automaticName(RegistryTypes.HAND_PREFERENCE, (Enum[])HandSide.values());
        this.automaticName(RegistryTypes.HAND_TYPE, (Enum[])Hand.values());
        this.knownName(RegistryTypes.INSTRUMENT_TYPE, (Enum[])NoteBlockInstrument.values(), NoteBlockInstrument::func_176610_l);
        this.automaticName(RegistryTypes.ITEM_TIER, (Enum[])ItemTier.values());
        this.knownName(RegistryTypes.MOOSHROOM_TYPE, (Enum[])MooshroomEntity.Type.values(), type -> ((MooshroomEntity_TypeAccessor)type).accessor$type());
        this.knownName(RegistryTypes.OBJECTIVE_DISPLAY_MODE, (Enum[])ScoreCriteria.RenderType.values(), ScoreCriteria.RenderType::func_211838_a);
        this.knownName(RegistryTypes.PANDA_GENE, (Enum[])PandaEntity.Gene.values(), PandaEntity.Gene::func_221100_b);
        this.automaticName(RegistryTypes.PHANTOM_PHASE, (Enum[])PhantomEntity.AttackPhase.values());
        this.automaticName(RegistryTypes.PICKUP_RULE, (Enum[])AbstractArrowEntity.PickupStatus.values());
        this.knownName(RegistryTypes.PISTON_TYPE, (Enum[])PistonType.values(), PistonType::func_176610_l);
        this.knownName(RegistryTypes.PORTION_TYPE, (Enum[])Half.values(), Half::func_176610_l);
        this.automaticName(RegistryTypes.RAID_STATUS, (Enum[])Raid.Status.values());
        this.knownName(RegistryTypes.RAIL_DIRECTION, (Enum[])RailShape.values(), RailShape::func_176610_l);
        this.knownName(RegistryTypes.WIRE_ATTACHMENT_TYPE, (Enum[])RedstoneSide.values(), RedstoneSide::func_176610_l);
        this.knownName(RegistryTypes.SLAB_PORTION, (Enum[])SlabType.values(), SlabType::func_176610_l);
        this.automaticName(RegistryTypes.SPELL_TYPE, (Enum[])SpellcastingIllagerEntity.SpellType.values());
        this.knownName(RegistryTypes.STAIR_SHAPE, (Enum[])StairsShape.values(), StairsShape::func_176610_l);
        this.knownName(RegistryTypes.STRUCTURE_MODE, (Enum[])StructureMode.values(), StructureMode::func_176610_l);
        this.manualName(RegistryTypes.VISIBILITY, (Enum[])Team.Visible.values(), map -> {
            map.put(Team.Visible.ALWAYS, "always");
            map.put(Team.Visible.NEVER, "never");
            map.put(Team.Visible.HIDE_FOR_OTHER_TEAMS, "hide_for_other_teams");
            map.put(Team.Visible.HIDE_FOR_OWN_TEAM, "hide_for_own_team");
        });
        this.knownName(RegistryTypes.ADVANCEMENT_TYPE, (Enum[])FrameType.values(), FrameType::func_192307_a);
        this.knownName(RegistryTypes.BANNER_PATTERN_SHAPE, (Enum[])BannerPattern.values(), b -> ((BannerPatternAccessor)b).accessor$filename());
        this.automaticName(RegistryTypes.TROPICAL_FISH_SHAPE, (Enum[])TropicalFishEntity.Type.values());
        this.automaticName(RegistryTypes.HEIGHT_TYPE, (Enum[])Heightmap.Type.values());
    }

    private static RegistryLoader<Criterion> criterion() {
        return RegistryLoader.of(l -> {
            l.add(Criteria.AIR, k -> (Criterion)ScoreCriteria.field_186699_i);
            l.add(Criteria.ARMOR, k -> (Criterion)ScoreCriteria.field_186700_j);
            l.add(Criteria.DEATH_COUNT, k -> (Criterion)ScoreCriteria.field_96642_c);
            l.add(Criteria.DUMMY, k -> (Criterion)ScoreCriteria.field_96641_b);
            l.add(Criteria.EXPERIENCE, k -> (Criterion)ScoreCriteria.field_186701_k);
            l.add(Criteria.FOOD, k -> (Criterion)ScoreCriteria.field_186698_h);
            l.add(Criteria.HEALTH, k -> (Criterion)ScoreCriteria.field_96638_f);
            l.add(Criteria.LEVEL, k -> (Criterion)ScoreCriteria.field_186702_l);
            l.add(Criteria.PLAYER_KILL_COUNT, k -> (Criterion)ScoreCriteria.field_96639_d);
            l.add(Criteria.TOTAL_KILL_COUNT, k -> (Criterion)ScoreCriteria.field_96640_e);
            l.add(Criteria.TRIGGER, k -> (Criterion)ScoreCriteria.field_178791_c);
        });
    }

    private static RegistryLoader<FireworkShape> fireworkShape() {
        return RegistryLoader.of(l -> {
            l.add(FireworkRocketItem.Shape.BURST.func_196071_a(), FireworkShapes.BURST, () -> (FireworkShape)FireworkRocketItem.Shape.BURST);
            l.add(FireworkRocketItem.Shape.CREEPER.func_196071_a(), FireworkShapes.CREEPER, () -> (FireworkShape)FireworkRocketItem.Shape.CREEPER);
            l.add(FireworkRocketItem.Shape.LARGE_BALL.func_196071_a(), FireworkShapes.LARGE_BALL, () -> (FireworkShape)FireworkRocketItem.Shape.LARGE_BALL);
            l.add(FireworkRocketItem.Shape.SMALL_BALL.func_196071_a(), FireworkShapes.SMALL_BALL, () -> (FireworkShape)FireworkRocketItem.Shape.SMALL_BALL);
            l.add(FireworkRocketItem.Shape.STAR.func_196071_a(), FireworkShapes.STAR, () -> (FireworkShape)FireworkRocketItem.Shape.STAR);
        });
    }

    private static RegistryLoader<Trigger<?>> trigger() {
        return RegistryLoader.of(l -> {
            l.add(Triggers.BAD_OMEN, k -> (Trigger)CriteriaTriggers.field_215102_I);
            l.add(Triggers.BEE_NEST_DESTROYED, k -> (Trigger)CriteriaTriggers.field_229865_L_);
            l.add(Triggers.BRED_ANIMALS, k -> (Trigger)CriteriaTriggers.field_192134_n);
            l.add(Triggers.BREWED_POTION, k -> (Trigger)CriteriaTriggers.field_192130_j);
            l.add(Triggers.CHANGED_DIMENSION, k -> (Trigger)CriteriaTriggers.field_193134_u);
            l.add(Triggers.CHANNELED_LIGHTNING, k -> (Trigger)CriteriaTriggers.field_204812_E);
            l.add(Triggers.CONSTRUCT_BEACON, k -> (Trigger)CriteriaTriggers.field_192131_k);
            l.add(Triggers.CONSUME_ITEM, k -> (Trigger)CriteriaTriggers.field_193138_y);
            l.add(Triggers.CURED_ZOMBIE_VILLAGER, k -> (Trigger)CriteriaTriggers.field_192137_q);
            l.add(Triggers.EFFECTS_CHANGED, k -> (Trigger)CriteriaTriggers.field_193139_z);
            l.add(Triggers.ENCHANTED_ITEM, k -> (Trigger)CriteriaTriggers.field_192129_i);
            l.add(Triggers.ENTER_BLOCK, k -> (Trigger)CriteriaTriggers.field_192124_d);
            l.add(Triggers.ENTITY_HURT_PLAYER, k -> (Trigger)CriteriaTriggers.field_192128_h);
            l.add(Triggers.ENTITY_KILLED_PLAYER, k -> (Trigger)CriteriaTriggers.field_192123_c);
            l.add(Triggers.FILLED_BUCKET, k -> (Trigger)CriteriaTriggers.field_204813_j);
            l.add(Triggers.FISHING_ROD_HOOKED, k -> (Trigger)CriteriaTriggers.field_204811_D);
            l.add(Triggers.GENERATE_LOOT, k -> (Trigger)CriteriaTriggers.field_232608_N_);
            l.add(Triggers.HONEY_BLOCK_SIDE, k -> (Trigger)CriteriaTriggers.field_229864_K_);
            l.add(Triggers.IMPOSSIBLE, k -> (Trigger)CriteriaTriggers.field_192121_a);
            l.add(Triggers.INVENTORY_CHANGED, k -> (Trigger)CriteriaTriggers.field_192125_e);
            l.add(Triggers.ITEM_DURABILITY_CHANGED, k -> (Trigger)CriteriaTriggers.field_193132_s);
            l.add(Triggers.ITEM_PICKED_UP_BY_ENTITY, k -> (Trigger)CriteriaTriggers.field_232609_O_);
            l.add(Triggers.ITEM_USED_ON_BLOCK, k -> (Trigger)CriteriaTriggers.field_232607_M_);
            l.add(Triggers.KILLED_BY_CROSSBOW, k -> (Trigger)CriteriaTriggers.field_215100_G);
            l.add(Triggers.LEVITATION, k -> (Trigger)CriteriaTriggers.field_193133_t);
            l.add(Triggers.LOCATION, k -> (Trigger)CriteriaTriggers.field_192135_o);
            l.add(Triggers.NETHER_TRAVEL, k -> (Trigger)CriteriaTriggers.field_193131_B);
            l.add(Triggers.PLACED_BLOCK, k -> (Trigger)CriteriaTriggers.field_193137_x);
            l.add(Triggers.PLAYER_HURT_ENTITY, k -> (Trigger)CriteriaTriggers.field_192127_g);
            l.add(Triggers.PLAYER_INTERACTED_WITH_ENTITY, k -> (Trigger)CriteriaTriggers.field_241276_P_);
            l.add(Triggers.PLAYER_KILLED_ENTITY, k -> (Trigger)CriteriaTriggers.field_192122_b);
            l.add(Triggers.RAID_WIN, k -> (Trigger)CriteriaTriggers.field_215101_H);
            l.add(Triggers.RECIPE_UNLOCKED, k -> (Trigger)CriteriaTriggers.field_192126_f);
            l.add(Triggers.SHOT_CROSSBOW, k -> (Trigger)CriteriaTriggers.field_215099_F);
            l.add(Triggers.SLEPT_IN_BED, k -> (Trigger)CriteriaTriggers.field_192136_p);
            l.add(Triggers.SUMMONED_ENTITY, k -> (Trigger)CriteriaTriggers.field_192133_m);
            l.add(Triggers.TAME_ANIMAL, k -> (Trigger)CriteriaTriggers.field_193136_w);
            l.add(Triggers.TARGET_BLOCK_HIT, k -> (Trigger)CriteriaTriggers.field_232606_L_);
            l.add(Triggers.TICK, k -> (Trigger)CriteriaTriggers.field_193135_v);
            l.add(Triggers.USED_ENDER_EYE, k -> (Trigger)CriteriaTriggers.field_192132_l);
            l.add(Triggers.USED_TOTEM, k -> (Trigger)CriteriaTriggers.field_193130_A);
            l.add(Triggers.VILLAGER_TRADE, k -> (Trigger)CriteriaTriggers.field_192138_r);
            DefaultedRegistryReference dummyKey = RegistryKey.of(RegistryTypes.TRIGGER, ResourceKey.sponge("dummy")).asDefaultedReference(() -> Sponge.getGame().registries());
            l.add(dummyKey, k -> (Trigger)((Object)SpongeDummyTrigger.DUMMY_TRIGGER));
            DefaultedRegistryReference scoreKey = RegistryKey.of(RegistryTypes.TRIGGER, ResourceKey.sponge("score")).asDefaultedReference(() -> Sponge.getGame().registries());
            l.add(scoreKey, k -> (Trigger)((Object)SpongeScoreTrigger.SCORE_TRIGGER));
        });
    }

    private <A, I extends Enum<I>> Registry<A> automaticName(RegistryType<A> type, I[] values) {
        return this.naming(type, (Enum[])values, value -> value.name().toLowerCase(Locale.ROOT));
    }

    private <A, I extends Enum<I>> Registry<A> knownName(RegistryType<A> type, I[] values, Function<I, String> name) {
        return this.naming(type, (Enum[])values, name);
    }

    private <A, I extends Enum<I>> Registry<A> manualName(RegistryType<A> type, I[] values, Consumer<Manual<A, I>> byName) {
        HashMap map = new HashMap(values.length);
        byName.accept(map::put);
        return this.naming(type, (Enum[])values, map);
    }

    private <A, I> Registry<A> manualName(RegistryType<A> type, int values, Consumer<Manual<A, I>> byName) {
        HashMap map = new HashMap(values);
        byName.accept(map::put);
        return this.naming(type, values, map);
    }

    private <A, I extends Enum<I>> Registry<A> naming(RegistryType<A> type, I[] values, Function<I, String> name) {
        HashMap<I, String> map = new HashMap<I, String>();
        for (I value : values) {
            map.put(value, name.apply(value));
        }
        return this.naming(type, (Enum[])values, map);
    }

    private <A, I extends Enum<I>> Registry<A> naming(RegistryType<A> type, I[] values, Map<I, String> byName) {
        return this.naming(type, values.length, byName);
    }

    private <A, I> Registry<A> naming(RegistryType<A> type, int values, Map<I, String> byName) {
        if (values != byName.size()) {
            throw new IllegalStateException(type.location() + " in " + type.root() + " is has value mismatch: " + values + " / " + byName.size());
        }
        return this.holder.createRegistry(type, () -> {
            HashMap map = new HashMap();
            for (Map.Entry value : byName.entrySet()) {
                map.put(ResourceKey.sponge((String)value.getValue()), value.getKey());
            }
            return map;
        }, false);
    }

    private static interface Manual<A, I> {
        public void put(I var1, String var2);
    }
}

