/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.provider;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.entity.ai.goal.RunAroundLikeCrazyGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import org.spongepowered.api.entity.ai.goal.GoalType;
import org.spongepowered.api.entity.ai.goal.GoalTypes;

public final class GoalTypeProvider {
    public static final GoalTypeProvider INSTANCE = new GoalTypeProvider();
    private final Map<Class<? extends Goal>, GoalType> mappings = new IdentityHashMap<Class<? extends Goal>, GoalType>();

    GoalTypeProvider() {
        this.mappings.put(AvoidEntityGoal.class, GoalTypes.AVOID_LIVING.get());
        this.mappings.put(MeleeAttackGoal.class, GoalTypes.ATTACK_LIVING.get());
        this.mappings.put(NearestAttackableTargetGoal.class, GoalTypes.FIND_NEAREST_ATTACKABLE.get());
        this.mappings.put(LookAtGoal.class, GoalTypes.LOOK_AT.get());
        this.mappings.put(LookRandomlyGoal.class, GoalTypes.LOOK_RANDOMLY.get());
        this.mappings.put(RandomWalkingGoal.class, GoalTypes.RANDOM_WALKING.get());
        this.mappings.put(RangedAttackGoal.class, GoalTypes.RANGED_ATTACK_AGAINST_AGENT.get());
        this.mappings.put(RunAroundLikeCrazyGoal.class, GoalTypes.RUN_AROUND_LIKE_CRAZY.get());
        this.mappings.put(SwimGoal.class, GoalTypes.SWIM.get());
    }

    public Optional<GoalType> get(Class<? extends Goal> type) {
        return Optional.ofNullable(this.mappings.get(type));
    }
}

