/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.relocate.co.aikar.timings;

import co.aikar.timings.Timing;
import co.aikar.timings.TimingsFactory;
import com.google.common.collect.EvictingQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.kyori.adventure.audience.Audience;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.applaunch.config.common.TimingsCategory;
import org.spongepowered.common.applaunch.config.core.SpongeConfigs;
import org.spongepowered.common.relocate.co.aikar.timings.NullTimingHandler;
import org.spongepowered.common.relocate.co.aikar.timings.TimingHandler;
import org.spongepowered.common.relocate.co.aikar.timings.TimingHistory;
import org.spongepowered.common.relocate.co.aikar.timings.TimingsExport;
import org.spongepowered.common.relocate.co.aikar.timings.TimingsManager;
import org.spongepowered.plugin.PluginContainer;

public final class SpongeTimingsFactory
implements TimingsFactory {
    private final int MAX_HISTORY_FRAMES = 12;
    public final Timing NULL_HANDLER = new NullTimingHandler();
    private boolean timingsEnabled = false;
    private boolean verboseEnabled = true;
    private int historyInterval = -1;
    private int historyLength = -1;
    private final boolean moduleEnabled;

    public SpongeTimingsFactory() {
        this.moduleEnabled = SpongeConfigs.getCommon().get().modules.timings;
    }

    public TimingsFactory init() {
        TimingsCategory category = SpongeConfigs.getCommon().get().timings;
        TimingsManager.privacy = category.serverNamePrivacy;
        TimingsManager.hiddenConfigs.addAll(category.hiddenConfigEntries);
        this.setVerboseTimingsEnabled(category.verbose);
        this.setTimingsEnabled(this.moduleEnabled && category.enabled);
        this.setHistoryInterval(category.historyInterval);
        this.setHistoryLength(category.historyLength);
        SpongeCommon.getLogger().debug("Sponge Timings: " + this.timingsEnabled + " - Verbose: " + this.verboseEnabled + " - Interval: " + SpongeTimingsFactory.timeSummary(this.historyInterval / 20) + " - Length: " + SpongeTimingsFactory.timeSummary(this.historyLength / 20));
        return this;
    }

    private static String timeSummary(int seconds) {
        String time = "";
        if (seconds > 3600) {
            time = time + TimeUnit.SECONDS.toHours(seconds) + "h";
            seconds /= 60;
        }
        if (seconds > 0) {
            time = time + TimeUnit.SECONDS.toMinutes(seconds) + "m";
        }
        return time;
    }

    @Override
    public Timing of(PluginContainer plugin, String name, @Nullable Timing groupHandler) {
        return TimingsManager.getHandler(plugin.getMetadata().getId(), name, groupHandler, true);
    }

    @Override
    public boolean isTimingsEnabled() {
        return this.timingsEnabled;
    }

    @Override
    public void setTimingsEnabled(boolean enabled) {
        if (!this.moduleEnabled) {
            return;
        }
        this.timingsEnabled = enabled;
        this.reset();
    }

    @Override
    public boolean isVerboseTimingsEnabled() {
        return this.verboseEnabled;
    }

    @Override
    public void setVerboseTimingsEnabled(boolean enabled) {
        this.verboseEnabled = enabled;
        TimingsManager.needsRecheckEnabled = true;
    }

    @Override
    public int getHistoryInterval() {
        return this.historyInterval;
    }

    @Override
    public void setHistoryInterval(int interval) {
        this.historyInterval = Math.max(1200, interval);
        if (this.historyLength != -1) {
            this.setHistoryLength(this.historyLength);
        }
    }

    @Override
    public int getHistoryLength() {
        return this.historyLength;
    }

    @Override
    public void setHistoryLength(int length) {
        int maxLength = this.historyInterval * this.MAX_HISTORY_FRAMES;
        if (System.getProperty("timings.bypassMax") != null) {
            maxLength = Integer.MAX_VALUE;
        }
        this.historyLength = Math.max(Math.min(maxLength, length), this.historyInterval);
        EvictingQueue<TimingHistory> oldQueue = TimingsManager.HISTORY;
        int frames = this.getHistoryLength() / this.getHistoryInterval();
        if (length > maxLength) {
            SpongeCommon.getLogger().warn("Timings Length too high. Requested " + length + ", max is " + maxLength + ". To get longer history, you must increase your interval. Set Interval to " + Math.ceil(length / this.MAX_HISTORY_FRAMES) + " to achieve this length.");
        }
        TimingsManager.HISTORY = EvictingQueue.create((int)frames);
        TimingsManager.HISTORY.addAll(oldQueue);
    }

    @Override
    public void reset() {
        TimingsManager.reset();
    }

    @Override
    public void generateReport(Audience channel) {
        TimingsExport.requestingReport.add(channel);
    }

    public static long getCost() {
        return TimingsExport.getCost();
    }

    public static TimingHandler ofSafe(String name) {
        return SpongeTimingsFactory.ofSafe(null, name, null);
    }

    public static Timing ofSafe(PluginContainer plugin, String name) {
        return SpongeTimingsFactory.ofSafe(plugin != null ? plugin.getMetadata().getName().orElse(plugin.getMetadata().getId()) : "Minecraft - Invalid Plugin", name);
    }

    public static TimingHandler ofSafe(String name, Timing groupHandler) {
        return SpongeTimingsFactory.ofSafe(null, name, groupHandler);
    }

    public static TimingHandler ofSafe(String groupName, String name) {
        return TimingsManager.getHandler(groupName, name, null, false);
    }

    public static TimingHandler ofSafe(String groupName, String name, Timing groupHandler) {
        return TimingsManager.getHandler(groupName, name, groupHandler, false);
    }
}

