/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.scoreboard;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.minecraft.scoreboard.ScoreCriteria;
import net.minecraft.scoreboard.ScoreObjective;
import org.spongepowered.api.scoreboard.Score;
import org.spongepowered.api.scoreboard.Scoreboard;
import org.spongepowered.api.scoreboard.criteria.Criterion;
import org.spongepowered.api.scoreboard.objective.Objective;
import org.spongepowered.api.scoreboard.objective.displaymode.ObjectiveDisplayMode;
import org.spongepowered.api.scoreboard.objective.displaymode.ObjectiveDisplayModes;
import org.spongepowered.common.accessor.scoreboard.ScoreAccessor;
import org.spongepowered.common.accessor.scoreboard.ScoreObjectiveAccessor;
import org.spongepowered.common.accessor.scoreboard.ScoreboardAccessor;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.scoreboard.ScoreObjectiveBridge;
import org.spongepowered.common.scoreboard.SpongeScore;

public final class SpongeObjective
implements Objective {
    private final String name;
    private final Criterion criterion;
    private final Map<Component, Score> scores = new HashMap<Component, Score>();
    private final Map<net.minecraft.scoreboard.Scoreboard, ScoreObjective> objectives;
    private Component displayName;
    private ObjectiveDisplayMode displayMode;

    public SpongeObjective(String name, Criterion criterion) {
        this.name = name;
        this.displayName = SpongeAdventure.legacySection(name);
        this.displayMode = ObjectiveDisplayModes.INTEGER.get();
        this.criterion = criterion;
        this.objectives = new HashMap<net.minecraft.scoreboard.Scoreboard, ScoreObjective>();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Component getDisplayName() {
        return this.displayName;
    }

    @Override
    public void setDisplayName(Component displayName) throws IllegalArgumentException {
        this.displayName = displayName;
        this.updateDisplayName();
    }

    @Override
    public Criterion getCriterion() {
        return this.criterion;
    }

    @Override
    public ObjectiveDisplayMode getDisplayMode() {
        return this.displayMode;
    }

    @Override
    public void setDisplayMode(ObjectiveDisplayMode displayMode) {
        this.displayMode = displayMode;
        this.updateDisplayMode();
    }

    @Override
    public Map<Component, Score> getScores() {
        return new HashMap<Component, Score>(this.scores);
    }

    @Override
    public boolean hasScore(Component name) {
        return this.scores.containsKey(name);
    }

    @Override
    public void addScore(Score score) throws IllegalArgumentException {
        if (this.scores.containsKey(score.getName())) {
            throw new IllegalArgumentException(String.format("A score with the name %s already exists!", SpongeAdventure.legacySection(score.getName())));
        }
        this.scores.put(score.getName(), score);
        SpongeScore spongeScore = (SpongeScore)score;
        for (ScoreObjective objective : this.objectives.values()) {
            this.addScoreToScoreboard(((ScoreObjectiveAccessor)objective).accessor$scoreboard(), spongeScore.getScoreFor(objective));
        }
    }

    @Override
    public Optional<Score> getScore(Component name) {
        return Optional.ofNullable(this.scores.get(name));
    }

    @Override
    public Score getOrCreateScore(Component name) {
        if (this.scores.containsKey(name)) {
            return this.scores.get(name);
        }
        SpongeScore score = new SpongeScore(name);
        this.addScore(score);
        return score;
    }

    @Override
    public boolean removeScore(Score spongeScore) {
        String name = ((SpongeScore)spongeScore).legacyName;
        if (!this.scores.containsKey(spongeScore.getName())) {
            return false;
        }
        for (ScoreObjective objective : this.objectives.values()) {
            net.minecraft.scoreboard.Scoreboard scoreboard = ((ScoreObjectiveAccessor)objective).accessor$scoreboard();
            Map<ScoreObjective, net.minecraft.scoreboard.Score> map = ((ScoreboardAccessor)scoreboard).accessor$playerScores().get(name);
            if (map != null) {
                net.minecraft.scoreboard.Score score = map.remove(objective);
                if (map.size() < 1) {
                    Map<ScoreObjective, net.minecraft.scoreboard.Score> map1 = ((ScoreboardAccessor)scoreboard).accessor$playerScores().remove(name);
                    if (map1 != null) {
                        scoreboard.func_96516_a(name);
                    }
                } else if (score != null) {
                    scoreboard.func_178820_a(name, objective);
                }
            }
            ((SpongeScore)spongeScore).removeScoreFor(objective);
        }
        this.scores.remove(spongeScore.getName());
        return true;
    }

    @Override
    public boolean removeScore(Component name) {
        Optional<Score> score = this.getScore(name);
        return score.filter(this::removeScore).isPresent();
    }

    @Override
    public Set<Scoreboard> getScoreboards() {
        return new HashSet<net.minecraft.scoreboard.Scoreboard>(this.objectives.keySet());
    }

    private void updateDisplayMode() {
        for (ScoreObjective objective : this.objectives.values()) {
            objective.func_199866_a((ScoreCriteria.RenderType)this.displayMode);
        }
    }

    private void updateDisplayName() {
        for (ScoreObjective objective : this.objectives.values()) {
            objective.func_199864_a(SpongeAdventure.asVanilla(this.displayName));
        }
    }

    public void updateScores(net.minecraft.scoreboard.Scoreboard scoreboard) {
        ScoreObjective objective = this.getObjectiveFor(scoreboard);
        for (Score score : this.getScores().values()) {
            SpongeScore spongeScore = (SpongeScore)score;
            this.addScoreToScoreboard(scoreboard, spongeScore.getScoreFor(objective));
        }
    }

    private void addScoreToScoreboard(net.minecraft.scoreboard.Scoreboard scoreboard, net.minecraft.scoreboard.Score score) {
        String name = score.func_96653_e();
        Map scoreMap = ((ScoreboardAccessor)scoreboard).accessor$playerScores().computeIfAbsent(name, k -> Maps.newHashMap());
        scoreMap.put(((ScoreAccessor)score).accessor$objective(), score);
        ((ScoreAccessor)score).accessor$forceUpdate(true);
        score.func_96647_c(((ScoreAccessor)score).accessor$count());
    }

    public ScoreObjective getObjectiveFor(net.minecraft.scoreboard.Scoreboard scoreboard) {
        if (this.objectives.containsKey(scoreboard)) {
            return this.objectives.get(scoreboard);
        }
        ScoreObjective objective = new ScoreObjective(scoreboard, this.name, (ScoreCriteria)this.criterion, SpongeAdventure.asVanilla(this.displayName), (ScoreCriteria.RenderType)this.displayMode);
        ((ScoreObjectiveBridge)objective).bridge$setSpongeObjective(this);
        this.objectives.put(scoreboard, objective);
        return objective;
    }

    public void removeObjectiveFor(net.minecraft.scoreboard.Scoreboard scoreboard) {
        if (this.objectives.remove(scoreboard) == null) {
            throw new IllegalStateException("Attempting to remove an objective without an entry!");
        }
    }

    public Collection<ScoreObjective> getObjectives() {
        return this.objectives.values();
    }

    public static final class Builder
    implements Objective.Builder {
        private static final int MAX_NAME_LENGTH = 16;
        @Nullable
        private String name;
        @Nullable
        private Component displayName;
        @Nullable
        private Criterion criterion;
        @Nullable
        private ObjectiveDisplayMode objectiveDisplayMode;

        @Override
        public Objective.Builder name(String name) {
            Objects.requireNonNull(name);
            if (16 < name.length()) {
                throw new IllegalStateException(String.format("name '%s' is too long: %s characters over limit of %s", name, 16 - name.length(), 16));
            }
            this.name = name;
            return this;
        }

        @Override
        public Objective.Builder displayName(Component displayName) {
            this.displayName = Objects.requireNonNull(displayName);
            return this;
        }

        @Override
        public Objective.Builder criterion(Criterion criterion) {
            this.criterion = Objects.requireNonNull(criterion);
            return this;
        }

        @Override
        public Objective.Builder objectiveDisplayMode(ObjectiveDisplayMode objectiveDisplayMode) {
            this.objectiveDisplayMode = Objects.requireNonNull(objectiveDisplayMode);
            return this;
        }

        @Override
        public Objective.Builder from(Objective value) {
            Objects.requireNonNull(value);
            this.name = value.getName();
            this.displayName = value.getDisplayName();
            this.criterion = value.getCriterion();
            this.objectiveDisplayMode = value.getDisplayMode();
            return this;
        }

        @Override
        public Builder reset() {
            this.name = null;
            this.displayName = null;
            this.criterion = null;
            this.objectiveDisplayMode = null;
            return this;
        }

        @Override
        public Objective build() {
            if (this.name == null) {
                throw new IllegalStateException("Name cannot be null!");
            }
            if (this.criterion == null) {
                throw new IllegalStateException("Criterion cannot be null!");
            }
            SpongeObjective objective = new SpongeObjective(this.name, this.criterion);
            if (this.displayName != null) {
                objective.setDisplayName(this.displayName);
            }
            if (this.objectiveDisplayMode != null) {
                objective.setDisplayMode(this.objectiveDisplayMode);
            } else if (this.criterion instanceof ScoreCriteria) {
                objective.setDisplayMode((ObjectiveDisplayMode)((ScoreCriteria)this.criterion).func_178790_c());
            }
            return objective;
        }
    }
}

