/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.game.pagination;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.PeekingIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import org.spongepowered.api.command.exception.CommandException;
import org.spongepowered.common.service.game.pagination.ActivePagination;
import org.spongepowered.common.service.game.pagination.PaginationCalculator;

final class IterablePagination
extends ActivePagination {
    private final PeekingIterator<Map.Entry<Component, Integer>> countIterator;
    private int lastPage;

    public IterablePagination(Supplier<Optional<? extends Audience>> src, PaginationCalculator calc, Iterable<Map.Entry<Component, Integer>> counts, @Nullable Component title, @Nullable Component header, @Nullable Component footer, Component padding) {
        super(src, calc, title, header, footer, padding);
        this.countIterator = Iterators.peekingIterator(counts.iterator());
    }

    @Override
    protected Iterable<Component> getLines(int page) throws CommandException {
        Map.Entry ent;
        if (!this.countIterator.hasNext()) {
            throw new CommandException((Component)Component.text((String)"You're already at the end of the pagination list iterator."));
        }
        if (page < 1) {
            throw new CommandException((Component)Component.text((String)("Page " + page + " does not exist!")));
        }
        if (page <= this.lastPage) {
            throw new CommandException((Component)Component.text((String)"You cannot go to previous pages in an iterable pagination."));
        }
        if (page > this.lastPage + 1) {
            this.getLines(page - 1);
        }
        this.lastPage = page;
        if (this.getMaxContentLinesPerPage() <= 0) {
            return Lists.newArrayList((Iterator)Iterators.transform(this.countIterator, Map.Entry::getKey));
        }
        ArrayList<Component> ret = new ArrayList<Component>(this.getMaxContentLinesPerPage());
        for (int addedLines = 0; addedLines <= this.getMaxContentLinesPerPage(); addedLines += ((Integer)ent.getValue()).intValue()) {
            if (!this.countIterator.hasNext()) {
                if (page <= 1) break;
                this.padPage(ret, addedLines, false);
                break;
            }
            if (addedLines + (Integer)((Map.Entry)this.countIterator.peek()).getValue() > this.getMaxContentLinesPerPage()) {
                this.padPage(ret, addedLines, true);
                break;
            }
            ent = (Map.Entry)this.countIterator.next();
            ret.add((Component)ent.getKey());
        }
        return ret;
    }

    @Override
    protected boolean hasPrevious(int page) {
        return false;
    }

    @Override
    protected boolean hasNext(int page) {
        return page == this.getCurrentPage() && this.countIterator.hasNext();
    }

    @Override
    protected int getTotalPages() {
        return -1;
    }

    @Override
    public void previousPage() throws CommandException {
        throw new CommandException((Component)Component.text((String)"You cannot go to previous pages in an iterable pagination."));
    }
}

