/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.server.ban;

import com.google.inject.Singleton;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.server.management.BanList;
import net.minecraft.server.management.IPBanList;
import net.minecraft.server.management.UserList;
import net.minecraft.server.management.UserListEntry;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.service.ban.Ban;
import org.spongepowered.api.service.ban.BanService;
import org.spongepowered.api.service.ban.BanTypes;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.server.management.UserListAccessor;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.profile.SpongeGameProfile;
import org.spongepowered.common.util.UserListUtil;

@Singleton
public final class SpongeBanService
implements BanService {
    public Collection<Ban> getBans() {
        Collection<Ban> bans = this.getProfileBans();
        bans.addAll(this.getIpBans());
        return bans;
    }

    @Override
    public Collection<Ban.Profile> getProfileBans() {
        UserListAccessor accessor = (UserListAccessor)this.getUserBanList();
        accessor.invoker$removeExpired();
        return new ArrayList<Ban.Profile>(accessor.accessor$map().values());
    }

    @Override
    public Collection<Ban.IP> getIpBans() {
        UserListAccessor accessor = (UserListAccessor)this.getIPBanList();
        accessor.invoker$removeExpired();
        return new ArrayList<Ban.IP>(accessor.accessor$map().values());
    }

    @Override
    public Optional<Ban.Profile> getBanFor(GameProfile profile) {
        UserListAccessor accessor = (UserListAccessor)this.getUserBanList();
        accessor.invoker$removeExpired();
        return Optional.ofNullable((Ban.Profile)accessor.accessor$map().get(accessor.invoker$getKeyForUser(SpongeGameProfile.toMcProfile(profile))));
    }

    @Override
    public Optional<Ban.IP> getBanFor(InetAddress address) {
        UserListAccessor accessor = (UserListAccessor)this.getIPBanList();
        accessor.invoker$removeExpired();
        return Optional.ofNullable((Ban.IP)accessor.accessor$map().get(accessor.invoker$getKeyForUser(((IPBanList)accessor).func_152707_c((SocketAddress)new InetSocketAddress(address, 0)))));
    }

    @Override
    public boolean isBanned(GameProfile profile) {
        UserListAccessor accessor = (UserListAccessor)this.getUserBanList();
        accessor.invoker$removeExpired();
        return accessor.accessor$map().containsKey(accessor.invoker$getKeyForUser(SpongeGameProfile.toMcProfile(profile)));
    }

    @Override
    public boolean isBanned(InetAddress address) {
        UserListAccessor accessor = (UserListAccessor)this.getIPBanList();
        accessor.invoker$removeExpired();
        return accessor.accessor$map().containsKey(accessor.invoker$getKeyForUser(((IPBanList)accessor).func_152707_c((SocketAddress)new InetSocketAddress(address, 0))));
    }

    @Override
    public boolean pardon(GameProfile profile) {
        Optional<Ban.Profile> ban = this.getBanFor(profile);
        UserListAccessor accessor = (UserListAccessor)this.getUserBanList();
        accessor.invoker$removeExpired();
        return ban.isPresent() && this.removeBan(ban.get());
    }

    @Override
    public boolean pardon(InetAddress address) {
        Optional<Ban.IP> ban = this.getBanFor(address);
        UserListAccessor accessor = (UserListAccessor)this.getIPBanList();
        accessor.invoker$removeExpired();
        return ban.isPresent() && this.removeBan(ban.get());
    }

    @Override
    public boolean removeBan(Ban ban) {
        if (!this.hasBan(ban)) {
            return false;
        }
        if (ban.getType().equals(BanTypes.PROFILE.get())) {
            User user = Sponge.getServer().getUserManager().getOrCreate(((Ban.Profile)ban).getProfile());
            Sponge.getEventManager().post(SpongeEventFactory.createPardonUserEvent(PhaseTracker.getCauseStackManager().getCurrentCause(), (Ban.Profile)ban, user));
            UserListUtil.removeEntry((UserList)this.getUserBanList(), ((Ban.Profile)ban).getProfile());
            return true;
        }
        if (ban.getType().equals(BanTypes.IP.get())) {
            Sponge.getEventManager().post(SpongeEventFactory.createPardonIpEvent(PhaseTracker.getCauseStackManager().getCurrentCause(), (Ban.IP)ban));
            InetSocketAddress inetSocketAddress = new InetSocketAddress(((Ban.IP)ban).getAddress(), 0);
            UserListUtil.removeEntry((UserList)this.getIPBanList(), this.getIPBanList().func_152707_c((SocketAddress)inetSocketAddress));
            return true;
        }
        throw new IllegalArgumentException(String.format("Ban %s had unrecognized BanType %s!", ban, ban.getType()));
    }

    @Override
    public Optional<? extends Ban> addBan(Ban ban) {
        Optional<Ban> prevBan;
        if (ban.getType().equals(BanTypes.PROFILE.get())) {
            prevBan = this.getBanFor(((Ban.Profile)ban).getProfile());
            User user = Sponge.getServer().getUserManager().getOrCreate(((Ban.Profile)ban).getProfile());
            Sponge.getEventManager().post(SpongeEventFactory.createBanUserEvent(PhaseTracker.getCauseStackManager().getCurrentCause(), (Ban.Profile)ban, user));
            UserListUtil.addEntry((UserList)this.getUserBanList(), (UserListEntry)ban);
        } else if (ban.getType().equals(BanTypes.IP.get())) {
            prevBan = this.getBanFor(((Ban.IP)ban).getAddress());
            Sponge.getEventManager().post(SpongeEventFactory.createBanIpEvent(PhaseTracker.getCauseStackManager().getCurrentCause(), (Ban.IP)ban));
            UserListUtil.addEntry((UserList)this.getIPBanList(), (UserListEntry)ban);
        } else {
            throw new IllegalArgumentException(String.format("Ban %s had unrecognized BanType %s!", ban, ban.getType()));
        }
        return prevBan;
    }

    @Override
    public boolean hasBan(Ban ban) {
        if (ban.getType().equals(BanTypes.PROFILE.get())) {
            return this.isBanned(((Ban.Profile)ban).getProfile());
        }
        if (ban.getType().equals(BanTypes.IP.get())) {
            return this.isBanned(((Ban.IP)ban).getAddress());
        }
        throw new IllegalArgumentException(String.format("Ban %s had unrecognized BanType %s!", ban, ban.getType()));
    }

    private BanList getUserBanList() {
        return SpongeCommon.getServer().func_184103_al().func_152608_h();
    }

    private IPBanList getIPBanList() {
        return SpongeCommon.getServer().func_184103_al().func_72363_f();
    }
}

