/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.server.ban;

import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.server.management.IPBanEntry;
import net.minecraft.server.management.IPBanList;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.service.ban.Ban;
import org.spongepowered.common.util.NetworkUtil;

public final class SpongeIPBanList
extends IPBanList {
    public SpongeIPBanList(File file) {
        super(file);
    }

    protected boolean contains(String entry) {
        if (entry.equals("local")) {
            return false;
        }
        try {
            return Sponge.getServer().getServiceProvider().banService().isBanned(InetAddress.getByName(entry));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Error parsing Ban IP address!", e);
        }
    }

    @Nullable
    public IPBanEntry get(String obj) {
        if (obj.equals("local")) {
            return null;
        }
        try {
            return Sponge.getServer().getServiceProvider().banService().getBanFor(InetAddress.getByName(obj)).orElse(null);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Error parsing Ban IP address!", e);
        }
    }

    public void remove(String entry) {
        if (entry.equals("local")) {
            return;
        }
        try {
            Sponge.getServer().getServiceProvider().banService().pardon(InetAddress.getByName(entry));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Error parsing Ban IP address!", e);
        }
    }

    public String[] func_152685_a() {
        ArrayList<String> ips = new ArrayList<String>();
        for (Ban.IP ban : Sponge.getServer().getServiceProvider().banService().getIpBans()) {
            ips.add(this.func_152707_c(new InetSocketAddress(ban.getAddress(), 0)));
        }
        return ips.toArray(new String[0]);
    }

    public void add(IPBanEntry entry) {
        Sponge.getServer().getServiceProvider().banService().addBan((Ban)entry);
    }

    public boolean func_152690_d() {
        return Sponge.getServer().getServiceProvider().banService().getIpBans().isEmpty();
    }

    public String func_152707_c(SocketAddress address) {
        return NetworkUtil.getHostString(address);
    }
}

