/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.service.server.permission;

import com.google.common.base.Preconditions;
import com.mojang.authlib.GameProfile;
import java.util.Optional;
import java.util.Set;
import net.minecraft.server.management.OpEntry;
import net.minecraft.server.management.UserListEntry;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.permission.MemorySubjectData;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.service.permission.SubjectCollection;
import org.spongepowered.api.service.permission.SubjectReference;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.service.server.permission.OpLevelCollection;
import org.spongepowered.common.service.server.permission.SingleParentMemorySubjectData;
import org.spongepowered.common.service.server.permission.SpongePermissionService;
import org.spongepowered.common.service.server.permission.SpongeSubject;
import org.spongepowered.common.service.server.permission.UserCollection;

public class UserSubject
extends SpongeSubject {
    private final GameProfile player;
    private final MemorySubjectData data;
    private final UserCollection collection;

    public UserSubject(final GameProfile player, final UserCollection users) {
        this.player = (GameProfile)Preconditions.checkNotNull((Object)player);
        this.data = new SingleParentMemorySubjectData(this){

            @Override
            public SubjectReference getParent() {
                return users.getService().getGroupForOpLevel(UserSubject.this.getOpLevel()).asSubjectReference();
            }

            @Override
            public void setParent(SubjectReference parent) {
                int opLevel;
                if (parent == null) {
                    opLevel = 0;
                } else {
                    if (!(parent.resolve().join() instanceof OpLevelCollection.OpLevelSubject)) {
                        return;
                    }
                    opLevel = ((OpLevelCollection.OpLevelSubject)((Object)parent)).getOpLevel();
                }
                if (opLevel > 0) {
                    SpongePermissionService.getOps().func_152687_a((UserListEntry)new OpEntry(player, opLevel, false));
                } else {
                    SpongePermissionService.getOps().func_152684_c((Object)player);
                }
            }
        };
        this.collection = users;
    }

    @Override
    public String getIdentifier() {
        return this.player.getId().toString();
    }

    @Override
    public Optional<String> getFriendlyIdentifier() {
        return Optional.of(this.player.getName());
    }

    int getOpLevel() {
        Preconditions.checkState((boolean)Sponge.isServerAvailable(), (Object)"Server is not available!");
        OpEntry entry = (OpEntry)SpongePermissionService.getOps().func_152683_b((Object)this.player);
        if (entry == null) {
            return SpongeCommon.getServer().func_184103_al().func_152596_g(this.player) ? SpongeCommon.getServer().func_110455_j() : 0;
        }
        return entry.func_152644_a();
    }

    @Override
    public SubjectCollection getContainingCollection() {
        return this.collection;
    }

    @Override
    public MemorySubjectData getSubjectData() {
        return this.data;
    }

    @Override
    public PermissionService getService() {
        return this.collection.getService();
    }

    @Override
    public Tristate getPermissionValue(Set<Context> contexts, String permission) {
        Tristate ret = super.getPermissionValue(contexts, permission);
        if (ret == Tristate.UNDEFINED) {
            ret = this.getDataPermissionValue(this.collection.getDefaults().getSubjectData(), permission);
        }
        if (ret == Tristate.UNDEFINED) {
            ret = this.getDataPermissionValue(this.collection.getService().getDefaults().getSubjectData(), permission);
        }
        if (ret == Tristate.UNDEFINED && this.getOpLevel() >= SpongePermissionService.getServerOpLevel()) {
            ret = Tristate.TRUE;
        }
        return ret;
    }

    @Override
    public Optional<String> getOption(Set<Context> contexts, String option) {
        Optional<String> ret = super.getOption(contexts, option);
        if (!ret.isPresent()) {
            ret = this.getDataOptionValue(this.collection.getDefaults().getSubjectData(), option);
        }
        if (!ret.isPresent()) {
            ret = this.getDataOptionValue(this.collection.getService().getDefaults().getSubjectData(), option);
        }
        return ret;
    }
}

