/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.user;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.storage.PlayerData;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Server;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.profile.GameProfileCache;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.server.management.PlayerListAccessor;
import org.spongepowered.common.accessor.world.storage.PlayerDataAccessor;
import org.spongepowered.common.entity.player.SpongeUser;
import org.spongepowered.common.profile.SpongeGameProfile;

public final class ServerUserProvider {
    private final MinecraftServer server;
    private final Set<UUID> knownUUIDs = new HashSet<UUID>();
    private final Cache<UUID, User> userCache;
    private final Map<String, MutableWatchEvent> watcherUpdateMap = new HashMap<String, MutableWatchEvent>();
    private @Nullable WatchService filesystemWatchService = null;
    private @Nullable WatchKey watchKey = null;

    public ServerUserProvider(Server server) {
        this.userCache = Caffeine.newBuilder().expireAfterAccess(1L, TimeUnit.DAYS).build();
        this.server = (MinecraftServer)server;
    }

    void setupWatchers() {
        this.teardownWatchers();
        try {
            this.filesystemWatchService = FileSystems.getDefault().newWatchService();
            this.watchKey = this.getSaveHandlerDirectory().register(this.filesystemWatchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE);
        }
        catch (IOException e) {
            SpongeCommon.getLogger().warn("Could not start file watcher");
            if (this.filesystemWatchService != null) {
                try {
                    this.filesystemWatchService.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.watchKey = null;
            this.filesystemWatchService = null;
        }
    }

    void teardownWatchers() {
        if (this.watchKey != null) {
            this.watchKey.cancel();
            this.watchKey = null;
        }
        if (this.filesystemWatchService != null) {
            try {
                this.filesystemWatchService.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.filesystemWatchService = null;
            }
        }
    }

    void refreshFilesystemProfiles() {
        String[] uuids;
        if (this.watchKey != null && this.watchKey.isValid()) {
            this.watchKey.reset();
        }
        this.knownUUIDs.clear();
        this.userCache.invalidateAll();
        for (String playerUuid : uuids = this.getSaveHandler().func_237334_a_()) {
            UUID uuid;
            if (playerUuid.contains(".")) continue;
            try {
                uuid = UUID.fromString(playerUuid);
            }
            catch (Exception ex) {
                continue;
            }
            this.knownUUIDs.add(uuid);
        }
    }

    Optional<User> getUser(String lastKnownName) {
        com.mojang.authlib.GameProfile gameProfile = this.server.func_152358_ax().func_152655_a(lastKnownName);
        if (gameProfile == null) {
            return Optional.empty();
        }
        return this.getUser(SpongeGameProfile.of(gameProfile));
    }

    Optional<User> getUser(UUID uuid) {
        com.mojang.authlib.GameProfile gameProfile = this.server.func_152358_ax().func_152652_a(uuid);
        return this.getUser(gameProfile == null ? null : SpongeGameProfile.of(gameProfile));
    }

    Optional<User> getUser(@Nullable GameProfile profile) {
        this.pollFilesystemWatcher();
        if (profile != null && this.knownUUIDs.contains(profile.getUniqueId())) {
            return Optional.of(this.getOrCreateUser(profile, false));
        }
        return Optional.empty();
    }

    User getOrCreateUser(GameProfile profile, boolean force) {
        com.mojang.authlib.GameProfile resolvedProfile;
        if (!force) {
            UUID userID = profile.getUniqueId();
            User currentUser = (User)this.userCache.getIfPresent((Object)userID);
            if (currentUser != null) {
                return currentUser;
            }
            com.mojang.authlib.GameProfile p = this.server.func_152358_ax().func_152652_a(userID);
            resolvedProfile = p == null ? SpongeGameProfile.toMcProfile(profile) : p;
        } else {
            resolvedProfile = SpongeGameProfile.toMcProfile(profile);
            User currentUser = (User)this.userCache.getIfPresent((Object)profile.getUniqueId());
            if (currentUser != null && SpongeUser.dirtyUsers.contains(currentUser)) {
                ((SpongeUser)currentUser).save();
                ((SpongeUser)currentUser).invalidate();
            }
        }
        this.pollFilesystemWatcher();
        SpongeUser user = new SpongeUser(resolvedProfile);
        this.userCache.put((Object)profile.getUniqueId(), (Object)user);
        this.knownUUIDs.add(profile.getUniqueId());
        return user;
    }

    boolean deleteUser(UUID uuid) {
        if (this.deleteStoredPlayerData(uuid)) {
            this.userCache.invalidate((Object)uuid);
            this.knownUUIDs.remove(uuid);
            return true;
        }
        return false;
    }

    Stream<GameProfile> matchKnownProfiles(String lowercaseName) {
        return ((Server)this.server).getGameProfileManager().getCache().streamOfMatches(lowercaseName).filter(gameProfile -> this.knownUUIDs.contains(gameProfile.getUniqueId()));
    }

    Stream<GameProfile> streamAll() {
        GameProfileCache cache = ((Server)this.server).getGameProfileManager().getCache();
        return this.knownUUIDs.stream().map(x -> cache.getById((UUID)x).orElseGet(() -> GameProfile.of(x)));
    }

    private Path getPlayerDataFile(UUID uniqueId) {
        Path file = this.getSaveHandlerDirectory().resolve(uniqueId.toString() + ".dat");
        if (Files.exists(file, new LinkOption[0])) {
            return file;
        }
        return null;
    }

    private boolean deleteStoredPlayerData(UUID uniqueId) {
        Path dataFile = this.getPlayerDataFile(uniqueId);
        if (dataFile != null) {
            try {
                return Files.deleteIfExists(dataFile);
            }
            catch (IOException | SecurityException e) {
                SpongeCommon.getLogger().warn("Unable to delete file {}", (Object)dataFile, (Object)e);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pollFilesystemWatcher() {
        if (this.watchKey == null || !this.watchKey.isValid()) {
            this.refreshFilesystemProfiles();
            this.setupWatchers();
            return;
        }
        Map<String, MutableWatchEvent> map = this.watcherUpdateMap;
        synchronized (map) {
            this.watcherUpdateMap.clear();
            for (WatchEvent<?> watchEvent : this.watchKey.pollEvents()) {
                WatchEvent<?> ev = watchEvent;
                Path file = (Path)ev.context();
                if (file == null) continue;
                String filename = file.getFileName().toString();
                this.watcherUpdateMap.computeIfAbsent(filename, f -> new MutableWatchEvent()).set(ev.kind());
            }
            for (Map.Entry entry : this.watcherUpdateMap.entrySet()) {
                String name;
                WatchEvent.Kind<?> kind = ((MutableWatchEvent)entry.getValue()).get();
                if (kind == null || !(name = (String)entry.getKey()).endsWith(".dat")) continue;
                try {
                    UUID uuid = UUID.fromString(name.substring(0, name.length() - 4));
                    if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
                        this.knownUUIDs.add(uuid);
                        continue;
                    }
                    this.knownUUIDs.remove(uuid);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
    }

    private PlayerData getSaveHandler() {
        return ((PlayerListAccessor)this.server.func_184103_al()).accessor$playerIo();
    }

    private Path getSaveHandlerDirectory() {
        return ((PlayerDataAccessor)this.getSaveHandler()).accessor$playerDir().toPath();
    }

    private static final class MutableWatchEvent {
        private WatchEvent.Kind<?> kind = null;

        private MutableWatchEvent() {
        }

        public WatchEvent.Kind<?> get() {
            return this.kind;
        }

        public void set(WatchEvent.Kind<?> kind) {
            if (kind == StandardWatchEventKinds.ENTRY_MODIFY) {
                kind = StandardWatchEventKinds.ENTRY_CREATE;
            }
            if (kind == StandardWatchEventKinds.ENTRY_CREATE || kind == StandardWatchEventKinds.ENTRY_DELETE) {
                this.kind = this.kind != null && this.kind != kind ? null : kind;
            }
        }
    }
}

