/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.particles.RedstoneParticleData;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.effect.particle.ParticleOption;
import org.spongepowered.api.effect.particle.ParticleOptions;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.util.Color;
import org.spongepowered.math.vector.Vector3d;

public final class ParticleOptionUtil {
    public static ImmutableMap<ParticleOption<?>, Object> generateDefaultsForNamed(ParticleType<?> type) {
        HashMap<ParticleOption<Color>, Object> options = new HashMap<ParticleOption<Color>, Object>();
        options.put(ParticleOptions.OFFSET.get(), Vector3d.ZERO);
        options.put(ParticleOptions.QUANTITY.get(), 1);
        if (type.func_197571_g() == BlockParticleData.field_197585_a) {
            options.put(ParticleOptions.BLOCK_STATE.get(), BlockTypes.AIR.get().getDefaultState());
        } else if (type.func_197571_g() == ItemParticleData.field_197557_a) {
            options.put(ParticleOptions.ITEM_STACK_SNAPSHOT.get(), ItemStackSnapshot.empty());
        } else if (type.func_197571_g() == RedstoneParticleData.field_197565_b) {
            options.put(ParticleOptions.COLOR.get(), Color.RED);
        }
        return ImmutableMap.copyOf(options);
    }

    private ParticleOptionUtil() {
    }
}

