/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.properties.BedPart;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.state.properties.Half;
import org.spongepowered.api.data.type.PortionType;
import org.spongepowered.api.data.type.PortionTypes;

public final class PortionTypeUtil {
    @Nullable
    public static PortionType getFromBedBlock(BlockState holder, EnumProperty<BedPart> property) {
        BedPart part = (BedPart)holder.func_177229_b(property);
        switch (part) {
            case HEAD: {
                return PortionTypes.TOP.get();
            }
            case FOOT: {
                return PortionTypes.BOTTOM.get();
            }
        }
        return null;
    }

    @Nullable
    public static BlockState setForBedBlock(BlockState holder, PortionType value, EnumProperty<BedPart> property) {
        if (value == PortionTypes.TOP.get()) {
            return (BlockState)holder.func_206870_a(property, (Comparable)BedPart.HEAD);
        }
        if (value == PortionTypes.BOTTOM.get()) {
            return (BlockState)holder.func_206870_a(property, (Comparable)BedPart.FOOT);
        }
        return null;
    }

    public static PortionType getFromDoubleBlock(BlockState holder, EnumProperty<DoubleBlockHalf> property) {
        DoubleBlockHalf half = (DoubleBlockHalf)holder.func_177229_b(property);
        return half == DoubleBlockHalf.LOWER ? PortionTypes.BOTTOM.get() : PortionTypes.TOP.get();
    }

    public static BlockState setForDoubleBlock(BlockState holder, PortionType value, EnumProperty<DoubleBlockHalf> property) {
        DoubleBlockHalf half = value == PortionTypes.TOP.get() ? DoubleBlockHalf.UPPER : DoubleBlockHalf.LOWER;
        return (BlockState)holder.func_206870_a(property, (Comparable)half);
    }

    public static PortionType getFromHalfBlock(BlockState holder, EnumProperty<Half> property) {
        Half half = (Half)holder.func_177229_b(property);
        return half == Half.BOTTOM ? PortionTypes.BOTTOM.get() : PortionTypes.TOP.get();
    }

    public static BlockState setForHalfBlock(BlockState holder, PortionType value, EnumProperty<Half> property) {
        Half half = value == PortionTypes.TOP.get() ? Half.TOP : Half.BOTTOM;
        return (BlockState)holder.func_206870_a(property, (Comparable)half);
    }

    private PortionTypeUtil() {
    }
}

