/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util;

import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Rotations;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import org.spongepowered.api.util.AABB;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.common.util.SpongeAABB;
import org.spongepowered.common.world.server.SpongeServerLocation;
import org.spongepowered.math.vector.Vector2i;

public final class VecHelper {
    public static BlockPos toBlockPos(org.spongepowered.math.vector.Vector3d vector) {
        if (vector == null) {
            return null;
        }
        return new BlockPos(vector.getX(), vector.getY(), vector.getZ());
    }

    public static BlockPos toBlockPos(org.spongepowered.math.vector.Vector3i vector) {
        if (vector == null) {
            return null;
        }
        return new BlockPos(vector.getX(), vector.getY(), vector.getZ());
    }

    public static BlockPos toBlockPos(ServerLocation location) {
        if (location == null) {
            return null;
        }
        return ((SpongeServerLocation)location).asBlockPos();
    }

    public static org.spongepowered.math.vector.Vector3i toVector3i(BlockPos pos) {
        if (pos == null) {
            return null;
        }
        return new org.spongepowered.math.vector.Vector3i(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static org.spongepowered.math.vector.Vector3d toVector3d(BlockPos pos) {
        if (pos == null) {
            return null;
        }
        return new org.spongepowered.math.vector.Vector3d((float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)pos.func_177952_p());
    }

    public static org.spongepowered.math.vector.Vector3d toVector3d(Rotations rotation) {
        if (rotation == null) {
            return null;
        }
        return new org.spongepowered.math.vector.Vector3d(rotation.func_179415_b(), rotation.func_179416_c(), rotation.func_179413_d());
    }

    public static org.spongepowered.math.vector.Vector3i toVector3i(Vector3i vector) {
        if (vector == null) {
            return null;
        }
        return new org.spongepowered.math.vector.Vector3i(vector.func_177958_n(), vector.func_177956_o(), vector.func_177952_p());
    }

    public static Vector3i toVanillaVector3i(org.spongepowered.math.vector.Vector3i vector) {
        if (vector == null) {
            return null;
        }
        return new Vector3i(vector.getX(), vector.getY(), vector.getZ());
    }

    public static Vector3d toVanillaVector3d(org.spongepowered.math.vector.Vector3d vector) {
        if (vector == null) {
            return null;
        }
        return new Vector3d(vector.getX(), vector.getY(), vector.getZ());
    }

    public static Vector3d toVanillaVector3d(BlockPos pos) {
        if (pos == null) {
            return null;
        }
        return new Vector3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
    }

    public static Vector3i toVector3i(ChunkPos pos) {
        if (pos == null) {
            return null;
        }
        return new Vector3i(pos.field_77276_a, 0, pos.field_77275_b);
    }

    public static ChunkPos toChunkPos(Vector3i vector) {
        if (vector == null) {
            return null;
        }
        return new ChunkPos(vector.func_177958_n(), vector.func_177952_p());
    }

    public static org.spongepowered.math.vector.Vector3d toVector3d(Vector3d vector) {
        if (vector == null) {
            return null;
        }
        return new org.spongepowered.math.vector.Vector3d(vector.field_72450_a, vector.field_72448_b, vector.field_72449_c);
    }

    public static Vector3i toVector3i(org.spongepowered.math.vector.Vector3d vector) {
        if (vector == null) {
            return null;
        }
        return new Vector3i(vector.getX(), vector.getY(), vector.getZ());
    }

    public static Rotations toRotation(org.spongepowered.math.vector.Vector3d vector) {
        if (vector == null) {
            return null;
        }
        return new Rotations((float)vector.getX(), (float)vector.getY(), (float)vector.getZ());
    }

    public static boolean inBounds(int x, int y, Vector2i min2, Vector2i max) {
        return x >= min2.getX() && x <= max.getX() && y >= min2.getY() && y <= max.getY();
    }

    public static boolean inBounds(int x, int y, int z, Vector3i min2, Vector3i max) {
        return x >= min2.func_177958_n() && x <= max.func_177958_n() && y >= min2.func_177956_o() && y <= max.func_177956_o() && z >= min2.func_177952_p() && z <= max.func_177952_p();
    }

    public static boolean inBounds(BlockPos pos, org.spongepowered.math.vector.Vector3i min2, org.spongepowered.math.vector.Vector3i max) {
        return VecHelper.inBounds((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), min2, max);
    }

    public static boolean inBounds(org.spongepowered.math.vector.Vector3d pos, org.spongepowered.math.vector.Vector3i min2, org.spongepowered.math.vector.Vector3i max) {
        return VecHelper.inBounds(pos.getX(), pos.getY(), pos.getZ(), min2, max);
    }

    public static boolean inBounds(double x, double y, double z, org.spongepowered.math.vector.Vector3i min2, org.spongepowered.math.vector.Vector3i max) {
        return x >= (double)min2.getX() && x <= (double)max.getX() && y >= (double)min2.getY() && y <= (double)max.getY() && z >= (double)min2.getZ() && z <= (double)max.getZ();
    }

    public static AxisAlignedBB toMinecraftAABB(AABB box) {
        if (box == null) {
            return null;
        }
        org.spongepowered.math.vector.Vector3d min2 = box.getMin();
        org.spongepowered.math.vector.Vector3d max = box.getMax();
        return new AxisAlignedBB(min2.getX(), min2.getY(), min2.getZ(), max.getX(), max.getY(), max.getZ());
    }

    public static AABB toSpongeAABB(AxisAlignedBB box) {
        if (box == null) {
            return null;
        }
        return new SpongeAABB(new org.spongepowered.math.vector.Vector3d(box.field_72340_a, box.field_72338_b, box.field_72339_c), new org.spongepowered.math.vector.Vector3d(box.field_72336_d, box.field_72337_e, box.field_72334_f));
    }

    public static CompoundNBT toCompound(org.spongepowered.math.vector.Vector3d vector) {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74780_a("x", vector.getX());
        compound.func_74780_a("y", vector.getY());
        compound.func_74780_a("z", vector.getZ());
        return compound;
    }

    public static org.spongepowered.math.vector.Vector3d fromCompound(CompoundNBT compound) {
        return new org.spongepowered.math.vector.Vector3d(compound.func_74769_h("x"), compound.func_74769_h("y"), compound.func_74769_h("z"));
    }

    private VecHelper() {
    }
}

