/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.biome;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.CheckerboardBiomeProvider;
import net.minecraft.world.biome.provider.EndBiomeProvider;
import net.minecraft.world.biome.provider.NetherBiomeProvider;
import net.minecraft.world.biome.provider.OverworldBiomeProvider;
import net.minecraft.world.biome.provider.SingleBiomeProvider;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.registry.RegistryReference;
import org.spongepowered.api.world.biome.AttributedBiome;
import org.spongepowered.api.world.biome.provider.BiomeProvider;
import org.spongepowered.api.world.biome.provider.CheckerboardBiomeConfig;
import org.spongepowered.api.world.biome.provider.ConfigurableBiomeProvider;
import org.spongepowered.api.world.biome.provider.EndStyleBiomeConfig;
import org.spongepowered.api.world.biome.provider.LayeredBiomeConfig;
import org.spongepowered.api.world.biome.provider.MultiNoiseBiomeConfig;
import org.spongepowered.common.accessor.world.biome.provider.BiomeProviderAccessor;
import org.spongepowered.common.accessor.world.biome.provider.EndBiomeProviderAccessor;
import org.spongepowered.common.accessor.world.biome.provider.NetherBiomeProviderAccessor;
import org.spongepowered.common.server.BootstrapProperties;

public final class SpongeBiomeProviderFactory
implements BiomeProvider.Factory {
    @Override
    public <T extends LayeredBiomeConfig> ConfigurableBiomeProvider<T> layered(T config) {
        MutableRegistry biomeRegistry = BootstrapProperties.registries.func_243612_b(Registry.field_239720_u_);
        OverworldBiomeProvider layeredBiomeProvider = new OverworldBiomeProvider(config.seed(), config.largeBiomes(), false, (Registry)biomeRegistry);
        ArrayList<Biome> biomes = new ArrayList<Biome>();
        for (RegistryReference<org.spongepowered.api.world.biome.Biome> biome : config.biomes()) {
            biomes.add((Biome)biomeRegistry.func_82594_a((ResourceLocation)biome.location()));
        }
        ((BiomeProviderAccessor)layeredBiomeProvider).accessor$possibleBiomes(biomes);
        return (ConfigurableBiomeProvider)layeredBiomeProvider;
    }

    @Override
    public ConfigurableBiomeProvider<LayeredBiomeConfig> overworld() {
        return (ConfigurableBiomeProvider)new OverworldBiomeProvider(BootstrapProperties.dimensionGeneratorSettings.func_236221_b_(), false, false, (Registry)BootstrapProperties.registries.func_243612_b(Registry.field_239720_u_));
    }

    @Override
    public <T extends MultiNoiseBiomeConfig> ConfigurableBiomeProvider<T> multiNoise(T config) {
        MutableRegistry biomeRegistry = BootstrapProperties.registries.func_243612_b(Registry.field_239720_u_);
        ArrayList<Pair<Biome.Attributes, Supplier<Biome>>> attributedBiomes = new ArrayList<Pair<Biome.Attributes, Supplier<Biome>>>();
        for (AttributedBiome attributedBiome : config.attributedBiomes()) {
            attributedBiomes.add(Pair.of((Object)((Biome.Attributes)attributedBiome.attributes()), () -> (Biome)biomeRegistry.func_82594_a((ResourceLocation)attributedBiome.biome().location())));
        }
        return (ConfigurableBiomeProvider)NetherBiomeProviderAccessor.invoker$new(config.seed(), attributedBiomes, (NetherBiomeProvider.Noise)config.temperatureConfig(), (NetherBiomeProvider.Noise)config.humidityConfig(), (NetherBiomeProvider.Noise)config.altitudeConfig(), (NetherBiomeProvider.Noise)config.weirdnessConfig(), Optional.empty());
    }

    @Override
    public ConfigurableBiomeProvider<MultiNoiseBiomeConfig> nether() {
        return (ConfigurableBiomeProvider)NetherBiomeProvider.Preset.field_235288_b_.func_242619_a((Registry)BootstrapProperties.registries.func_243612_b(Registry.field_239720_u_), BootstrapProperties.dimensionGeneratorSettings.func_236221_b_());
    }

    @Override
    public <T extends EndStyleBiomeConfig> ConfigurableBiomeProvider<T> endStyle(T config) {
        MutableRegistry registry = BootstrapProperties.registries.func_243612_b(Registry.field_239720_u_);
        return (ConfigurableBiomeProvider)EndBiomeProviderAccessor.invoker$new((Registry<Biome>)registry, config.seed(), (Biome)registry.func_82594_a((ResourceLocation)config.endBiome().location()), (Biome)registry.func_82594_a((ResourceLocation)config.highlandsBiome().location()), (Biome)registry.func_82594_a((ResourceLocation)config.midlandsBiome().location()), (Biome)registry.func_82594_a((ResourceLocation)config.islandsBiome().location()), (Biome)registry.func_82594_a((ResourceLocation)config.barrensBiome().location()));
    }

    @Override
    public ConfigurableBiomeProvider<EndStyleBiomeConfig> end() {
        return (ConfigurableBiomeProvider)new EndBiomeProvider((Registry)BootstrapProperties.registries.func_243612_b(Registry.field_239720_u_), BootstrapProperties.dimensionGeneratorSettings.func_236221_b_());
    }

    @Override
    public <T extends CheckerboardBiomeConfig> ConfigurableBiomeProvider<T> checkerboard(T config) {
        ArrayList<Supplier<Biome>> biomes = new ArrayList<Supplier<Biome>>();
        for (RegistryReference<org.spongepowered.api.world.biome.Biome> biome : config.biomes()) {
            biomes.add(() -> (Biome)BootstrapProperties.registries.func_243612_b(Registry.field_239720_u_).func_82594_a((ResourceLocation)biome.location()));
        }
        return (ConfigurableBiomeProvider)new CheckerboardBiomeProvider(biomes, config.scale());
    }

    @Override
    public BiomeProvider fixed(RegistryReference<org.spongepowered.api.world.biome.Biome> biome) {
        Objects.requireNonNull(biome, "biome");
        return (BiomeProvider)new SingleBiomeProvider(() -> (Biome)biome.get(Sponge.getServer().registries()));
    }
}

