/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.biome.provider;

import com.google.common.collect.Lists;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.registry.RegistryReference;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.biome.Biomes;
import org.spongepowered.api.world.biome.provider.EndStyleBiomeConfig;
import org.spongepowered.common.server.BootstrapProperties;
import org.spongepowered.common.world.biome.provider.AbstractBiomeProviderConfig;

public final class SpongeEndStyleBiomeConfig
extends AbstractBiomeProviderConfig
implements EndStyleBiomeConfig {
    private final long seed;
    private final RegistryReference<Biome> endBiome;
    private final RegistryReference<Biome> highlandsBiome;
    private final RegistryReference<Biome> midlandsBiome;
    private final RegistryReference<Biome> islandsBiome;
    private final RegistryReference<Biome> barrensBiome;

    protected SpongeEndStyleBiomeConfig(BuilderImpl builder) {
        super(Lists.newArrayList((Object[])new RegistryReference[]{builder.endBiome, builder.highlandsBiome, builder.midlandsBiome, builder.islandsBiome, builder.barrensBiome}));
        this.seed = builder.seed;
        this.endBiome = builder.endBiome;
        this.highlandsBiome = builder.highlandsBiome;
        this.midlandsBiome = builder.midlandsBiome;
        this.islandsBiome = builder.islandsBiome;
        this.barrensBiome = builder.barrensBiome;
    }

    @Override
    public long seed() {
        return this.seed;
    }

    @Override
    public RegistryReference<Biome> endBiome() {
        return this.endBiome;
    }

    @Override
    public RegistryReference<Biome> highlandsBiome() {
        return this.highlandsBiome;
    }

    @Override
    public RegistryReference<Biome> midlandsBiome() {
        return this.midlandsBiome;
    }

    @Override
    public RegistryReference<Biome> islandsBiome() {
        return this.islandsBiome;
    }

    @Override
    public RegistryReference<Biome> barrensBiome() {
        return this.barrensBiome;
    }

    public static final class BuilderImpl
    implements EndStyleBiomeConfig.Builder {
        public long seed;
        public RegistryReference<Biome> endBiome;
        public RegistryReference<Biome> highlandsBiome;
        public RegistryReference<Biome> midlandsBiome;
        public RegistryReference<Biome> islandsBiome;
        public RegistryReference<Biome> barrensBiome;

        @Override
        public EndStyleBiomeConfig.Builder seed(long seed) {
            this.seed = seed;
            return this;
        }

        @Override
        public EndStyleBiomeConfig.Builder endBiome(RegistryReference<Biome> endBiome) {
            this.endBiome = Objects.requireNonNull(endBiome, "endBiome");
            return this;
        }

        @Override
        public EndStyleBiomeConfig.Builder highlandsBiome(RegistryReference<Biome> highlandsBiome) {
            this.highlandsBiome = Objects.requireNonNull(highlandsBiome, "highlandsBiome");
            return this;
        }

        @Override
        public EndStyleBiomeConfig.Builder midlandsBiome(RegistryReference<Biome> midlandsBiome) {
            this.midlandsBiome = Objects.requireNonNull(midlandsBiome, "midlandsBiome");
            return this;
        }

        @Override
        public EndStyleBiomeConfig.Builder islandsBiome(RegistryReference<Biome> islandsBiome) {
            this.islandsBiome = Objects.requireNonNull(islandsBiome, "islandsBiome");
            return this;
        }

        @Override
        public EndStyleBiomeConfig.Builder barrensBiome(RegistryReference<Biome> barrensBiome) {
            this.barrensBiome = Objects.requireNonNull(barrensBiome, "barrensBiome");
            return this;
        }

        @Override
        public EndStyleBiomeConfig.Builder from(EndStyleBiomeConfig value) {
            this.seed = Objects.requireNonNull(value, "value").seed();
            this.endBiome = value.endBiome();
            this.highlandsBiome = value.highlandsBiome();
            this.midlandsBiome = value.midlandsBiome();
            this.islandsBiome = value.islandsBiome();
            this.barrensBiome = value.barrensBiome();
            return this;
        }

        @Override
        public EndStyleBiomeConfig.Builder reset() {
            this.seed = BootstrapProperties.dimensionGeneratorSettings.func_236221_b_();
            this.endBiome = Biomes.THE_END;
            this.highlandsBiome = Biomes.END_HIGHLANDS;
            this.midlandsBiome = Biomes.END_MIDLANDS;
            this.islandsBiome = Biomes.SMALL_END_ISLANDS;
            this.barrensBiome = Biomes.END_BARRENS;
            return this;
        }

        public @NonNull EndStyleBiomeConfig build() {
            return new SpongeEndStyleBiomeConfig(this);
        }
    }
}

