/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.generation;

import com.mojang.serialization.Lifecycle;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.SimpleRegistry;
import net.minecraft.world.Dimension;
import net.minecraft.world.gen.settings.DimensionGeneratorSettings;
import org.spongepowered.api.world.generation.config.WorldGenerationConfig;
import org.spongepowered.common.accessor.world.gen.DimensionGeneratorSettingsAccessor;
import org.spongepowered.common.server.BootstrapProperties;

public final class SpongeWorldGenerationConfigMutableBuilder
implements WorldGenerationConfig.Mutable.Builder {
    private long seed;
    private boolean generateFeatures;
    private boolean generateBonusChest;

    @Override
    public WorldGenerationConfig.Mutable.Builder seed(long seed) {
        this.seed = seed;
        return this;
    }

    @Override
    public WorldGenerationConfig.Mutable.Builder generateFeatures(boolean generateFeatures) {
        this.generateFeatures = generateFeatures;
        return this;
    }

    @Override
    public WorldGenerationConfig.Mutable.Builder generateBonusChest(boolean generateBonusChest) {
        this.generateBonusChest = generateBonusChest;
        return this;
    }

    @Override
    public WorldGenerationConfig.Mutable.Builder reset() {
        DimensionGeneratorSettings defaultSettings = BootstrapProperties.dimensionGeneratorSettings;
        this.seed = defaultSettings.func_236221_b_();
        this.generateFeatures = defaultSettings.func_236222_c_();
        this.generateBonusChest = defaultSettings.func_236223_d_();
        return this;
    }

    @Override
    public WorldGenerationConfig.Mutable.Builder from(WorldGenerationConfig value) {
        this.seed = Objects.requireNonNull(value, "value").seed();
        this.generateFeatures = value.generateFeatures();
        this.generateBonusChest = value.generateBonusChest();
        return this;
    }

    @Override
    public WorldGenerationConfig.Mutable build() {
        return (WorldGenerationConfig.Mutable)DimensionGeneratorSettingsAccessor.invoker$new(this.seed, this.generateFeatures, this.generateBonusChest, (SimpleRegistry<Dimension>)new SimpleRegistry(Registry.field_239700_af_, Lifecycle.stable()), Optional.empty());
    }
}

