/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.generation.config;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.FlatGenerationSettings;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.registry.RegistryReference;
import org.spongepowered.api.world.biome.Biomes;
import org.spongepowered.api.world.generation.config.FlatGeneratorConfig;
import org.spongepowered.api.world.generation.config.flat.LayerConfig;
import org.spongepowered.api.world.generation.config.structure.StructureGenerationConfig;
import org.spongepowered.common.server.BootstrapProperties;

public final class SpongeFlatGeneratorConfigBuilder
implements FlatGeneratorConfig.Builder {
    public StructureGenerationConfig structureConfig;
    public final List<LayerConfig> layers = new ArrayList<LayerConfig>();
    public RegistryReference<org.spongepowered.api.world.biome.Biome> biome;
    public boolean performDecoration;
    public boolean populateLakes;

    @Override
    public FlatGeneratorConfig.Builder structureConfig(StructureGenerationConfig config) {
        this.structureConfig = Objects.requireNonNull(config, "config");
        return this;
    }

    @Override
    public FlatGeneratorConfig.Builder addLayer(int index, LayerConfig config) {
        this.layers.add(index, Objects.requireNonNull(config, "config"));
        return this;
    }

    @Override
    public FlatGeneratorConfig.Builder addLayer(LayerConfig config) {
        this.layers.add(Objects.requireNonNull(config, "config"));
        return this;
    }

    @Override
    public FlatGeneratorConfig.Builder addLayers(List<LayerConfig> layers) {
        this.layers.addAll((Collection<LayerConfig>)Objects.requireNonNull(layers, "layers"));
        return this;
    }

    @Override
    public FlatGeneratorConfig.Builder removeLayer(int index) {
        this.layers.remove(index);
        return this;
    }

    @Override
    public FlatGeneratorConfig.Builder biome(RegistryReference<org.spongepowered.api.world.biome.Biome> biome) {
        this.biome = Objects.requireNonNull(biome, "biome");
        return this;
    }

    @Override
    public FlatGeneratorConfig.Builder performDecoration(boolean performDecoration) {
        this.performDecoration = performDecoration;
        return this;
    }

    @Override
    public FlatGeneratorConfig.Builder populateLakes(boolean populateLakes) {
        this.populateLakes = populateLakes;
        return this;
    }

    @Override
    public FlatGeneratorConfig.Builder reset() {
        this.structureConfig = (StructureGenerationConfig)new DimensionStructuresSettings(Optional.of(DimensionStructuresSettings.field_236192_c_), (Map)Maps.newHashMap((Map)ImmutableMap.of((Object)Structure.field_236381_q_, (Object)DimensionStructuresSettings.field_236191_b_.get((Object)Structure.field_236381_q_))));
        this.layers.clear();
        this.layers.add(LayerConfig.of(1, (BlockState)BlockTypes.BEDROCK.get().getDefaultState()));
        this.layers.add(LayerConfig.of(2, (BlockState)BlockTypes.DIRT.get().getDefaultState()));
        this.layers.add(LayerConfig.of(1, (BlockState)BlockTypes.GRASS_BLOCK.get().getDefaultState()));
        this.biome = Biomes.PLAINS;
        this.performDecoration = true;
        this.populateLakes = true;
        return this;
    }

    @Override
    public FlatGeneratorConfig.Builder from(FlatGeneratorConfig value) {
        Objects.requireNonNull(value, "value");
        this.structureConfig = value.structureConfig();
        this.layers.addAll(value.layers());
        this.performDecoration = value.performDecoration();
        this.populateLakes = value.populateLakes();
        return this;
    }

    public @NonNull FlatGeneratorConfig build() {
        if (this.layers.isEmpty()) {
            throw new IllegalStateException("Flat generation requires at least 1 Layer!");
        }
        return (FlatGeneratorConfig)new FlatGenerationSettings((Registry)BootstrapProperties.registries.func_243612_b(Registry.field_239720_u_), (DimensionStructuresSettings)this.structureConfig, this.layers, this.populateLakes, this.performDecoration, Optional.of(() -> (Biome)BootstrapProperties.registries.func_243612_b(Registry.field_239720_u_).func_82594_a((ResourceLocation)this.biome.location())));
    }
}

