/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.portal;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.PortalInfo;
import net.minecraft.block.PortalSize;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.TeleportationRepositioner;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.event.cause.entity.MovementType;
import org.spongepowered.api.event.cause.entity.MovementTypes;
import org.spongepowered.api.event.entity.ChangeEntityWorldEvent;
import org.spongepowered.api.util.Axis;
import org.spongepowered.api.world.portal.Portal;
import org.spongepowered.api.world.portal.PortalType;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.accessor.entity.EntityAccessor;
import org.spongepowered.common.bridge.entity.EntityBridge;
import org.spongepowered.common.util.AxisUtil;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.portal.PlatformTeleporter;
import org.spongepowered.common.world.portal.PortalHelper;
import org.spongepowered.common.world.portal.VanillaPortal;
import org.spongepowered.common.world.portal.VanillaPortalType;

public final class NetherPortalType
extends VanillaPortalType {
    static Optional<TeleportationRepositioner.Result> findPortalInternal(ServerLocation location) {
        net.minecraft.world.server.ServerWorld serverWorld = (net.minecraft.world.server.ServerWorld)location.getWorld();
        BlockPos position = VecHelper.toBlockPos(location.getBlockPosition());
        return serverWorld.func_85176_s().func_242957_a(position, serverWorld.func_234923_W_() == World.field_234919_h_);
    }

    @Override
    public void generatePortal(ServerLocation location, Axis axis) {
        Objects.requireNonNull(location);
        Direction.Axis mcAxis = AxisUtil.getFor(axis);
        if (mcAxis == Direction.Axis.Y) {
            mcAxis = Direction.Axis.X;
        }
        PortalHelper.generateNetherPortal((net.minecraft.world.server.ServerWorld)location.getWorld(), location.getBlockX(), location.getBlockY(), location.getBlockZ(), mcAxis, true);
    }

    @Override
    public Optional<Portal> findPortal(ServerLocation location) {
        Objects.requireNonNull(location);
        return NetherPortalType.findPortalInternal(location).map(x -> new VanillaPortal(this, location.withPosition(VecHelper.toVector3d(x.field_243679_a)), null));
    }

    @Override
    public boolean teleport(org.spongepowered.api.entity.Entity entity, ServerLocation destination, boolean generateDestinationPortal) {
        Objects.requireNonNull(entity);
        Objects.requireNonNull(destination);
        Entity mEntity = (Entity)entity;
        if (mEntity.func_184218_aH() || mEntity.func_184207_aI() || !mEntity.func_184222_aU()) {
            return false;
        }
        Teleporter teleporter = new Teleporter(destination, generateDestinationPortal, this);
        ((EntityAccessor)((Object)entity)).accessor$portalEntrancePos(VecHelper.toBlockPos(entity.getBlockPosition()));
        return ((EntityBridge)((Object)entity)).bridge$changeDimension((net.minecraft.world.server.ServerWorld)destination.getWorld(), teleporter) != null;
    }

    static final class Teleporter
    implements PlatformTeleporter {
        private final ServerLocation originalDestination;
        private final boolean generateDestinationPortal;
        private final PortalType portalType;

        public Teleporter(ServerLocation originalDestination, boolean generateDestinationPortal, PortalType type) {
            this.originalDestination = originalDestination;
            this.generateDestinationPortal = generateDestinationPortal;
            this.portalType = type;
        }

        @Override
        public @Nullable PortalInfo getPortalInfo(Entity entity, net.minecraft.world.server.ServerWorld currentWorld, net.minecraft.world.server.ServerWorld targetWorld, org.spongepowered.math.vector.Vector3d currentPosition) {
            Optional<PortalInfo> portal = NetherPortalType.findPortalInternal(this.originalDestination).map(x -> this.createNetherPortalInfo(entity, targetWorld, x.field_243679_a, (TeleportationRepositioner.Result)x));
            org.spongepowered.math.vector.Vector3d originalDestination = portal.map(x -> VecHelper.toVector3d(x.field_222505_a)).orElseGet(this.originalDestination::getPosition);
            ChangeEntityWorldEvent.Reposition reposition = ((EntityBridge)entity).bridge$fireRepositionEvent((ServerWorld)this.originalDestination.getWorld(), (ServerWorld)targetWorld, originalDestination);
            if (!reposition.isCancelled() && reposition.getDestinationPosition() != originalDestination) {
                portal = NetherPortalType.findPortalInternal(this.originalDestination.withPosition(reposition.getDestinationPosition())).map(x -> this.createNetherPortalInfo(entity, targetWorld, x.field_243679_a, (TeleportationRepositioner.Result)x));
            }
            if (this.generateDestinationPortal && !portal.isPresent()) {
                return targetWorld.func_85176_s().func_242956_a(VecHelper.toBlockPos(this.originalDestination), Direction.func_176731_b((int)entity.func_174811_aO().func_176736_b()).func_176740_k()).map(x -> this.createNetherPortalInfo(entity, targetWorld, x.field_243679_a, (TeleportationRepositioner.Result)x)).orElse(null);
            }
            return portal.orElse(null);
        }

        @Override
        public Entity performTeleport(Entity entity, net.minecraft.world.server.ServerWorld currentWorld, net.minecraft.world.server.ServerWorld targetWorld, float xRot, Function<Boolean, Entity> teleportLogic) {
            return teleportLogic.apply(false);
        }

        @Override
        public boolean isVanilla() {
            return false;
        }

        @Override
        public MovementType getMovementType() {
            return MovementTypes.PORTAL.get();
        }

        @Override
        public PortalType getPortalType() {
            return this.portalType;
        }

        private PortalInfo createNetherPortalInfo(Entity entity, net.minecraft.world.server.ServerWorld serverWorld, BlockPos portalLocation, TeleportationRepositioner.Result result) {
            Vector3d vector3d;
            Direction.Axis axis;
            BlockState blockstate = serverWorld.func_180495_p(portalLocation);
            if (blockstate.func_235901_b_((Property)BlockStateProperties.field_208199_z)) {
                axis = (Direction.Axis)blockstate.func_177229_b((Property)BlockStateProperties.field_208199_z);
                TeleportationRepositioner.Result res = TeleportationRepositioner.func_243676_a((BlockPos)portalLocation, (Direction.Axis)axis, (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, pos -> serverWorld.func_180495_p(pos) == blockstate);
                vector3d = PortalSize.func_242973_a((TeleportationRepositioner.Result)res, (Direction.Axis)axis, (Vector3d)entity.func_213303_ch(), (EntitySize)entity.func_213305_a(entity.func_213283_Z()));
            } else {
                axis = Direction.Axis.X;
                vector3d = new Vector3d(0.5, 0.0, 0.0);
            }
            return PortalSize.func_242963_a((net.minecraft.world.server.ServerWorld)serverWorld, (TeleportationRepositioner.Result)result, (Direction.Axis)axis, (Vector3d)vector3d, (EntitySize)entity.func_213305_a(entity.func_213283_Z()), (Vector3d)entity.func_213322_ci(), (float)entity.field_70177_z, (float)entity.field_70125_A);
        }
    }
}

