/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.portal;

import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.EndPortalFrameBlock;
import net.minecraft.block.NetherPortalBlock;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;

public final class PortalHelper {
    private static final BlockState northEndFrame = (BlockState)Blocks.field_150378_br.func_176223_P().func_206870_a((Property)EndPortalFrameBlock.field_176508_a, (Comparable)Direction.NORTH);
    private static final BlockState southEndFrame = (BlockState)Blocks.field_150378_br.func_176223_P().func_206870_a((Property)EndPortalFrameBlock.field_176508_a, (Comparable)Direction.SOUTH);
    private static final BlockState eastEndFrame = (BlockState)Blocks.field_150378_br.func_176223_P().func_206870_a((Property)EndPortalFrameBlock.field_176508_a, (Comparable)Direction.EAST);
    private static final BlockState westEndFrame = (BlockState)Blocks.field_150378_br.func_176223_P().func_206870_a((Property)EndPortalFrameBlock.field_176508_a, (Comparable)Direction.WEST);
    private static final BlockState endPortal = Blocks.field_150384_bq.func_176223_P();

    public static void generateEndPortal(ServerWorld world, int x, int y, int z, boolean placePortalBlocks) {
        BlockPos.Mutable origin = new BlockPos.Mutable(x, y, z);
        for (int bx = 0; bx < 5; ++bx) {
            for (int by = 0; by < 5; ++by) {
                origin.func_181079_c(x + bx, y, z + by);
                if (bx == 0 && by > 0 && by < 4) {
                    world.func_180501_a((BlockPos)origin, (BlockState)southEndFrame.func_206870_a((Property)EndPortalFrameBlock.field_176507_b, (Comparable)Boolean.valueOf(world.field_73012_v.nextFloat() > 0.9f)), 2);
                    continue;
                }
                if (bx == 1 || bx == 2 || bx == 3) {
                    if (by == 0) {
                        world.func_180501_a((BlockPos)origin, (BlockState)eastEndFrame.func_206870_a((Property)EndPortalFrameBlock.field_176507_b, (Comparable)Boolean.valueOf(world.field_73012_v.nextFloat() > 0.9f)), 2);
                        continue;
                    }
                    if (by == 4) {
                        world.func_180501_a((BlockPos)origin, (BlockState)westEndFrame.func_206870_a((Property)EndPortalFrameBlock.field_176507_b, (Comparable)Boolean.valueOf(world.field_73012_v.nextFloat() > 0.9f)), 2);
                        continue;
                    }
                    if (!placePortalBlocks) continue;
                    world.func_180501_a((BlockPos)origin, endPortal, 2);
                    continue;
                }
                if (bx != 4 || by <= 0 || by >= 4) continue;
                world.func_180501_a((BlockPos)origin, (BlockState)northEndFrame.func_206870_a((Property)EndPortalFrameBlock.field_176507_b, (Comparable)Boolean.valueOf(world.field_73012_v.nextFloat() > 0.9f)), 2);
            }
        }
    }

    public static void generateNetherPortal(ServerWorld world, int x, int y, int z, Direction.Axis axis, boolean placePortalBlocks) {
        BlockPos portalPos = new BlockPos(x, y, z);
        Direction direction = Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
        double d0 = -1.0;
        BlockPos blockpos = null;
        double d1 = -1.0;
        BlockPos blockpos1 = null;
        WorldBorder worldborder = world.func_175723_af();
        int i = world.func_234938_ad_() - 1;
        BlockPos.Mutable blockpos$mutable = portalPos.func_239590_i_();
        for (BlockPos.Mutable blockpos$mutable1 : BlockPos.func_243514_a((BlockPos)portalPos, (int)16, (Direction)Direction.EAST, (Direction)Direction.SOUTH)) {
            int j = Math.min(i, world.func_201676_a(Heightmap.Type.MOTION_BLOCKING, blockpos$mutable1.func_177958_n(), blockpos$mutable1.func_177952_p()));
            boolean k = true;
            if (!worldborder.func_177746_a((BlockPos)blockpos$mutable1) || !worldborder.func_177746_a((BlockPos)blockpos$mutable1.func_189534_c(direction, 1))) continue;
            blockpos$mutable1.func_189534_c(direction.func_176734_d(), 1);
            for (int l = j; l >= 0; --l) {
                int j1;
                blockpos$mutable1.func_185336_p(l);
                if (!world.func_175623_d((BlockPos)blockpos$mutable1)) continue;
                int i1 = l;
                while (l > 0 && world.func_175623_d((BlockPos)blockpos$mutable1.func_189536_c(Direction.DOWN))) {
                    --l;
                }
                if (l + 4 > i || (j1 = i1 - l) > 0 && j1 < 3) continue;
                blockpos$mutable1.func_185336_p(l);
                if (!PortalHelper.canHostFrame(world, (BlockPos)blockpos$mutable1, blockpos$mutable, direction, 0)) continue;
                double d2 = portalPos.func_177951_i((Vector3i)blockpos$mutable1);
                if (PortalHelper.canHostFrame(world, (BlockPos)blockpos$mutable1, blockpos$mutable, direction, -1) && PortalHelper.canHostFrame(world, (BlockPos)blockpos$mutable1, blockpos$mutable, direction, 1) && (d0 == -1.0 || d0 > d2)) {
                    d0 = d2;
                    blockpos = blockpos$mutable1.func_185334_h();
                }
                if (d0 != -1.0 || d1 != -1.0 && !(d1 > d2)) continue;
                d1 = d2;
                blockpos1 = blockpos$mutable1.func_185334_h();
            }
        }
        if (d0 == -1.0 && d1 != -1.0) {
            blockpos = blockpos1;
            d0 = d1;
        }
        if (d0 == -1.0) {
            blockpos = new BlockPos(portalPos.func_177958_n(), MathHelper.func_76125_a((int)portalPos.func_177956_o(), (int)70, (int)(world.func_234938_ad_() - 10)), portalPos.func_177952_p()).func_185334_h();
            Direction direction1 = direction.func_176746_e();
            if (!worldborder.func_177746_a(blockpos)) {
                return;
            }
            for (int l1 = -1; l1 < 2; ++l1) {
                for (int k2 = 0; k2 < 2; ++k2) {
                    for (int i3 = -1; i3 < 3; ++i3) {
                        BlockState blockstate1 = i3 < 0 ? Blocks.field_150343_Z.func_176223_P() : Blocks.field_150350_a.func_176223_P();
                        blockpos$mutable.func_239621_a_((Vector3i)blockpos, k2 * direction.func_82601_c() + l1 * direction1.func_82601_c(), i3, k2 * direction.func_82599_e() + l1 * direction1.func_82599_e());
                        world.func_175656_a((BlockPos)blockpos$mutable, blockstate1);
                    }
                }
            }
        }
        for (int k1 = -1; k1 < 3; ++k1) {
            for (int i2 = -1; i2 < 4; ++i2) {
                if (k1 != -1 && k1 != 2 && i2 != -1 && i2 != 3) continue;
                blockpos$mutable.func_239621_a_((Vector3i)blockpos, k1 * direction.func_82601_c(), i2, k1 * direction.func_82599_e());
                world.func_180501_a((BlockPos)blockpos$mutable, Blocks.field_150343_Z.func_176223_P(), 3);
            }
        }
        if (placePortalBlocks) {
            BlockState blockstate = (BlockState)Blocks.field_150427_aO.func_176223_P().func_206870_a((Property)NetherPortalBlock.field_176550_a, (Comparable)axis);
            for (int j2 = 0; j2 < 2; ++j2) {
                for (int l2 = 0; l2 < 3; ++l2) {
                    blockpos$mutable.func_239621_a_((Vector3i)blockpos, j2 * direction.func_82601_c(), l2, j2 * direction.func_82599_e());
                    world.func_180501_a((BlockPos)blockpos$mutable, blockstate, 18);
                }
            }
        }
    }

    private static boolean canHostFrame(ServerWorld world, BlockPos p_242955_1_, BlockPos.Mutable p_242955_2_, Direction p_242955_3_, int p_242955_4_) {
        Direction direction = p_242955_3_.func_176746_e();
        for (int i = -1; i < 3; ++i) {
            for (int j = -1; j < 4; ++j) {
                p_242955_2_.func_239621_a_((Vector3i)p_242955_1_, p_242955_3_.func_82601_c() * i + direction.func_82601_c() * p_242955_4_, j, p_242955_3_.func_82599_e() * i + direction.func_82599_e() * p_242955_4_);
                if (j < 0 && !world.func_180495_p((BlockPos)p_242955_2_).func_185904_a().func_76220_a()) {
                    return false;
                }
                if (j < 0 || world.func_175623_d((BlockPos)p_242955_2_)) continue;
                return false;
            }
        }
        return true;
    }
}

