/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.schematic;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.entity.BlockEntityArchetype;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.value.MergeFunction;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.fluid.FluidState;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.schematic.Palette;
import org.spongepowered.api.world.schematic.Schematic;
import org.spongepowered.api.world.volume.archetype.ArchetypeVolume;
import org.spongepowered.api.world.volume.archetype.entity.EntityArchetypeEntry;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.common.world.volume.buffer.AbstractVolumeBuffer;
import org.spongepowered.common.world.volume.buffer.archetype.SpongeArchetypeVolume;
import org.spongepowered.math.vector.Vector3i;

public class SpongeSchematic
extends AbstractVolumeBuffer
implements Schematic {
    private final SpongeArchetypeVolume volume;
    private final DataView metadata;

    public SpongeSchematic(Vector3i start, Vector3i size, SpongeArchetypeVolume volume, DataView metadata) {
        super(start, size);
        this.volume = volume;
        this.metadata = metadata;
    }

    @Override
    public Palette<BlockState, BlockType> getBlockPalette() {
        return this.volume.getBlockPalette();
    }

    @Override
    public Palette<Biome, Biome> getBiomePalette() {
        return this.volume.getBiomePalette();
    }

    @Override
    public DataView getMetadata() {
        return this.metadata;
    }

    @Override
    public void addBlockEntity(int x, int y, int z, BlockEntityArchetype archetype) {
        this.volume.addBlockEntity(x, y, z, archetype);
    }

    @Override
    public void removeBlockEntity(int x, int y, int z) {
        this.volume.removeBlockEntity(x, y, z);
    }

    @Override
    public Optional<BlockEntityArchetype> getBlockEntityArchetype(int x, int y, int z) {
        return this.volume.getBlockEntityArchetype(x, y, z);
    }

    @Override
    public Map<Vector3i, BlockEntityArchetype> getBlockEntityArchetypes() {
        return this.volume.getBlockEntityArchetypes();
    }

    @Override
    public VolumeStream<ArchetypeVolume, BlockEntityArchetype> getBlockEntityArchetypeStream(Vector3i min2, Vector3i max, StreamOptions options) {
        return this.volume.getBlockEntityArchetypeStream(min2, max, options);
    }

    @Override
    public Collection<EntityArchetype> getEntityArchetypes() {
        return this.volume.getEntityArchetypes();
    }

    @Override
    public Collection<EntityArchetype> getEntityArchetypes(Predicate<EntityArchetype> filter) {
        return this.volume.getEntityArchetypes(filter);
    }

    @Override
    public VolumeStream<ArchetypeVolume, EntityArchetype> getEntityArchetypeStream(Vector3i min2, Vector3i max, StreamOptions options) {
        return this.volume.getEntityArchetypeStream(min2, max, options);
    }

    @Override
    public Stream<EntityArchetypeEntry> getEntitiesByPosition() {
        return this.volume.getEntitiesByPosition();
    }

    @Override
    public boolean setBlock(int x, int y, int z, BlockState block) {
        return this.volume.setBlock(x, y, z, block);
    }

    @Override
    public boolean removeBlock(int x, int y, int z) {
        return this.volume.removeBlock(x, y, z);
    }

    @Override
    public BlockState getBlock(int x, int y, int z) {
        return this.volume.getBlock(x, y, z);
    }

    @Override
    public FluidState getFluid(int x, int y, int z) {
        return this.volume.getFluid(x, y, z);
    }

    @Override
    public int getHighestYAt(int x, int z) {
        return this.volume.getHighestYAt(x, z);
    }

    @Override
    public VolumeStream<ArchetypeVolume, BlockState> getBlockStateStream(Vector3i min2, Vector3i max, StreamOptions options) {
        return this.volume.getBlockStateStream(min2, max, options);
    }

    @Override
    public <E> Optional<E> get(int x, int y, int z, Key<? extends Value<E>> key) {
        Stream<Supplier> dataRetrievalStream = Stream.of(() -> this.getBlock(x, y, z).get(key), () -> this.getFluid(x, y, z).get(key), () -> this.getBlockEntityArchetype(x, y, z).flatMap(archetype -> archetype.get(key)));
        return dataRetrievalStream.map(Supplier::get).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    @Override
    public <E, V extends Value<E>> Optional<V> getValue(int x, int y, int z, Key<V> key) {
        Stream<Supplier> dataRetrievalStream = Stream.of(() -> this.getBlock(x, y, z).getValue(key), () -> this.getFluid(x, y, z).getValue(key), () -> this.getBlockEntityArchetype(x, y, z).flatMap(archetype -> archetype.getValue(key)));
        return dataRetrievalStream.map(Supplier::get).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    @Override
    public boolean supports(int x, int y, int z, Key<?> key) {
        Stream<Supplier> dataRetrievalStream = Stream.of(() -> this.getBlock(x, y, z).supports(key), () -> this.getFluid(x, y, z).supports(key), () -> this.getBlockEntityArchetype(x, y, z).map(archetype -> archetype.supports(key)).orElse(false));
        return dataRetrievalStream.map(Supplier::get).filter(Boolean::booleanValue).findFirst().orElse(false);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public Set<Key<@NonNull ?>> getKeys(int x, int y, int z) {
        Stream<@NonNull Supplier> dataRetrievalStream = Stream.of(() -> this.getBlock(x, y, z).getKeys(), () -> this.getFluid(x, y, z).getKeys(), () -> this.getBlockEntityArchetype(x, y, z).map(ValueContainer::getKeys).orElseGet(Collections::emptySet));
        return dataRetrievalStream.map(Supplier::get).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Override
    public Set<Value.Immutable<?>> getValues(int x, int y, int z) {
        Stream<Supplier> dataRetrievalStream = Stream.of(() -> this.getBlock(x, y, z).getValues(), () -> this.getFluid(x, y, z).getValues(), () -> this.getBlockEntityArchetype(x, y, z).map(ValueContainer::getValues).orElseGet(Collections::emptySet));
        return dataRetrievalStream.map(Supplier::get).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Override
    public <E> DataTransactionResult offer(int x, int y, int z, Key<? extends Value<E>> key, E value) {
        Stream<Supplier> dataRetrievalStream = Stream.of(() -> this.getBlock(x, y, z).with(key, value).map(newState -> {
            Object newValue = newState.requireValue(key);
            this.setBlock(x, y, z, (BlockState)newState);
            return DataTransactionResult.successResult(newValue.asImmutable());
        }).orElseGet(DataTransactionResult::failNoData), () -> this.getFluid(x, y, z).with(key, value).map(newState -> {
            Object newValue = newState.requireValue(key);
            this.setBlock(x, y, z, newState.getBlock());
            return DataTransactionResult.successResult(newValue.asImmutable());
        }).orElseGet(DataTransactionResult::failNoData), () -> this.getBlockEntityArchetype(x, y, z).map(archetype -> archetype.offer(key, value)).orElseGet(DataTransactionResult::failNoData));
        return dataRetrievalStream.map(Supplier::get).filter(DataTransactionResult::isSuccessful).findFirst().orElseGet(DataTransactionResult::failNoData);
    }

    @Override
    public DataTransactionResult remove(int x, int y, int z, Key<@NonNull ?> key) {
        Stream<Supplier> dataRetrievalStream = Stream.of(() -> this.getBlock(x, y, z).without(key).map(newState -> {
            Value.Immutable newValue = this.getBlock(x, y, z).requireValue(key).asImmutable();
            this.setBlock(x, y, z, (BlockState)newState);
            return DataTransactionResult.successResult(newValue);
        }).orElseGet(DataTransactionResult::failNoData), () -> this.getFluid(x, y, z).without(key).map(newState -> {
            Value.Immutable newValue = this.getFluid(x, y, z).requireValue(key).asImmutable();
            this.setBlock(x, y, z, newState.getBlock());
            return DataTransactionResult.successResult(newValue);
        }).orElseGet(DataTransactionResult::failNoData), () -> this.getBlockEntityArchetype(x, y, z).map(archetype -> archetype.remove(key)).orElseGet(DataTransactionResult::failNoData));
        return dataRetrievalStream.map(Supplier::get).filter(DataTransactionResult::isSuccessful).findFirst().orElseGet(DataTransactionResult::failNoData);
    }

    @Override
    public DataTransactionResult undo(int x, int y, int z, DataTransactionResult result) {
        return result.getReplacedData().stream().map(successful -> this.offer(x, y, z, successful)).collect(DataTransactionResult.toTransaction());
    }

    @Override
    public DataTransactionResult copyFrom(int xTo, int yTo, int zTo, ValueContainer from) {
        return from.getValues().stream().map(value -> this.offer(xTo, yTo, zTo, value)).collect(DataTransactionResult.toTransaction());
    }

    @Override
    public DataTransactionResult copyFrom(int xTo, int yTo, int zTo, ValueContainer from, MergeFunction function) {
        return from.getValues().stream().map(value -> {
            Value merged = this.get(xTo, yTo, zTo, value.getKey()).map(existing -> function.merge((Value)existing, value).asImmutable()).orElse((Value.Immutable)value);
            return this.offer(xTo, yTo, zTo, merged);
        }).collect(DataTransactionResult.toTransaction());
    }

    @Override
    public DataTransactionResult copyFrom(int xTo, int yTo, int zTo, int xFrom, int yFrom, int zFrom, MergeFunction function) {
        return this.getValues(xFrom, yFrom, zFrom).stream().map(value -> {
            Value merged = this.get(xTo, yTo, zTo, value.getKey()).map(existing -> function.merge((Value)existing, value).asImmutable()).orElse(value.asImmutable());
            return this.offer(xTo, yTo, zTo, merged);
        }).collect(DataTransactionResult.toTransaction());
    }

    @Override
    public boolean validateRawData(int x, int y, int z, DataView container) {
        return this.getBlockEntityArchetype(x, y, z).map(archetype -> archetype.validateRawData(container)).orElse(false);
    }

    @Override
    public void setRawData(int x, int y, int z, DataView container) throws InvalidDataException {
        this.getBlockEntityArchetype(x, y, z).ifPresent(archetype -> archetype.setRawData(container));
    }

    @Override
    public void addEntity(EntityArchetypeEntry entry) {
        this.volume.addEntity(entry);
    }

    @Override
    public Biome getBiome(int x, int y, int z) {
        return this.getBiome(x, y, z);
    }

    @Override
    public VolumeStream<ArchetypeVolume, Biome> getBiomeStream(Vector3i min2, Vector3i max, StreamOptions options) {
        return this.volume.getBiomeStream(min2, max, options);
    }

    @Override
    public boolean setBiome(int x, int y, int z, Biome biome) {
        return this.setBiome(x, y, z, biome);
    }
}

