/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.teleport;

import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.state.StateContainer;
import org.spongepowered.api.world.teleport.TeleportHelperFilter;
import org.spongepowered.common.applaunch.config.common.TeleportHelperCategory;
import org.spongepowered.common.applaunch.config.core.SpongeConfigs;

public final class ConfigTeleportHelperFilter
implements TeleportHelperFilter {
    @Nullable
    private static List<BlockType> floorBlockTypes = null;
    @Nullable
    private static List<BlockState> floorBlockStates = null;
    @Nullable
    private static List<BlockType> bodyBlockTypes = null;
    @Nullable
    private static List<BlockState> bodyBlockStates = null;

    public static void invalidateCache() {
        floorBlockTypes = null;
        floorBlockStates = null;
        bodyBlockStates = null;
        bodyBlockTypes = null;
    }

    private static void updateCacheIfNecessary() {
        if (floorBlockTypes == null) {
            TeleportHelperCategory teleportHelperCat = SpongeConfigs.getCommon().get().teleportHelper;
            floorBlockTypes = teleportHelperCat.unsafeFloorBlocks.stream().map(x -> ResourceKey.resolve(x.toLowerCase(Locale.ENGLISH))).map(x -> (BlockType)Registry.field_212618_g.func_82594_a((ResourceLocation)x)).filter(Objects::nonNull).collect(Collectors.toList());
            floorBlockStates = teleportHelperCat.unsafeFloorBlocks.stream().map(x -> ResourceKey.resolve(x.toLowerCase(Locale.ENGLISH))).map(x -> Registry.field_212618_g.func_241873_b((ResourceLocation)x).map(b -> (BlockType)b).map(StateContainer::getDefaultState).orElse(null)).filter(Objects::nonNull).collect(Collectors.toList());
            bodyBlockTypes = teleportHelperCat.unsafeBlockBlocks.stream().map(x -> ResourceKey.resolve(x.toLowerCase(Locale.ENGLISH))).map(x -> (BlockType)Registry.field_212618_g.func_82594_a((ResourceLocation)x)).filter(Objects::nonNull).collect(Collectors.toList());
            bodyBlockStates = teleportHelperCat.unsafeBlockBlocks.stream().map(x -> ResourceKey.resolve(x.toLowerCase(Locale.ENGLISH))).map(x -> Registry.field_212618_g.func_241873_b((ResourceLocation)x).map(b -> (BlockType)b).map(StateContainer::getDefaultState).orElse(null)).filter(Objects::nonNull).collect(Collectors.toList());
        }
    }

    @Override
    public boolean isSafeFloorMaterial(@NonNull BlockState blockState) {
        ConfigTeleportHelperFilter.updateCacheIfNecessary();
        return !floorBlockStates.contains(blockState) && !floorBlockTypes.contains(blockState.getType());
    }

    @Override
    public boolean isSafeBodyMaterial(@NonNull BlockState blockState) {
        ConfigTeleportHelperFilter.updateCacheIfNecessary();
        return !bodyBlockStates.contains(blockState) && !bodyBlockTypes.contains(blockState.getType());
    }
}

