/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.volume.buffer.archetype;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.entity.BlockEntityArchetype;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.fluid.FluidState;
import org.spongepowered.api.registry.RegistryHolder;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.schematic.Palette;
import org.spongepowered.api.world.schematic.PaletteTypes;
import org.spongepowered.api.world.volume.archetype.ArchetypeVolume;
import org.spongepowered.api.world.volume.archetype.block.entity.BlockEntityArchetypeVolume;
import org.spongepowered.api.world.volume.archetype.entity.EntityArchetypeEntry;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeElement;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.common.world.volume.SpongeVolumeStream;
import org.spongepowered.common.world.volume.VolumeStreamUtils;
import org.spongepowered.common.world.volume.buffer.AbstractVolumeBuffer;
import org.spongepowered.common.world.volume.buffer.archetype.blockentity.MutableMapBlockEntityArchetypeBuffer;
import org.spongepowered.common.world.volume.buffer.archetype.entity.ObjectArrayMutableEntityArchetypeBuffer;
import org.spongepowered.common.world.volume.buffer.biome.ByteArrayMutableBiomeBuffer;
import org.spongepowered.common.world.volume.buffer.block.ArrayMutableBlockBuffer;
import org.spongepowered.math.vector.Vector3i;

public class SpongeArchetypeVolume
extends AbstractVolumeBuffer
implements ArchetypeVolume {
    private final ByteArrayMutableBiomeBuffer biomes;
    private final ArrayMutableBlockBuffer blocks;
    private final BlockEntityArchetypeVolume.Mutable<@NonNull ?> blockEntities;
    private final ObjectArrayMutableEntityArchetypeBuffer entities;

    public SpongeArchetypeVolume(Vector3i start, Vector3i size, RegistryHolder registries) {
        super(start, size);
        ArrayMutableBlockBuffer blocks;
        this.blocks = blocks = new ArrayMutableBlockBuffer(start, size);
        this.blockEntities = new MutableMapBlockEntityArchetypeBuffer(blocks);
        this.biomes = new ByteArrayMutableBiomeBuffer(PaletteTypes.BIOME_PALETTE.get().create(registries, RegistryTypes.BIOME), start, size);
        this.entities = new ObjectArrayMutableEntityArchetypeBuffer(start, size);
    }

    @Override
    public Optional<BlockEntityArchetype> getBlockEntityArchetype(int x, int y, int z) {
        return Optional.empty();
    }

    @Override
    public Map<Vector3i, BlockEntityArchetype> getBlockEntityArchetypes() {
        return this.blockEntities.getBlockEntityArchetypes();
    }

    @Override
    public VolumeStream<ArchetypeVolume, BlockEntityArchetype> getBlockEntityArchetypeStream(Vector3i min2, Vector3i max, StreamOptions options) {
        Vector3i blockMin = this.getBlockMin();
        Vector3i blockMax = this.getBlockMax();
        VolumeStreamUtils.validateStreamArgs(min2, max, blockMin, blockMax, options);
        Stream stateStream = this.blockEntities.getBlockEntityArchetypeStream(min2, max, options).toStream().map(element -> VolumeElement.of(this, element::getType, element.getPosition()));
        return new SpongeVolumeStream<ArchetypeVolume, BlockEntityArchetype>(stateStream, () -> this);
    }

    @Override
    public Collection<EntityArchetype> getEntityArchetypes() {
        return this.entities.getEntityArchetypes();
    }

    @Override
    public Collection<EntityArchetype> getEntityArchetypes(Predicate<EntityArchetype> filter) {
        return this.entities.getEntityArchetypes(filter);
    }

    @Override
    public VolumeStream<ArchetypeVolume, EntityArchetype> getEntityArchetypeStream(Vector3i min2, Vector3i max, StreamOptions options) {
        Vector3i blockMin = this.getBlockMin();
        Vector3i blockMax = this.getBlockMax();
        VolumeStreamUtils.validateStreamArgs(min2, max, blockMin, blockMax, options);
        Stream stateStream = this.entities.getEntityArchetypeStream(min2, max, options).toStream().map(element -> VolumeElement.of(this, element::getType, element.getPosition()));
        return new SpongeVolumeStream<ArchetypeVolume, EntityArchetype>(stateStream, () -> this);
    }

    @Override
    public Stream<EntityArchetypeEntry> getEntitiesByPosition() {
        return this.entities.getEntitiesByPosition();
    }

    @Override
    public boolean setBlock(int x, int y, int z, BlockState block) {
        return this.blockEntities.setBlock(x, y, z, block);
    }

    @Override
    public boolean removeBlock(int x, int y, int z) {
        return this.blockEntities.removeBlock(x, y, z);
    }

    @Override
    public BlockState getBlock(int x, int y, int z) {
        return this.blocks.getBlock(x, y, z);
    }

    @Override
    public FluidState getFluid(int x, int y, int z) {
        return this.blocks.getFluid(x, y, z);
    }

    @Override
    public int getHighestYAt(int x, int z) {
        return this.blocks.getHighestYAt(x, z);
    }

    @Override
    public VolumeStream<ArchetypeVolume, BlockState> getBlockStateStream(Vector3i min2, Vector3i max, StreamOptions options) {
        Vector3i blockMin = this.getBlockMin();
        Vector3i blockMax = this.getBlockMax();
        VolumeStreamUtils.validateStreamArgs(min2, max, blockMin, blockMax, options);
        ArrayMutableBlockBuffer buffer = options.carbonCopy() ? this.blocks.copy() : this.blocks;
        Stream stateStream = IntStream.range(blockMin.getX(), blockMax.getX() + 1).mapToObj(x -> IntStream.range(blockMin.getZ(), blockMax.getZ() + 1).mapToObj(z -> IntStream.range(blockMin.getY(), blockMax.getY() + 1).mapToObj(y -> VolumeElement.of(this, () -> buffer.getBlock(x, y, z), new Vector3i(x, y, z)))).flatMap(Function.identity())).flatMap(Function.identity());
        return new SpongeVolumeStream<ArchetypeVolume, BlockState>(stateStream, () -> this);
    }

    @Override
    public void addBlockEntity(int x, int y, int z, BlockEntityArchetype archetype) {
        this.blockEntities.addBlockEntity(x, y, z, archetype);
    }

    @Override
    public void removeBlockEntity(int x, int y, int z) {
        this.blockEntities.removeBlockEntity(x, y, z);
    }

    public Palette<BlockState, BlockType> getBlockPalette() {
        return this.blocks.getPalette();
    }

    public Palette<Biome, Biome> getBiomePalette() {
        return this.biomes.getPalette();
    }

    @Override
    public void addEntity(EntityArchetypeEntry entry) {
        this.entities.addEntity(entry);
    }

    @Override
    public Biome getBiome(int x, int y, int z) {
        return this.biomes.getBiome(x, y, z);
    }

    @Override
    public VolumeStream<ArchetypeVolume, Biome> getBiomeStream(Vector3i min2, Vector3i max, StreamOptions options) {
        Vector3i blockMin = this.getBlockMin();
        Vector3i blockMax = this.getBlockMax();
        VolumeStreamUtils.validateStreamArgs(min2, max, blockMin, blockMax, options);
        Stream stateStream = this.biomes.getBiomeStream(min2, max, options).toStream().map(element -> VolumeElement.of(this, element::getType, element.getPosition()));
        return new SpongeVolumeStream<ArchetypeVolume, Biome>(stateStream, () -> this);
    }

    @Override
    public boolean setBiome(int x, int y, int z, Biome biome) {
        return this.biomes.setBiome(x, y, z, biome);
    }
}

