/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.volume.buffer.biome;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.biome.Biomes;
import org.spongepowered.api.world.schematic.Palette;
import org.spongepowered.api.world.volume.biome.BiomeVolume;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeElement;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.common.world.volume.SpongeVolumeStream;
import org.spongepowered.common.world.volume.VolumeStreamUtils;
import org.spongepowered.common.world.volume.buffer.biome.AbstractBiomeBuffer;
import org.spongepowered.math.vector.Vector3i;

public final class ByteArrayImmutableBiomeBuffer
extends AbstractBiomeBuffer
implements BiomeVolume.Immutable {
    private final byte[] biomes;
    private final Palette<Biome, Biome> palette;

    public ByteArrayImmutableBiomeBuffer(Palette<Biome, Biome> palette, byte[] biomes, Vector3i start, Vector3i size) {
        super(start, size);
        this.biomes = (byte[])biomes.clone();
        this.palette = palette;
    }

    private ByteArrayImmutableBiomeBuffer(Palette<Biome, Biome> palette, Vector3i start, Vector3i size, byte[] biomes) {
        super(start, size);
        this.biomes = biomes;
        this.palette = palette;
    }

    @Override
    public Biome getBiome(int x, int y, int z) {
        this.checkRange(x, y, z);
        return this.palette.get(this.biomes[this.getIndex(x, y, z)], Sponge.getServer().registries()).orElseGet((Supplier)Sponge.getServer().registries().registry(RegistryTypes.BIOME).value(Biomes.OCEAN));
    }

    public static BiomeVolume.Immutable newWithoutArrayClone(Palette<Biome, Biome> palette, byte[] biomes, Vector3i start, Vector3i size) {
        return new ByteArrayImmutableBiomeBuffer(palette, start, size, biomes);
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ByteArrayImmutableBiomeBuffer that = (ByteArrayImmutableBiomeBuffer)o;
        return Arrays.equals(this.biomes, that.biomes) && this.palette.equals(that.palette);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(super.hashCode(), this.palette);
        result = 31 * result + Arrays.hashCode(this.biomes);
        return result;
    }

    @Override
    public VolumeStream<BiomeVolume.Immutable, Biome> getBiomeStream(Vector3i min2, Vector3i max, StreamOptions options) {
        Vector3i blockMin = this.getBlockMin();
        Vector3i blockMax = this.getBlockMax();
        VolumeStreamUtils.validateStreamArgs(min2, max, blockMin, blockMax, options);
        Stream stateStream = IntStream.range(blockMin.getX(), blockMax.getX() + 1).mapToObj(x -> IntStream.range(blockMin.getZ(), blockMax.getZ() + 1).mapToObj(z -> IntStream.range(blockMin.getY(), blockMax.getY() + 1).mapToObj(y -> VolumeElement.of(this, () -> {
            byte biomeId = this.biomes[this.getIndex(x, y, z)];
            return this.palette.get(biomeId & 0xFF, Sponge.getServer().registries()).orElseGet((Supplier)Sponge.getServer().registries().registry(RegistryTypes.BIOME).value(Biomes.OCEAN));
        }, new Vector3i(x, y, z)))).flatMap(Function.identity())).flatMap(Function.identity());
        return new SpongeVolumeStream<BiomeVolume.Immutable, Biome>(stateStream, () -> this);
    }
}

