/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.volume.buffer.biome;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.util.math.BlockPos;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.biome.Biomes;
import org.spongepowered.api.world.volume.biome.BiomeVolume;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeElement;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.common.world.volume.SpongeVolumeStream;
import org.spongepowered.common.world.volume.VolumeStreamUtils;
import org.spongepowered.common.world.volume.buffer.biome.AbstractBiomeBuffer;
import org.spongepowered.math.vector.Vector3i;

public final class ObjectArrayMutableBiomeBuffer
extends AbstractBiomeBuffer
implements BiomeVolume.Mutable<ObjectArrayMutableBiomeBuffer> {
    private final Biome[] biomes;

    public ObjectArrayMutableBiomeBuffer(Vector3i start, Vector3i size) {
        super(start, size);
        this.biomes = new Biome[size.getX() * size.getY() * size.getZ()];
        Arrays.fill(this.biomes, Biomes.OCEAN);
    }

    public ObjectArrayMutableBiomeBuffer(Biome[] biomes, Vector3i start, Vector3i size) {
        super(start, size);
        this.biomes = biomes;
    }

    @Override
    public Biome getBiome(int x, int y, int z) {
        this.checkRange(x, y, z);
        return this.biomes[this.getIndex(x, y, z)];
    }

    public net.minecraft.world.biome.Biome getNativeBiome(int x, int y, int z) {
        this.checkRange(x, y, z);
        Biome type = this.biomes[this.getIndex(x, y, z)];
        return (net.minecraft.world.biome.Biome)type;
    }

    @Override
    public boolean setBiome(int x, int y, int z, Biome biome) {
        Objects.requireNonNull(biome, "biome");
        this.checkRange(x, y, z);
        this.biomes[this.getIndex((int)x, (int)y, (int)z)] = biome;
        return true;
    }

    public boolean setBiome(BlockPos pos, net.minecraft.world.biome.Biome biome) {
        Objects.requireNonNull(biome, "biome");
        Objects.requireNonNull(pos, "pos");
        this.checkRange(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        this.biomes[this.getIndex((int)pos.func_177958_n(), (int)pos.func_177956_o(), (int)pos.func_177952_p())] = (Biome)biome;
        return true;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ObjectArrayMutableBiomeBuffer that = (ObjectArrayMutableBiomeBuffer)o;
        return Arrays.equals(this.biomes, that.biomes);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.biomes);
        return result;
    }

    @Override
    public VolumeStream<ObjectArrayMutableBiomeBuffer, Biome> getBiomeStream(Vector3i min2, Vector3i max, StreamOptions options) {
        Vector3i blockMin = this.getBlockMin();
        Vector3i blockMax = this.getBlockMax();
        VolumeStreamUtils.validateStreamArgs(min2, max, blockMin, blockMax, options);
        Biome[] buffer = options.carbonCopy() ? Arrays.copyOf(this.biomes, this.biomes.length) : this.biomes;
        Stream stateStream = IntStream.range(blockMin.getX(), blockMax.getX() + 1).mapToObj(x -> IntStream.range(blockMin.getZ(), blockMax.getZ() + 1).mapToObj(z -> IntStream.range(blockMin.getY(), blockMax.getY() + 1).mapToObj(y -> VolumeElement.of(this, () -> buffer[this.getIndex(x, y, z)], new Vector3i(x, y, z)))).flatMap(Function.identity())).flatMap(Function.identity());
        return new SpongeVolumeStream<ObjectArrayMutableBiomeBuffer, Biome>(stateStream, () -> this);
    }
}

