/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.volume.buffer.block;

import java.util.Objects;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.util.math.BlockPos;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.fluid.FluidState;
import org.spongepowered.api.registry.RegistryHolder;
import org.spongepowered.api.registry.RegistryReference;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.world.schematic.Palette;
import org.spongepowered.api.world.schematic.PaletteTypes;
import org.spongepowered.api.world.volume.block.BlockVolume;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeElement;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.common.world.schematic.MutableBimapPalette;
import org.spongepowered.common.world.volume.SpongeVolumeStream;
import org.spongepowered.common.world.volume.VolumeStreamUtils;
import org.spongepowered.common.world.volume.buffer.block.AbstractBlockBuffer;
import org.spongepowered.common.world.volume.buffer.block.BlockBackingData;
import org.spongepowered.math.vector.Vector3i;

public class ArrayMutableBlockBuffer
extends AbstractBlockBuffer
implements BlockVolume.Mutable<ArrayMutableBlockBuffer> {
    private static final BlockState AIR = (BlockState)BlockTypes.AIR.get().getDefaultState();
    private final Palette.Mutable<BlockState, BlockType> palette;
    private final RegistryReference<BlockType> defaultState;
    private BlockBackingData data;

    public ArrayMutableBlockBuffer(Vector3i start, Vector3i size) {
        this(new MutableBimapPalette<BlockState, BlockType>(PaletteTypes.BLOCK_STATE_PALETTE.get(), Sponge.getGame().registries().registry(RegistryTypes.BLOCK_TYPE), RegistryTypes.BLOCK_TYPE), BlockTypes.AIR, start, size);
    }

    public ArrayMutableBlockBuffer(Palette<BlockState, BlockType> palette, RegistryReference<BlockType> defaultState, Vector3i start, Vector3i size) {
        super(start, size);
        Palette.Mutable<BlockState, BlockType> mutablePalette = palette.asMutable(Sponge.getGame().registries());
        this.palette = mutablePalette;
        int airId = mutablePalette.getOrAssign(AIR);
        int dataSize = this.area();
        this.defaultState = defaultState;
        this.data = new BlockBackingData.PackedBackingData(dataSize, palette.getHighestId());
        if (airId != 0) {
            for (int i = 0; i < dataSize; ++i) {
                this.data.set(i, airId);
            }
        }
    }

    public ArrayMutableBlockBuffer(Palette<BlockState, BlockType> palette, Vector3i start, Vector3i size, char[] blocks) {
        super(start, size);
        this.palette = palette.asMutable(Sponge.getGame().registries());
        this.data = new BlockBackingData.CharBackingData(blocks);
        this.defaultState = BlockTypes.AIR;
    }

    ArrayMutableBlockBuffer(Palette<BlockState, BlockType> palette, BlockBackingData blocks, Vector3i start, Vector3i size) {
        super(start, size);
        this.palette = palette.asMutable(Sponge.getGame().registries());
        this.data = blocks;
        this.defaultState = BlockTypes.AIR;
    }

    @Override
    public Palette<BlockState, BlockType> getPalette() {
        return this.palette;
    }

    @Override
    public boolean setBlock(int x, int y, int z, BlockState block) {
        this.checkRange(x, y, z);
        int id = this.palette.getOrAssign(block);
        if (id > this.data.getMax()) {
            int highId = this.palette.getHighestId();
            int dataSize = this.area();
            BlockBackingData.PackedBackingData newdata = new BlockBackingData.PackedBackingData(dataSize, highId);
            for (int i = 0; i < dataSize; ++i) {
                newdata.set(i, this.data.get(i));
            }
            this.data = newdata;
        }
        this.data.set(this.getIndex(x, y, z), id);
        return true;
    }

    @Override
    public boolean removeBlock(int x, int y, int z) {
        this.checkRange(x, y, z);
        return this.setBlock(x, y, z, (BlockState)BlockTypes.AIR.get().getDefaultState());
    }

    @Override
    public BlockState getBlock(int x, int y, int z) {
        this.checkRange(x, y, z);
        RegistryHolder registries = Sponge.getGame().registries();
        return this.palette.get(this.data.get(this.getIndex(x, y, z)), registries).orElseGet(() -> (BlockState)this.defaultState.get(registries).getDefaultState());
    }

    @Override
    public FluidState getFluid(int x, int y, int z) {
        return this.getBlock(x, y, z).getFluidState();
    }

    @Override
    public int getHighestYAt(int x, int z) {
        return 0;
    }

    private int area() {
        return this.size.getX() * this.size.getY() * this.size.getZ();
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ArrayMutableBlockBuffer that = (ArrayMutableBlockBuffer)o;
        return this.palette.equals(that.palette) && this.data.equals(that.data);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.palette, this.data);
    }

    @Override
    public VolumeStream<ArrayMutableBlockBuffer, BlockState> getBlockStateStream(Vector3i min2, Vector3i max, StreamOptions options) {
        Vector3i blockMin = this.getBlockMin();
        Vector3i blockMax = this.getBlockMax();
        VolumeStreamUtils.validateStreamArgs(min2, max, blockMin, blockMax, options);
        ArrayMutableBlockBuffer buffer = options.carbonCopy() ? new ArrayMutableBlockBuffer(this.palette, this.data.copyOf(), this.start, this.size) : this;
        Stream stateStream = IntStream.range(blockMin.getX(), blockMax.getX() + 1).mapToObj(x -> IntStream.range(blockMin.getZ(), blockMax.getZ() + 1).mapToObj(z -> IntStream.range(blockMin.getY(), blockMax.getY() + 1).mapToObj(y -> VolumeElement.of(this, () -> buffer.getBlock(x, y, z), new Vector3i(x, y, z)))).flatMap(Function.identity())).flatMap(Function.identity());
        return new SpongeVolumeStream<ArrayMutableBlockBuffer, BlockState>(stateStream, () -> this);
    }

    public void setBlock(BlockPos pos, net.minecraft.block.BlockState blockState) {
        this.setBlock(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), (BlockState)blockState);
    }

    public net.minecraft.block.BlockState getBlock(BlockPos blockPos) {
        return (net.minecraft.block.BlockState)this.getBlock(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
    }

    public ArrayMutableBlockBuffer copy() {
        return new ArrayMutableBlockBuffer(this.palette, this.data.copyOf(), this.start, this.size);
    }

    public BlockBackingData getCopiedBackingData() {
        return this.data.copyOf();
    }
}

