/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.volume.buffer.blockentity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.block.entity.BlockEntity;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeElement;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.common.world.volume.SpongeVolumeStream;
import org.spongepowered.common.world.volume.VolumeStreamUtils;
import org.spongepowered.common.world.volume.buffer.blockentity.AbstractMutableBlockEntityBuffer;
import org.spongepowered.math.vector.Vector3i;

public class ObjectArrayMutableBlockEntityBuffer
extends AbstractMutableBlockEntityBuffer<ObjectArrayMutableBlockEntityBuffer> {
    private final ArrayList<BlockEntity> blockEntities = new ArrayList();

    public ObjectArrayMutableBlockEntityBuffer(Vector3i start, Vector3i size) {
        super(start, size);
    }

    @Override
    public void addBlockEntity(int x, int y, int z, BlockEntity blockEntity) {
        this.blockEntities.add(blockEntity);
    }

    @Override
    public void removeBlockEntity(int x, int y, int z) {
        this.blockEntities.removeIf(be -> {
            Vector3i pos = be.getBlockPosition();
            return pos.getX() == x && pos.getZ() == z && pos.getY() == y;
        });
    }

    @Override
    public VolumeStream<ObjectArrayMutableBlockEntityBuffer, BlockEntity> getBlockEntityStream(Vector3i min2, Vector3i max, StreamOptions options) {
        VolumeStreamUtils.validateStreamArgs(min2, max, this.getBlockMin(), this.getBlockMax(), options);
        Stream blockEntityStream = this.blockEntities.stream().map(be -> VolumeElement.of(this, be, be.getBlockPosition()));
        return new SpongeVolumeStream<ObjectArrayMutableBlockEntityBuffer, BlockEntity>(blockEntityStream, () -> this);
    }

    @Override
    public Collection<? extends BlockEntity> getBlockEntities() {
        return this.blockEntities;
    }

    @Override
    public Optional<? extends BlockEntity> getBlockEntity(int x, int y, int z) {
        return this.blockEntities.stream().filter(be -> {
            Vector3i pos = be.getBlockPosition();
            return pos.getX() == x && pos.getY() == y && pos.getZ() == z;
        }).findFirst();
    }

    public @Nullable TileEntity getTileEntity(BlockPos blockPos) {
        return this.getBlockEntity(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p()).orElse(null);
    }
}

