/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.volume.buffer.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.fluid.FluidState;
import org.spongepowered.api.util.AABB;
import org.spongepowered.api.world.schematic.Palette;
import org.spongepowered.api.world.volume.entity.EntityVolume;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeElement;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.common.world.volume.SpongeVolumeStream;
import org.spongepowered.common.world.volume.VolumeStreamUtils;
import org.spongepowered.common.world.volume.buffer.block.AbstractBlockBuffer;
import org.spongepowered.common.world.volume.buffer.block.ArrayMutableBlockBuffer;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

public class ObjectArrayMutableEntityBuffer
extends AbstractBlockBuffer
implements EntityVolume.Mutable<ObjectArrayMutableEntityBuffer> {
    private final ArrayMutableBlockBuffer blockBuffer;
    private final List<Entity> entities;

    public ObjectArrayMutableEntityBuffer(Vector3i start, Vector3i size) {
        super(start, size);
        this.blockBuffer = new ArrayMutableBlockBuffer(start, size);
        this.entities = new ArrayList<Entity>();
    }

    public ObjectArrayMutableEntityBuffer(Vector3i start, Vector3i size, ArrayMutableBlockBuffer blockBuffer) {
        super(start, size);
        this.blockBuffer = blockBuffer;
        this.entities = new ArrayList<Entity>();
    }

    @Override
    public Palette<BlockState, BlockType> getPalette() {
        return this.blockBuffer.getPalette();
    }

    @Override
    public BlockState getBlock(int x, int y, int z) {
        return this.blockBuffer.getBlock(x, y, z);
    }

    @Override
    public FluidState getFluid(int x, int y, int z) {
        return this.blockBuffer.getFluid(x, y, z);
    }

    @Override
    public int getHighestYAt(int x, int z) {
        return this.blockBuffer.getHighestYAt(x, z);
    }

    @Override
    public VolumeStream<ObjectArrayMutableEntityBuffer, BlockState> getBlockStateStream(Vector3i min2, Vector3i max, StreamOptions options) {
        Stream stateStream = IntStream.range(this.getBlockMin().getX(), this.getBlockMax().getX() + 1).mapToObj(x -> IntStream.range(this.getBlockMin().getZ(), this.getBlockMax().getZ() + 1).mapToObj(z -> IntStream.range(this.getBlockMin().getY(), this.getBlockMax().getY() + 1).mapToObj(y -> VolumeElement.of(this, () -> this.blockBuffer.getBlock(x, y, z), new Vector3i(x, y, z)))).flatMap(Function.identity())).flatMap(Function.identity());
        return new SpongeVolumeStream<ObjectArrayMutableEntityBuffer, BlockState>(stateStream, () -> this);
    }

    @Override
    public boolean setBlock(int x, int y, int z, BlockState block) {
        return this.blockBuffer.setBlock(x, y, z, block);
    }

    @Override
    public boolean removeBlock(int x, int y, int z) {
        return this.blockBuffer.removeBlock(x, y, z);
    }

    @Override
    public <E extends Entity> E createEntity(EntityType<E> type, Vector3d position) throws IllegalArgumentException, IllegalStateException {
        throw new UnsupportedOperationException("Cannot create entities without a world, can only add to a volume");
    }

    @Override
    public <E extends Entity> E createEntityNaturally(EntityType<E> type, Vector3d position) throws IllegalArgumentException, IllegalStateException {
        throw new UnsupportedOperationException("Cannot create entities without a world, can only add to a volume");
    }

    @Override
    public Optional<Entity> createEntity(DataContainer entityContainer) {
        return Optional.empty();
    }

    @Override
    public Optional<Entity> createEntity(DataContainer entityContainer, Vector3d position) {
        return Optional.empty();
    }

    @Override
    public boolean spawnEntity(Entity entity) {
        if (entity == null) {
            throw new IllegalArgumentException("Entity cannot be null!");
        }
        if (!this.containsBlock(entity.getPosition().toInt())) {
            throw new IllegalArgumentException(String.format("Entity is out of bounds! {min: %s, max: %s} does not contain %s", this.getBlockMin(), this.getBlockMax(), entity.getPosition()));
        }
        return this.entities.add(entity);
    }

    @Override
    public Collection<Entity> spawnEntities(Iterable<? extends Entity> entities) {
        return StreamSupport.stream(entities.spliterator(), false).filter(this::spawnEntity).collect(Collectors.toList());
    }

    @Override
    public Collection<? extends Player> getPlayers() {
        return this.entities.stream().filter(entity -> entity instanceof Player).map(entity -> (Player)entity).collect(Collectors.toList());
    }

    @Override
    public Optional<Entity> getEntity(UUID uuid) {
        if (uuid == null) {
            throw new IllegalArgumentException("UUID cannot be null!");
        }
        return this.entities.stream().filter(entity -> uuid.equals(entity.getUniqueId())).findFirst();
    }

    @Override
    public <T extends Entity> Collection<? extends T> getEntities(Class<? extends T> entityClass, AABB box, @Nullable Predicate<? super T> predicate) {
        Objects.requireNonNull(entityClass);
        Objects.requireNonNull(box);
        if (!this.containsBlock(box.getMin().toInt())) {
            throw new IllegalArgumentException("Box is larger than volume allowed");
        }
        if (!this.containsBlock(box.getMax().toInt())) {
            throw new IllegalArgumentException("Box is larger than volume allowed!");
        }
        Stream<Entity> tStream = this.entities.stream().filter(entityClass::isInstance).map(entity -> entity).filter(entity -> box.contains(entity.getPosition()));
        if (predicate != null) {
            tStream = tStream.filter(predicate);
        }
        return tStream.collect(Collectors.toList());
    }

    @Override
    public Collection<? extends Entity> getEntities(AABB box, Predicate<? super Entity> filter) {
        Objects.requireNonNull(filter, "Filter cannot be null");
        Objects.requireNonNull(box, "Bounding box cannot be null");
        if (!this.containsBlock(box.getMin().toInt())) {
            throw new IllegalArgumentException("Box is larger than volume allowed");
        }
        if (!this.containsBlock(box.getMax().toInt())) {
            throw new IllegalArgumentException("Box is larger than volume allowed!");
        }
        return this.entities.stream().filter(entity -> box.contains(entity.getPosition())).filter(filter).collect(Collectors.toList());
    }

    @Override
    public VolumeStream<ObjectArrayMutableEntityBuffer, Entity> getEntityStream(Vector3i min2, Vector3i max, StreamOptions options) {
        VolumeStreamUtils.validateStreamArgs(min2, max, this.getBlockMin(), this.getBlockMax(), options);
        Stream backingStream = this.entities.stream().map(entity -> VolumeElement.of(this, entity, entity.getBlockPosition()));
        return new SpongeVolumeStream<ObjectArrayMutableEntityBuffer, Entity>(backingStream, () -> this);
    }
}

