/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.client.gui.widget;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import org.spongepowered.plugin.metadata.PluginMetadata;
import org.spongepowered.vanilla.client.gui.screen.PluginScreen;
import org.spongepowered.vanilla.client.gui.widget.ScrollPanel;
import org.spongepowered.vanilla.util.Bounds;

public final class MetadataPanel
extends ScrollPanel {
    private static final ITextComponent NO_RESULTS = new StringTextComponent("No data...").func_240699_a_(TextFormatting.GRAY);
    static final Pattern URL_PATTERN = Pattern.compile("((?:[a-z0-9]{2,}://)?(?:(?:[0-9]{1,3}\\.){3}[0-9]{1,3}|(?:[-\\w_]+\\.[a-z]{2,}?))(?::[0-9]{1,5})?.*?(?=[!\"\u00a7 \n]|$))", 2);
    static final int INDENT_SIZE = 12;
    private final Minecraft minecraft;
    private final PluginScreen screen;
    private final int lineHeight;
    private final List<Category> categories = new ObjectArrayList();
    private final List<Category> resizedCategories = new ObjectArrayList();
    private int maxKeyWidth;

    public MetadataPanel(Minecraft minecraft, PluginScreen screen, int width, int height, int top, int left) {
        super(minecraft, width, height, top, left);
        this.minecraft = minecraft;
        this.screen = screen;
        this.minecraft.field_71466_p.getClass();
        this.lineHeight = 9 + 1;
    }

    public void setMetadata(@Nullable PluginMetadata metadata) {
        this.categories.clear();
        this.maxKeyWidth = 0;
        if (metadata == null) {
            this.resizedCategories.clear();
            return;
        }
        this.categories.add(new Category("Details").addEntry(new Entry("ID", metadata.getId())).addEntry(new Entry("Name", metadata.getName().orElse(null))).addEntry(new Entry("Version", metadata.getVersion())).addEntry(new Entry("Entry", metadata.getMainClass())).addEntry(new Entry("Description", metadata.getDescription().orElse(null))));
        this.categories.add(new Category("Contributors", metadata.getContributors().stream().map(c -> new Entry(c.getName(), c.getDescription().orElse(""))).collect(Collectors.toList())));
        this.categories.add(new Category("Dependencies", metadata.getDependencies().stream().map(d -> Lists.newArrayList((Object[])new Entry[]{new Entry(d.getId(), ""), new Entry("Version", d.getVersion(), 1), new Entry("Optional", String.valueOf(d.isOptional()), 1), new Entry("Load Order", d.getLoadOrder().name(), 1)})).flatMap(Collection::stream).collect(Collectors.toList())));
        this.categories.add(new Category("Resources").addEntry(new Entry("Homepage", metadata.getLinks().getHomepage().map(URL::toString).orElse(null))).addEntry(new Entry("Issues", metadata.getLinks().getIssues().map(URL::toString).orElse(null))).addEntry(new Entry("Source", metadata.getLinks().getSource().map(URL::toString).orElse(null))));
        this.categories.add(new Category("Other", metadata.getExtraMetadata().entrySet().stream().map(e -> new Entry((String)e.getKey(), e.getValue().toString())).collect(Collectors.toList())));
        this.categories.stream().flatMap(c -> c.getEntries().stream()).forEach(e -> {
            int width = e.key == null ? 0 : this.minecraft.field_71466_p.func_238414_a_((ITextProperties)e.key);
            this.maxKeyWidth = Math.max(this.maxKeyWidth, width + e.level * 12);
        });
        this.resizeContent();
    }

    private void resizeContent() {
        this.resizedCategories.clear();
        this.resizedCategories.addAll(this.categories);
        for (Category category : this.resizedCategories) {
            ArrayList<Entry> newEntries = new ArrayList<Entry>();
            for (Entry entry : category.getEntries()) {
                if (entry.rawValue == null) continue;
                int levelOffset = entry.level * 12;
                int baseX = 4;
                int keyX = 16 + levelOffset;
                int separatorX = keyX + this.maxKeyWidth + 4 - levelOffset;
                int valueX = separatorX + this.minecraft.field_71466_p.func_78256_a(":") + 4;
                int maxWidth = this.width - valueX - 8;
                if (maxWidth < 0) continue;
                List<String> lines = Arrays.asList(this.efficientWrapper(entry.rawValue, maxWidth).split("\n"));
                newEntries.add(new Entry(entry.rawKey, lines.get(0), entry.level, entry.rawValue));
                newEntries.addAll(lines.stream().skip(1L).map(l -> new Entry(null, (String)l, entry.level, entry.rawValue)).collect(Collectors.toList()));
            }
            category.setEntries(newEntries);
        }
    }

    private int getTotalLineCount() {
        int categoryCount = this.resizedCategories.size();
        int entryCount = 0;
        for (Category category : this.resizedCategories) {
            entryCount += category.getEntries().size();
        }
        return entryCount + categoryCount + categoryCount;
    }

    private List<Entry> getAllEntries() {
        ObjectArrayList entries = new ObjectArrayList();
        for (Category category : this.resizedCategories) {
            entries.addAll(category.entries);
        }
        return entries;
    }

    private String efficientWrapper(String value, int width) {
        ObjectArrayList lines = new ObjectArrayList();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            String lineCandidate = builder.toString() + c;
            if (this.minecraft.field_71466_p.func_78256_a(lineCandidate) > width) {
                lines.add(builder.append("\n").toString());
                builder.delete(0, builder.length());
            }
            builder.append(c);
            if (i + 1 < value.length()) continue;
            lines.add(builder.toString());
        }
        return String.join((CharSequence)"", (Iterable<? extends CharSequence>)lines);
    }

    @Override
    public int getContentHeight() {
        int height = this.getTotalLineCount() * this.lineHeight;
        if (height < this.bottom - this.top - 8) {
            height = this.bottom - this.top - 8;
        }
        return height;
    }

    @Override
    protected int getScrollAmount() {
        return this.lineHeight * 3;
    }

    @Override
    protected void drawPanel(MatrixStack stack, int entryRight, int relativeY, Tessellator tess, int mouseX, int mouseY) {
        int baseX = this.left + 4;
        if (this.resizedCategories.isEmpty()) {
            FontRenderer font = this.minecraft.field_71466_p;
            int noResultsWidth = font.func_238414_a_((ITextProperties)NO_RESULTS);
            font.func_243248_b(stack, NO_RESULTS, (float)this.width / 2.0f + (float)this.left - (float)noResultsWidth / 2.0f, (float)(this.top + 10), 0xFFFFFF);
            return;
        }
        for (Category category : this.resizedCategories) {
            if (category.getEntries().size() == 0) continue;
            this.minecraft.field_71466_p.func_243248_b(stack, category.name, (float)baseX, (float)relativeY, 0xFFFFFF);
            relativeY += this.lineHeight;
            for (Entry entry : category.getEntries()) {
                if (entry.value == null) continue;
                int levelOffset = entry.level * 12;
                int keyX = baseX + 12 + levelOffset;
                int separatorX = keyX + this.maxKeyWidth + 4 - levelOffset;
                int valueX = separatorX + this.minecraft.field_71466_p.func_78256_a(":") + 4;
                if (entry.key != null) {
                    this.minecraft.field_71466_p.func_243248_b(stack, entry.key, (float)keyX, (float)relativeY, 0xFFFFFF);
                    if (entry.rawValue != null && !entry.rawValue.isEmpty()) {
                        this.minecraft.field_71466_p.func_238421_b_(stack, ":", (float)separatorX, (float)relativeY, 0xFFFFFF);
                    }
                }
                this.minecraft.field_71466_p.func_243248_b(stack, entry.value, (float)valueX, (float)relativeY, 0xFFFFFF);
                if (entry.value.func_150256_b().func_150235_h() != null) {
                    entry.valueBounds = new Bounds(valueX, relativeY + 1, valueX + this.minecraft.field_71466_p.func_238414_a_((ITextProperties)entry.value), relativeY + this.lineHeight);
                }
                relativeY += this.lineHeight;
            }
            relativeY += this.lineHeight;
        }
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        Entry entry = this.getAllEntries().stream().filter(e -> e.valueBounds != null && e.valueBounds.isInBounds((int)mouseX, (int)mouseY)).findFirst().orElse(null);
        if (entry == null) {
            return false;
        }
        ITextComponent component = entry.value;
        if (component != null) {
            this.screen.func_230455_a_(component.func_150256_b());
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    @Override
    protected void drawBackground() {
    }

    public static ITextComponent newChatWithLinks(String string, boolean allowMissingHeader) {
        StringTextComponent ichat = null;
        Matcher matcher = URL_PATTERN.matcher(string);
        int lastEnd = 0;
        while (matcher.find()) {
            StringTextComponent link;
            String url;
            block12: {
                int start = matcher.start();
                int end = matcher.end();
                String part = string.substring(lastEnd, start);
                if (part.length() > 0) {
                    if (ichat == null) {
                        ichat = new StringTextComponent(part);
                    } else {
                        ichat.func_240702_b_(part);
                    }
                }
                lastEnd = end;
                url = string.substring(start, end);
                link = new StringTextComponent(url);
                try {
                    if (new URI(url).getScheme() != null) break block12;
                    if (!allowMissingHeader) {
                        if (ichat == null) {
                            ichat = new StringTextComponent(url);
                            continue;
                        }
                        ichat.func_240702_b_(url);
                        continue;
                    }
                    url = "http://" + url;
                }
                catch (URISyntaxException e) {
                    if (ichat == null) {
                        ichat = new StringTextComponent(url);
                        continue;
                    }
                    ichat.func_240702_b_(url);
                    continue;
                }
            }
            ClickEvent click = new ClickEvent(ClickEvent.Action.OPEN_URL, url);
            link.func_240700_a_(style -> style.func_240715_a_(click).func_244282_c(Boolean.valueOf(true)).func_240712_a_(TextFormatting.BLUE));
            ichat = ichat == null ? link : ichat.func_230529_a_((ITextComponent)link);
        }
        String end = string.substring(lastEnd);
        if (ichat == null) {
            ichat = new StringTextComponent(end);
        } else if (end.length() > 0) {
            ichat.func_240702_b_(string.substring(lastEnd));
        }
        return ichat;
    }

    private static final class Entry {
        protected final int level;
        @Nullable
        protected final String rawKey;
        @Nullable
        protected final String rawValue;
        @Nullable
        protected ITextComponent key;
        @Nullable
        protected ITextComponent value;
        @Nullable
        protected Bounds valueBounds;

        public Entry(@Nullable String key, @Nullable String value) {
            this(key, value, 0, null);
        }

        public Entry(@Nullable String key, @Nullable String value, int level) {
            this(key, value, level, null);
        }

        public Entry(@Nullable String key, @Nullable String value, int level, @Nullable String originalValue) {
            if (key != null) {
                this.key = new StringTextComponent(key);
            }
            this.rawKey = key;
            if (value != null) {
                ITextComponent linkComponent;
                IFormattableTextComponent newValue = new StringTextComponent(value).func_240699_a_(TextFormatting.GRAY);
                if (originalValue != null && (linkComponent = MetadataPanel.newChatWithLinks(originalValue, false)).func_150256_b().func_150235_h() != null) {
                    newValue.func_240700_a_(s2 -> linkComponent.func_150256_b().func_240717_a_(s2));
                }
                this.value = newValue;
            }
            this.rawValue = value;
            this.level = level;
        }
    }

    private static final class Category {
        protected final ITextComponent name;
        protected final String rawName;
        private final List<Entry> entries = new ArrayList<Entry>();

        public Category(String name) {
            this.name = new StringTextComponent(name).func_240700_a_(s2 -> s2.func_240713_a_(Boolean.valueOf(true)).func_244282_c(Boolean.valueOf(true)));
            this.rawName = name;
        }

        public Category(String name, List<Entry> entries) {
            this(name);
            this.entries.addAll(entries);
        }

        public Category addEntry(Entry entry) {
            this.entries.add(entry);
            return this;
        }

        public Category setEntries(List<Entry> entries) {
            this.entries.clear();
            this.entries.addAll(entries);
            return this;
        }

        public Category clearEntries() {
            this.entries.clear();
            return this;
        }

        public List<Entry> getEntries() {
            return Collections.unmodifiableList(this.entries);
        }
    }
}

