/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.client.gui.widget.list;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.text.TextFormatting;
import org.spongepowered.common.accessor.client.gui.widget.list.AbstractListAccessor;
import org.spongepowered.vanilla.util.Bounds;

public class FilterableList<P extends FilterableList<P, E>, E extends Entry<P, E>>
extends AbstractList<E> {
    private final Screen screen;
    private Supplier<List<E>> filterSupplier;
    private Consumer<E> selectConsumer;
    protected final FontRenderer fontRenderer;
    protected E currentHoveredEntry;

    public FilterableList(Screen screen, int x, int y, int width, int height, int entryHeight) {
        super(Minecraft.func_71410_x(), width, screen.field_230709_l_, y, y + height, entryHeight);
        this.screen = screen;
        this.field_230675_l_ = x;
        this.field_230674_k_ = x + width;
        this.fontRenderer = Minecraft.func_71410_x().field_71466_p;
    }

    public Screen getScreen() {
        return this.screen;
    }

    public int getX() {
        return this.field_230675_l_;
    }

    public P setX(int x) {
        this.field_230675_l_ = x;
        return (P)((Object)this);
    }

    public int getY() {
        return this.field_230672_i_;
    }

    public P setY(int y) {
        this.field_230672_i_ = y;
        return (P)((Object)this);
    }

    public P setPosition(int x, int y) {
        this.field_230675_l_ = x;
        this.field_230672_i_ = y;
        return (P)((Object)this);
    }

    public int getWidth() {
        return this.field_230670_d_;
    }

    public P setWidth(int width) {
        this.field_230670_d_ = width;
        return (P)((Object)this);
    }

    public int getHeight() {
        return this.field_230671_e_;
    }

    public P setHeight(int height) {
        this.field_230671_e_ = height;
        return (P)((Object)this);
    }

    public P setSize(int width, int height) {
        this.field_230670_d_ = width;
        this.field_230671_e_ = height;
        return (P)((Object)this);
    }

    public P setBounds(int x, int y, int width, int height) {
        this.field_230675_l_ = x;
        this.field_230672_i_ = y;
        this.field_230670_d_ = width;
        this.field_230671_e_ = height;
        return (P)((Object)this);
    }

    public int getRight() {
        return this.field_230675_l_ + this.field_230670_d_;
    }

    public int getBottom() {
        return this.field_230672_i_ + this.field_230677_n_;
    }

    public E getCurrentHoveredEntry() {
        return this.currentHoveredEntry;
    }

    public P setCurrentHoveredEntry(E currentHoveredEntry) {
        this.currentHoveredEntry = currentHoveredEntry;
        return (P)((Object)this);
    }

    @SafeVarargs
    public final P addEntries(E ... entries) {
        this.addEntries(Arrays.asList(entries));
        return (P)((Object)this);
    }

    public P addEntries(List<E> entries) {
        entries.forEach(arg_0 -> ((FilterableList)this).func_230513_b_(arg_0));
        return (P)((Object)this);
    }

    public Consumer<E> getSelectConsumer() {
        return this.selectConsumer;
    }

    public P setSelectConsumer(Consumer<E> selectConsumer) {
        this.selectConsumer = selectConsumer;
        return (P)((Object)this);
    }

    public Supplier<List<E>> getFilterSupplier() {
        return this.filterSupplier;
    }

    public P setFilterSupplier(Supplier<List<E>> filterSupplier) {
        this.filterSupplier = filterSupplier;
        return (P)((Object)this);
    }

    private int getRowBottom(int p_getRowBottom_1_) {
        return this.func_230962_i_(p_getRowBottom_1_) + this.field_230669_c_;
    }

    public int getRowHeight() {
        return this.field_230669_c_;
    }

    public int func_230949_c_() {
        return this.field_230670_d_ - 12;
    }

    public int func_230968_n_() {
        return this.field_230675_l_ + 4;
    }

    protected int func_230952_d_() {
        return this.field_230675_l_ + this.field_230670_d_ - 6;
    }

    public void setSelected(@Nullable E entry) {
        if (this.selectConsumer != null) {
            this.selectConsumer.accept(entry);
        }
        super.func_241215_a_(entry);
    }

    public void func_230430_a_(MatrixStack stack, int p_render_1_, int p_render_2_, float p_render_3_) {
        super.func_230430_a_(stack, p_render_1_, p_render_2_, p_render_3_);
    }

    public boolean func_231044_a_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        this.func_230947_b_(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
        if (!this.func_231047_b_(p_mouseClicked_1_, p_mouseClicked_3_)) {
            return false;
        }
        Entry e = (Entry)this.func_230933_a_(p_mouseClicked_1_, p_mouseClicked_3_);
        if (e != null) {
            if (e.func_231044_a_(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_)) {
                this.func_231035_a_((IGuiEventListener)e);
                this.func_231037_b__(true);
                return true;
            }
        } else if (p_mouseClicked_5_ == 0) {
            this.func_230938_a_((int)(p_mouseClicked_1_ - (double)(this.field_230675_l_ + this.field_230670_d_ / 2 - this.func_230949_c_() / 2)), (int)(p_mouseClicked_3_ - (double)this.field_230672_i_) + (int)this.func_230966_l_() - 4);
            return true;
        }
        return true;
    }

    protected void func_238478_a_(MatrixStack stack, int renderX, int renderY, int p_renderList_3_, int p_renderList_4_, float p_renderList_5_) {
        Object filteredList = this.filterSupplier == null ? new ObjectArrayList((Collection)this.func_231039_at__()) : this.filterSupplier.get();
        int itemCount = filteredList.size();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        if (filteredList.isEmpty()) {
            FontRenderer font = this.field_230668_b_.field_71466_p;
            String noResults = "No results...";
            int noResultsWidth = font.func_78256_a("No results...");
            font.func_238421_b_(stack, "No results...", (float)(this.field_230670_d_ / 2 + this.field_230675_l_ - noResultsWidth / 2), (float)(this.field_230672_i_ + 10), TextFormatting.GRAY.func_211163_e().intValue());
            return;
        }
        for (int i = 0; i < itemCount; ++i) {
            int rowTop = this.func_230962_i_(i);
            int rowBottom = this.getRowBottom(i);
            if (rowBottom < this.field_230672_i_ || rowTop > this.field_230673_j_) continue;
            int yStart = renderY + i * this.field_230669_c_ + this.field_230677_n_;
            int yEnd = this.field_230669_c_ - 4;
            int rowWidth = this.func_230949_c_();
            if (((AbstractListAccessor)((Object)this)).accessor$renderSelection() && Objects.equals(this.func_230958_g_(), filteredList.get(i))) {
                int xSelectStart = this.field_230675_l_ + this.field_230670_d_ / 2 - rowWidth / 2 - 2;
                int xSelectEnd = this.field_230675_l_ + this.field_230670_d_ / 2 + rowWidth / 2 - 4;
                GlStateManager.func_227621_I_();
                float f = this.func_230971_aw__() ? 1.0f : 0.5f;
                GlStateManager.func_227702_d_((float)f, (float)f, (float)f, (float)1.0f);
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
                bufferbuilder.func_225582_a_((double)xSelectStart, (double)(yStart + yEnd + 2), 0.0).func_181675_d();
                bufferbuilder.func_225582_a_((double)xSelectEnd, (double)(yStart + yEnd + 2), 0.0).func_181675_d();
                bufferbuilder.func_225582_a_((double)xSelectEnd, (double)(yStart - 2), 0.0).func_181675_d();
                bufferbuilder.func_225582_a_((double)xSelectStart, (double)(yStart - 2), 0.0).func_181675_d();
                tessellator.func_78381_a();
                GlStateManager.func_227702_d_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
                bufferbuilder.func_225582_a_((double)(xSelectStart + 1), (double)(yStart + yEnd + 1), 0.0).func_181675_d();
                bufferbuilder.func_225582_a_((double)(xSelectEnd - 1), (double)(yStart + yEnd + 1), 0.0).func_181675_d();
                bufferbuilder.func_225582_a_((double)(xSelectEnd - 1), (double)(yStart - 1), 0.0).func_181675_d();
                bufferbuilder.func_225582_a_((double)(xSelectStart + 1), (double)(yStart - 1), 0.0).func_181675_d();
                tessellator.func_78381_a();
                GlStateManager.func_227619_H_();
            }
            Entry entry = (Entry)((Object)filteredList.get(i));
            entry.func_230432_a_(stack, i, rowTop, this.func_230968_n_(), rowWidth, yEnd, p_renderList_3_, p_renderList_4_, false, p_renderList_5_);
        }
    }

    public static abstract class Entry<P extends FilterableList<P, E>, E extends Entry<P, E>>
    extends AbstractList.AbstractListEntry<E> {
        private final P parentList;

        public Entry(P parentList) {
            this.parentList = parentList;
        }

        public P getParentList() {
            return this.parentList;
        }

        public abstract Bounds getInteractBounds();

        public void func_230432_a_(MatrixStack stack, int p_render_1_, int renderY, int renderX, int p_render_4_, int p_render_5_, int mouseX, int mouseY, boolean p_render_8_, float p_render_9_) {
            if (this.getInteractBounds().isInBounds(mouseX, mouseY, renderX, renderY)) {
                ((FilterableList)((Object)this.parentList)).currentHoveredEntry = this;
            } else if (((FilterableList)((Object)this.parentList)).getCurrentHoveredEntry() == this) {
                ((FilterableList)((Object)this.parentList)).currentHoveredEntry = null;
            }
        }
    }
}

