/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.launch;

import com.google.inject.Stage;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Enumeration;
import org.spongepowered.common.applaunch.plugin.PluginEngine;
import org.spongepowered.common.launch.Launch;
import org.spongepowered.common.launch.plugin.DummyPluginContainer;
import org.spongepowered.plugin.PluginContainer;
import org.spongepowered.plugin.PluginKeys;
import org.spongepowered.plugin.metadata.PluginMetadata;
import org.spongepowered.plugin.metadata.util.PluginMetadataHelper;
import org.spongepowered.vanilla.applaunch.plugin.VanillaPluginEngine;
import org.spongepowered.vanilla.launch.plugin.VanillaPluginManager;

public abstract class VanillaLaunch
extends Launch {
    private final Stage injectionStage;
    private PluginContainer vanillaPlugin;

    protected VanillaLaunch(VanillaPluginEngine pluginEngine, Stage injectionStage) {
        super(pluginEngine, new VanillaPluginManager());
        this.injectionStage = injectionStage;
    }

    @Override
    public final boolean isVanilla() {
        return true;
    }

    @Override
    public final Stage getInjectionStage() {
        return this.injectionStage;
    }

    @Override
    public final void loadPlugins() {
        this.getPluginManager().loadPlugins(this.getPluginEngine());
    }

    @Override
    public final PluginContainer getPlatformPlugin() {
        if (this.vanillaPlugin == null) {
            this.vanillaPlugin = this.getPluginManager().getPlugin("spongevanilla").orElse(null);
            if (this.vanillaPlugin == null) {
                throw new RuntimeException("Could not find the plugin representing SpongeVanilla, this is a serious issue!");
            }
        }
        return this.vanillaPlugin;
    }

    @Override
    protected final void createPlatformPlugins(PluginEngine pluginEngine) {
        Path gameDirectory = (Path)this.pluginEngine.getPluginEnvironment().getBlackboard().get(PluginKeys.BASE_DIRECTORY).orElseThrow(() -> new RuntimeException("The game directory has not been added to the environment!"));
        try {
            URL classUrl = VanillaLaunch.class.getResource("/" + VanillaLaunch.class.getName().replace('.', '/') + ".class");
            Collection read = null;
            if (classUrl.getProtocol().equals("jar")) {
                String[] classUrlSplit = classUrl.getPath().split("!");
                Path expectedFile = Paths.get(new URI(classUrlSplit[0]));
                Enumeration<URL> manifests = VanillaLaunch.class.getClassLoader().getResources("/META-INF/plugins.json");
                while (manifests.hasMoreElements()) {
                    String[] pathSplit;
                    URL next = manifests.nextElement();
                    if (!next.getProtocol().equals("jar") || (pathSplit = next.getPath().split("!")).length != 2 || !Paths.get(new URI(pathSplit[0])).equals(expectedFile)) continue;
                    read = PluginMetadataHelper.builder().build().read(next.openStream());
                    break;
                }
            }
            if (read == null) {
                read = PluginMetadataHelper.builder().build().read(VanillaLaunch.class.getResourceAsStream("/META-INF/plugins.json"));
            }
            if (read == null) {
                throw new RuntimeException("Could not determine location for implementation metadata!");
            }
            for (PluginMetadata metadata : read) {
                this.getPluginManager().addDummyPlugin(new DummyPluginContainer(metadata, gameDirectory, this.getLogger(), this));
            }
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException("Could not load metadata information for the implementation! This should be impossible!");
        }
    }

    @Override
    public VanillaPluginEngine getPluginEngine() {
        return (VanillaPluginEngine)this.pluginEngine;
    }

    @Override
    public VanillaPluginManager getPluginManager() {
        return (VanillaPluginManager)this.pluginManager;
    }
}

