/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.mixin.core.network.play;

import java.util.Optional;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TranslatableComponent;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.play.IServerPlayNetHandler;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.network.play.client.CCustomPayloadPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.PlayerChatRouter;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.message.PlayerChatEvent;
import org.spongepowered.api.network.EngineConnection;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.network.play.client.CCustomPayloadPacketAccessor;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.network.channel.SpongeChannelRegistry;
import org.spongepowered.vanilla.chat.ChatFormatter;

@Mixin(value={ServerPlayNetHandler.class})
public abstract class ServerPlayNetHandlerMixin_Vanilla
implements IServerPlayNetHandler {
    @Shadow
    public ServerPlayerEntity field_147369_b;
    @Shadow
    @Final
    private MinecraftServer field_147367_d;

    @Inject(method={"handleCustomPayload"}, at={@At(value="HEAD")})
    private void onHandleCustomPayload(CCustomPayloadPacket packet, CallbackInfo ci) {
        ((CCustomPayloadPacketAccessor)packet).accessor$data().retain();
        SpongeChannelRegistry channelRegistry = (SpongeChannelRegistry)Sponge.getChannelRegistry();
        this.field_147367_d.execute(() -> channelRegistry.handlePlayPayload((EngineConnection)((Object)this), packet));
    }

    @Inject(method={"handleChat(Ljava/lang/String;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;broadcastMessage(Lnet/minecraft/util/text/ITextComponent;Lnet/minecraft/util/text/ChatType;Ljava/util/UUID;)V")}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD)
    private void vanilla$onProcessChatMessage(String p_244548_1_, CallbackInfo ci, ITextComponent component) {
        ChatFormatter.formatChatComponent((TranslationTextComponent)component);
        PlayerChatRouter chatRouter = ((ServerPlayer)this.field_147369_b).getChatRouter();
        Component adventure = SpongeAdventure.asAdventure(component);
        adventure = (Component)((TranslatableComponent)adventure).args().get(1);
        try (CauseStackManager.StackFrame frame = PhaseTracker.SERVER.pushCauseFrame();){
            frame.pushCause(this.field_147369_b);
            PlayerChatEvent event = SpongeEventFactory.createPlayerChatEvent(PhaseTracker.SERVER.getCurrentCause(), chatRouter, Optional.of(chatRouter), adventure, adventure);
            if (SpongeCommon.postEvent(event)) {
                ci.cancel();
            } else {
                event.getChatRouter().ifPresent(router -> router.chat((ServerPlayer)this.field_147369_b, event.getMessage()));
            }
        }
    }

    @Redirect(method={"handleChat(Ljava/lang/String;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;broadcastMessage(Lnet/minecraft/util/text/ITextComponent;Lnet/minecraft/util/text/ChatType;Ljava/util/UUID;)V"))
    private void vanilla$cancelSendChatMsgImpl(PlayerList playerList, ITextComponent p_232641_1_, ChatType p_232641_2_, UUID p_232641_3_) {
    }
}

