/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.world;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ReportedException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.SimpleRegistry;
import net.minecraft.util.registry.WorldGenSettingsExport;
import net.minecraft.util.registry.WorldSettingsImport;
import net.minecraft.village.VillageSiege;
import net.minecraft.world.Difficulty;
import net.minecraft.world.Dimension;
import net.minecraft.world.DimensionType;
import net.minecraft.world.ForcedChunksSaveData;
import net.minecraft.world.GameRules;
import net.minecraft.world.GameType;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.chunk.listener.IChunkStatusListener;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.settings.DimensionGeneratorSettings;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.TicketType;
import net.minecraft.world.spawner.CatSpawner;
import net.minecraft.world.spawner.PatrolSpawner;
import net.minecraft.world.spawner.PhantomSpawner;
import net.minecraft.world.spawner.WanderingTraderSpawner;
import net.minecraft.world.storage.CommandStorage;
import net.minecraft.world.storage.FolderName;
import net.minecraft.world.storage.IServerConfiguration;
import net.minecraft.world.storage.IServerWorldInfo;
import net.minecraft.world.storage.SaveFormat;
import net.minecraft.world.storage.ServerWorldInfo;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Server;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.registry.RegistryEntry;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.world.WorldType;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.api.world.server.WorldTemplate;
import org.spongepowered.api.world.server.storage.ServerWorldProperties;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.SpongeServer;
import org.spongepowered.common.accessor.server.MinecraftServerAccessor;
import org.spongepowered.common.accessor.world.gen.DimensionGeneratorSettingsAccessor;
import org.spongepowered.common.accessor.world.storage.SaveFormat_LevelSaveAccessor;
import org.spongepowered.common.accessor.world.storage.ServerWorldInfoAccessor;
import org.spongepowered.common.bridge.ResourceKeyBridge;
import org.spongepowered.common.bridge.world.DimensionBridge;
import org.spongepowered.common.bridge.world.ServerWorldBridge;
import org.spongepowered.common.bridge.world.gen.DimensionGeneratorSettingsBridge;
import org.spongepowered.common.bridge.world.storage.ServerWorldInfoBridge;
import org.spongepowered.common.config.SpongeGameConfigs;
import org.spongepowered.common.config.inheritable.InheritableConfigHandle;
import org.spongepowered.common.config.inheritable.WorldConfig;
import org.spongepowered.common.datapack.DataPackSerializer;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.launch.Launch;
import org.spongepowered.common.server.BootstrapProperties;
import org.spongepowered.common.user.SpongeUserManager;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.FutureUtil;
import org.spongepowered.common.world.server.SpongeWorldManager;
import org.spongepowered.common.world.server.SpongeWorldTemplate;

public final class VanillaWorldManager
implements SpongeWorldManager {
    private final MinecraftServer server;
    private final Path dimensionsDataPackDirectory;
    private final Path defaultWorldDirectory;
    private final Path customWorldsDirectory;
    private final Map<RegistryKey<World>, net.minecraft.world.server.ServerWorld> worlds;
    private static final TicketType<ResourceLocation> SPAWN_CHUNKS = TicketType.func_219484_a((String)"spawn_chunks", (i, o) -> i.compareTo(o));

    public VanillaWorldManager(MinecraftServer server) {
        this.server = server;
        this.dimensionsDataPackDirectory = ((MinecraftServerAccessor)server).accessor$storageSource().func_237285_a_(FolderName.field_237251_g_).resolve("plugin_dimension").resolve("data");
        try {
            Files.createDirectories(this.dimensionsDataPackDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.defaultWorldDirectory = ((SaveFormat_LevelSaveAccessor)((MinecraftServerAccessor)this.server).accessor$storageSource()).accessor$levelPath();
        this.customWorldsDirectory = this.defaultWorldDirectory.resolve("dimensions");
        try {
            Files.createDirectories(this.customWorldsDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.worlds = ((MinecraftServerAccessor)this.server).accessor$levels();
    }

    @Override
    public Path getDefaultWorldDirectory() {
        return this.defaultWorldDirectory;
    }

    @Override
    public Path getDimensionDataPackDirectory() {
        return this.dimensionsDataPackDirectory;
    }

    @Override
    public Server server() {
        return (Server)this.server;
    }

    @Override
    public ServerWorld defaultWorld() {
        net.minecraft.world.server.ServerWorld world = this.server.func_241755_D_();
        if (world == null) {
            throw new IllegalStateException("The default world has not been loaded yet! (Did you call this too early in the lifecycle?");
        }
        return (ServerWorld)world;
    }

    @Override
    public Optional<ServerWorld> world(ResourceKey key) {
        return Optional.ofNullable((ServerWorld)this.worlds.get(SpongeWorldManager.createRegistryKey(Objects.requireNonNull(key, "key"))));
    }

    @Override
    public Collection<ServerWorld> worlds() {
        return Collections.unmodifiableCollection(this.worlds.values());
    }

    @Override
    public List<ResourceKey> worldKeys() {
        ArrayList<ResourceKey> worldKeys = new ArrayList<ResourceKey>();
        worldKeys.add((ResourceKey)World.field_234918_g_.func_240901_a_());
        if (Files.exists(this.defaultWorldDirectory.resolve(this.getDirectoryName((ResourceKey)World.field_234919_h_.func_240901_a_())), new LinkOption[0])) {
            worldKeys.add((ResourceKey)World.field_234919_h_.func_240901_a_());
        }
        if (Files.exists(this.defaultWorldDirectory.resolve(this.getDirectoryName((ResourceKey)World.field_234920_i_.func_240901_a_())), new LinkOption[0])) {
            worldKeys.add((ResourceKey)World.field_234920_i_.func_240901_a_());
        }
        try {
            for (Path namespacedDirectory : Files.walk(this.customWorldsDirectory, 1, new FileVisitOption[0]).collect(Collectors.toList())) {
                if (this.customWorldsDirectory.equals(namespacedDirectory)) continue;
                for (Path valueDirectory : Files.walk(namespacedDirectory, 1, new FileVisitOption[0]).collect(Collectors.toList())) {
                    if (namespacedDirectory.equals(valueDirectory)) continue;
                    worldKeys.add(ResourceKey.of(namespacedDirectory.getFileName().toString(), valueDirectory.getFileName().toString()));
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return Collections.unmodifiableList(worldKeys);
    }

    @Override
    public boolean worldExists(ResourceKey key) {
        RegistryKey<World> registryKey = SpongeWorldManager.createRegistryKey(Objects.requireNonNull(key, "key"));
        if (World.field_234918_g_.equals(registryKey)) {
            return true;
        }
        if (this.worlds.get(registryKey) != null) {
            return true;
        }
        boolean isVanillaSubLevel = World.field_234919_h_.equals(registryKey) || World.field_234920_i_.equals(registryKey);
        Path levelDirectory = isVanillaSubLevel ? this.defaultWorldDirectory.resolve(this.getDirectoryName(key)) : this.customWorldsDirectory.resolve(key.getNamespace()).resolve(key.getValue());
        return Files.exists(levelDirectory, new LinkOption[0]);
    }

    @Override
    public Optional<ResourceKey> worldKey(UUID uniqueId) {
        Objects.requireNonNull(uniqueId, "uniqueId");
        return this.worlds.values().stream().filter(w -> ((ServerWorld)w).getUniqueId().equals(uniqueId)).map(w -> (ServerWorld)w).map(ServerWorld::getKey).findAny();
    }

    @Override
    public CompletableFuture<ServerWorld> loadWorld(WorldTemplate template) {
        net.minecraft.world.server.ServerWorld serverWorld;
        ResourceKey key = Objects.requireNonNull(template, "template").getKey();
        RegistryKey<World> registryKey = SpongeWorldManager.createRegistryKey(key);
        if (World.field_234918_g_.equals(registryKey)) {
            FutureUtil.completedWithException(new IllegalArgumentException("The default world cannot be told to load!"));
        }
        if ((serverWorld = this.worlds.get(registryKey)) != null) {
            return CompletableFuture.completedFuture((ServerWorld)serverWorld);
        }
        this.saveTemplate(template);
        return this.loadWorld0(registryKey, ((SpongeWorldTemplate)template).asDimension(), (DimensionGeneratorSettings)template.generationConfig());
    }

    @Override
    public CompletableFuture<ServerWorld> loadWorld(ResourceKey key) {
        net.minecraft.world.server.ServerWorld world;
        RegistryKey<World> registryKey = SpongeWorldManager.createRegistryKey(Objects.requireNonNull(key, "key"));
        if (World.field_234918_g_.equals(registryKey)) {
            FutureUtil.completedWithException(new IllegalArgumentException("The default world cannot be told to load!"));
        }
        if ((world = this.worlds.get(registryKey)) != null) {
            return CompletableFuture.completedFuture((ServerWorld)world);
        }
        return this.loadTemplate(key).thenCompose(r -> {
            WorldTemplate loadedTemplate = r.orElse(null);
            if (loadedTemplate == null) {
                Dimension scratch = (Dimension)BootstrapProperties.dimensionGeneratorSettings.func_236224_e_().func_230516_a_(RegistryKey.func_240903_a_((RegistryKey)Registry.field_239700_af_, (ResourceLocation)((ResourceLocation)key)));
                if (scratch != null) {
                    ((ResourceKeyBridge)scratch).bridge$setKey(key);
                    loadedTemplate = new SpongeWorldTemplate(scratch);
                }
                if (loadedTemplate == null) {
                    return FutureUtil.completedWithException(new IOException(String.format("Failed to load a template for '%s'!", key)));
                }
                this.saveTemplate(loadedTemplate);
            }
            return this.loadWorld0(registryKey, ((SpongeWorldTemplate)loadedTemplate).asDimension(), (DimensionGeneratorSettings)loadedTemplate.generationConfig());
        });
    }

    private CompletableFuture<ServerWorld> loadWorld0(RegistryKey<World> registryKey, Dimension template, DimensionGeneratorSettings generatorSettings) {
        SaveFormat.LevelSave storageSource;
        ServerWorldInfo defaultLevelData = (ServerWorldInfo)this.server.func_240793_aU_();
        WorldSettings defaultLevelSettings = ((ServerWorldInfoAccessor)defaultLevelData).accessor$settings();
        DimensionBridge templateBridge = (DimensionBridge)template;
        ResourceKey worldKey = ((ResourceKeyBridge)((Object)templateBridge)).bridge$getKey();
        WorldType worldType = (WorldType)template.func_236063_b_();
        ResourceKey worldTypeKey = RegistryTypes.WORLD_TYPE.get().valueKey((WorldType)template.func_236063_b_());
        MinecraftServerAccessor.accessor$LOGGER().info("Loading World '{}' ({})", (Object)worldKey, (Object)worldTypeKey);
        String directoryName = this.getDirectoryName(worldKey);
        boolean isVanillaSubLevel = this.isVanillaSubWorld(directoryName);
        try {
            storageSource = isVanillaSubLevel ? SaveFormat.func_237269_a_((Path)this.defaultWorldDirectory).func_237274_c_(directoryName) : SaveFormat.func_237269_a_((Path)this.customWorldsDirectory).func_237274_c_(worldKey.getNamespace() + File.separator + worldKey.getValue());
        }
        catch (IOException e) {
            e.printStackTrace();
            return FutureUtil.completedWithException(new RuntimeException(String.format("Failed to create level data for world '%s'!", worldKey), e));
        }
        ServerWorldInfo levelData = (ServerWorldInfo)storageSource.func_237284_a_(BootstrapProperties.worldSettingsAdapter, defaultLevelSettings.func_234958_g_());
        if (levelData == null) {
            DimensionGeneratorSettings generationSettings;
            WorldSettings levelSettings;
            if (this.server.func_71242_L()) {
                levelSettings = MinecraftServer.field_213219_c;
                generationSettings = DimensionGeneratorSettings.func_242752_a((DynamicRegistries)BootstrapProperties.registries);
            } else {
                levelSettings = new WorldSettings(directoryName, (GameType)BootstrapProperties.gameMode.get(Sponge.getGame().registries()), templateBridge.bridge$hardcore().orElse(BootstrapProperties.hardcore).booleanValue(), (Difficulty)BootstrapProperties.difficulty.get(Sponge.getGame().registries()), templateBridge.bridge$commands().orElse(BootstrapProperties.commands).booleanValue(), new GameRules(), defaultLevelData.func_230403_C_());
                generationSettings = generatorSettings;
            }
            levelData = new ServerWorldInfo(levelSettings, generationSettings, Lifecycle.stable());
        }
        ((ServerWorldInfoBridge)levelData).bridge$populateFromDimension(template);
        InheritableConfigHandle<WorldConfig> configAdapter = SpongeGameConfigs.createWorld(worldTypeKey, worldKey);
        ((ServerWorldInfoBridge)levelData).bridge$configAdapter(configAdapter);
        levelData.func_230412_a_(this.server.getServerModName(), this.server.func_230045_q_().isPresent());
        boolean isDebugGeneration = levelData.func_230418_z_().func_236227_h_();
        long seed = BiomeManager.func_235200_a_((long)levelData.func_230418_z_().func_236221_b_());
        IChunkStatusListener chunkStatusListener = ((MinecraftServerAccessor)this.server).accessor$getProgressListenerFactory().create(11);
        net.minecraft.world.server.ServerWorld world = new net.minecraft.world.server.ServerWorld(this.server, ((MinecraftServerAccessor)this.server).accessor$executor(), storageSource, (IServerWorldInfo)levelData, registryKey, (DimensionType)worldType, chunkStatusListener, template.func_236064_c_(), isDebugGeneration, seed, (List)ImmutableList.of(), true);
        this.worlds.put(registryKey, world);
        return ((CompletableFuture)((CompletableFuture)SpongeCommon.getAsyncScheduler().submit(() -> this.prepareWorld(world, isDebugGeneration)).thenApply(w -> {
            ((MinecraftServerAccessor)this.server).invoker$forceDifficulty();
            return w;
        })).thenCompose(w -> this.postWorldLoad((net.minecraft.world.server.ServerWorld)w, false))).thenApply(w -> (ServerWorld)w);
    }

    @Override
    public CompletableFuture<Boolean> unloadWorld(ResourceKey key) {
        RegistryKey<World> registryKey = SpongeWorldManager.createRegistryKey(Objects.requireNonNull(key, "key"));
        if (World.field_234918_g_.equals(registryKey)) {
            return CompletableFuture.completedFuture(false);
        }
        net.minecraft.world.server.ServerWorld world = this.worlds.get(registryKey);
        if (world == null) {
            return CompletableFuture.completedFuture(false);
        }
        return this.unloadWorld((ServerWorld)world);
    }

    @Override
    public CompletableFuture<Boolean> unloadWorld(ServerWorld world) {
        RegistryKey<World> registryKey = SpongeWorldManager.createRegistryKey(Objects.requireNonNull(world, "world").getKey());
        if (World.field_234918_g_.equals(registryKey)) {
            return CompletableFuture.completedFuture(false);
        }
        if (world != this.worlds.get(registryKey)) {
            return CompletableFuture.completedFuture(false);
        }
        try {
            this.unloadWorld0((net.minecraft.world.server.ServerWorld)world);
        }
        catch (IOException e) {
            return FutureUtil.completedWithException(e);
        }
        return CompletableFuture.completedFuture(true);
    }

    @Override
    public boolean templateExists(ResourceKey key) {
        return Files.exists(this.getDataPackFile(Objects.requireNonNull(key, "key")), new LinkOption[0]);
    }

    @Override
    public CompletableFuture<Optional<WorldTemplate>> loadTemplate(ResourceKey key) {
        Path dataPackFile = this.getDataPackFile(Objects.requireNonNull(key, "key"));
        if (Files.exists(dataPackFile, new LinkOption[0])) {
            try {
                Dimension template = this.loadTemplate0(SpongeWorldManager.createRegistryKey(key), dataPackFile);
                ((ResourceKeyBridge)template).bridge$setKey(key);
                return CompletableFuture.completedFuture(Optional.of(((DimensionBridge)template).bridge$asTemplate()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return CompletableFuture.completedFuture(Optional.empty());
    }

    @Override
    public CompletableFuture<Boolean> saveTemplate(WorldTemplate template) {
        Dimension scratch = ((SpongeWorldTemplate)Objects.requireNonNull(template, "template")).asDimension();
        try {
            JsonElement element = (JsonElement)SpongeWorldTemplate.DIRECT_CODEC.encodeStart((DynamicOps)WorldGenSettingsExport.func_240896_a_((DynamicOps)JsonOps.INSTANCE, (DynamicRegistries)BootstrapProperties.registries), (Object)scratch).getOrThrow(true, s2 -> {});
            Path dataPackFile = this.getDataPackFile(template.getKey());
            Files.createDirectories(dataPackFile.getParent(), new FileAttribute[0]);
            DataPackSerializer.writeFile(dataPackFile, element);
            DataPackSerializer.writePackMetadata("World", this.dimensionsDataPackDirectory.getParent());
        }
        catch (Exception ex) {
            FutureUtil.completedWithException(ex);
        }
        return CompletableFuture.completedFuture(true);
    }

    @Override
    public CompletableFuture<Optional<ServerWorldProperties>> loadProperties(ResourceKey key) {
        IServerConfiguration levelData;
        SaveFormat.LevelSave storageSource;
        RegistryKey<World> registryKey = SpongeWorldManager.createRegistryKey(Objects.requireNonNull(key, "key"));
        if (this.worlds.get(registryKey) != null) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        if (!this.worldExists(key)) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        boolean isVanillaWorld = this.isVanillaWorld(key);
        String directoryName = this.getDirectoryName(key);
        try {
            storageSource = isVanillaWorld ? SaveFormat.func_237269_a_((Path)this.defaultWorldDirectory).func_237274_c_(directoryName) : SaveFormat.func_237269_a_((Path)this.customWorldsDirectory).func_237274_c_(key.getNamespace() + File.separator + key.getValue());
        }
        catch (IOException e) {
            return FutureUtil.completedWithException(e);
        }
        ServerWorldInfo defaultLevelData = (ServerWorldInfo)this.server.func_240793_aU_();
        WorldSettings defaultLevelSettings = ((ServerWorldInfoAccessor)defaultLevelData).accessor$settings();
        try {
            levelData = storageSource.func_237284_a_(BootstrapProperties.worldSettingsAdapter, defaultLevelSettings.func_234958_g_());
        }
        catch (Exception ex) {
            return FutureUtil.completedWithException(ex);
        }
        return this.loadTemplate(key).thenCompose(r -> {
            r.ifPresent(template -> {
                Dimension scratch = ((SpongeWorldTemplate)template).asDimension();
                ((ServerWorldInfoBridge)levelData).bridge$populateFromDimension(scratch);
            });
            return CompletableFuture.completedFuture(Optional.of((ServerWorldProperties)levelData));
        });
    }

    @Override
    public CompletableFuture<Boolean> saveProperties(ServerWorldProperties properties) {
        SaveFormat.LevelSave storageSource;
        RegistryKey<World> registryKey = SpongeWorldManager.createRegistryKey(Objects.requireNonNull(properties, "properties").getKey());
        if (this.worlds.get(registryKey) != null) {
            return CompletableFuture.completedFuture(false);
        }
        ResourceKey key = properties.getKey();
        boolean isVanillaWorld = this.isVanillaWorld(key);
        String directoryName = this.getDirectoryName(key);
        try {
            storageSource = isVanillaWorld ? SaveFormat.func_237269_a_((Path)this.defaultWorldDirectory).func_237274_c_(directoryName) : SaveFormat.func_237269_a_((Path)this.customWorldsDirectory).func_237274_c_(key.getNamespace() + File.separator + key.getValue());
        }
        catch (IOException e) {
            return FutureUtil.completedWithException(e);
        }
        try {
            storageSource.func_237288_a_(BootstrapProperties.registries, (IServerConfiguration)properties, null);
        }
        catch (Exception ex) {
            return FutureUtil.completedWithException(ex);
        }
        return this.loadTemplate(key).thenCompose(r -> {
            WorldTemplate template = r.orElse(null);
            if (template != null) {
                Dimension scratch = ((SpongeWorldTemplate)template).asDimension();
                ((DimensionBridge)scratch).bridge$populateFromLevelData((ServerWorldInfo)properties);
                return this.saveTemplate(((DimensionBridge)scratch).bridge$asTemplate());
            }
            return CompletableFuture.completedFuture(true);
        });
    }

    @Override
    public CompletableFuture<Boolean> copyWorld(ResourceKey key, ResourceKey copyKey) {
        JsonObject fixedObject;
        Throwable throwable;
        RegistryKey<World> registryKey = SpongeWorldManager.createRegistryKey(Objects.requireNonNull(key, "key"));
        RegistryKey<World> copyRegistryKey = SpongeWorldManager.createRegistryKey(Objects.requireNonNull(copyKey, "copyKey"));
        if (World.field_234918_g_.equals(copyRegistryKey)) {
            return CompletableFuture.completedFuture(false);
        }
        if (!this.worldExists(key)) {
            return CompletableFuture.completedFuture(false);
        }
        if (this.worldExists(copyKey)) {
            return CompletableFuture.completedFuture(false);
        }
        net.minecraft.world.server.ServerWorld loadedWorld = this.worlds.get(registryKey);
        boolean disableLevelSaving = false;
        if (loadedWorld != null) {
            disableLevelSaving = loadedWorld.field_73058_d;
            loadedWorld.func_217445_a(null, true, loadedWorld.field_73058_d);
            loadedWorld.field_73058_d = true;
        }
        final boolean isDefaultWorld = this.isDefaultWorld(key);
        boolean isVanillaWorld = this.isVanillaWorld(key);
        String directoryName = this.getDirectoryName(key);
        final Path originalDirectory = isDefaultWorld ? this.defaultWorldDirectory : (isVanillaWorld ? this.defaultWorldDirectory.resolve(directoryName) : this.customWorldsDirectory.resolve(key.getNamespace()).resolve(key.getValue()));
        boolean isVanillaCopyWorld = this.isVanillaWorld(copyKey);
        String copyDirectoryName = this.getDirectoryName(copyKey);
        final Path copyDirectory = isVanillaCopyWorld ? this.defaultWorldDirectory.resolve(copyDirectoryName) : this.customWorldsDirectory.resolve(key.getNamespace()).resolve(key.getValue());
        try {
            Files.walkFileTree(originalDirectory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    if (dir.getFileName().toString().equals("dimensions")) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    if (isDefaultWorld && VanillaWorldManager.this.isVanillaSubWorld(dir.getFileName().toString())) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    Path relativize = originalDirectory.relativize(dir);
                    Path directory = copyDirectory.resolve(relativize);
                    Files.createDirectories(directory, new FileAttribute[0]);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    String fileName = file.getFileName().toString();
                    if (fileName.equals("level_sponge.dat_old")) {
                        return FileVisitResult.CONTINUE;
                    }
                    if (fileName.equals(Constants.World.LEVEL_DAT_OLD)) {
                        return FileVisitResult.CONTINUE;
                    }
                    Files.copy(file, copyDirectory.resolve(originalDirectory.relativize(file)), StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            try {
                Files.deleteIfExists(copyDirectory);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return FutureUtil.completedWithException(e);
        }
        if (loadedWorld != null) {
            loadedWorld.field_73058_d = disableLevelSaving;
        }
        Path dimensionTemplate = this.getDataPackFile(key);
        Path copiedDimensionTemplate = this.getDataPackFile(copyKey);
        try {
            Files.createDirectories(copiedDimensionTemplate.getParent(), new FileAttribute[0]);
            Files.copy(dimensionTemplate, copiedDimensionTemplate, new CopyOption[0]);
        }
        catch (IOException e) {
            FutureUtil.completedWithException(e);
        }
        try {
            throwable = null;
            try (InputStream stream = Files.newInputStream(copiedDimensionTemplate, new OpenOption[0]);
                 InputStreamReader reader = new InputStreamReader(stream);){
                JsonParser parser = new JsonParser();
                JsonElement element = parser.parse(reader);
                JsonObject root = element.getAsJsonObject();
                JsonObject spongeData = root.getAsJsonObject("#sponge");
                spongeData.remove("unique_id");
                fixedObject = root;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException e) {
            return FutureUtil.completedWithException(e);
        }
        if (fixedObject != null) {
            try {
                throwable = null;
                try (BufferedWriter writer = Files.newBufferedWriter(copiedDimensionTemplate, new OpenOption[0]);){
                    writer.write(fixedObject.getAsString());
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (IOException e) {
                FutureUtil.completedWithException(e);
            }
        }
        return CompletableFuture.completedFuture(true);
    }

    @Override
    public CompletableFuture<Boolean> moveWorld(ResourceKey key, ResourceKey movedKey) {
        RegistryKey<World> registryKey = SpongeWorldManager.createRegistryKey(Objects.requireNonNull(key, "key"));
        if (World.field_234918_g_.equals(registryKey)) {
            return CompletableFuture.completedFuture(false);
        }
        if (!this.worldExists(key)) {
            return CompletableFuture.completedFuture(false);
        }
        if (this.worldExists(movedKey)) {
            return CompletableFuture.completedFuture(false);
        }
        net.minecraft.world.server.ServerWorld loadedWorld = this.worlds.get(registryKey);
        if (loadedWorld != null) {
            try {
                this.unloadWorld0(loadedWorld);
            }
            catch (IOException e) {
                return FutureUtil.completedWithException(e);
            }
        }
        boolean isVanillaWorld = this.isVanillaWorld(key);
        String directoryName = this.getDirectoryName(key);
        Path originalDirectory = isVanillaWorld ? this.defaultWorldDirectory.resolve(directoryName) : this.customWorldsDirectory.resolve(key.getNamespace()).resolve(key.getValue());
        boolean isVanillaMoveWorld = this.isVanillaWorld(movedKey);
        String moveDirectoryName = this.getDirectoryName(movedKey);
        Path moveDirectory = isVanillaMoveWorld ? this.defaultWorldDirectory.resolve(moveDirectoryName) : this.customWorldsDirectory.resolve(key.getNamespace()).resolve(key.getValue());
        try {
            Files.createDirectories(moveDirectory, new FileAttribute[0]);
            Files.move(originalDirectory, moveDirectory, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            return FutureUtil.completedWithException(e);
        }
        Path configFile = SpongeCommon.getSpongeConfigDirectory().resolve("sponge").resolve("worlds").resolve(key.getNamespace()).resolve(key.getValue() + ".conf");
        Path copiedConfigFile = SpongeCommon.getSpongeConfigDirectory().resolve("sponge").resolve("worlds").resolve(movedKey.getNamespace()).resolve(movedKey.getValue() + ".conf");
        try {
            Files.createDirectories(copiedConfigFile.getParent(), new FileAttribute[0]);
            Files.move(configFile, copiedConfigFile, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            return FutureUtil.completedWithException(e);
        }
        Path dimensionTemplate = this.getDataPackFile(key);
        Path copiedDimensionTemplate = this.getDataPackFile(movedKey);
        try {
            Files.createDirectories(copiedDimensionTemplate.getParent(), new FileAttribute[0]);
            Files.move(dimensionTemplate, copiedDimensionTemplate, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            FutureUtil.completedWithException(e);
        }
        return CompletableFuture.completedFuture(true);
    }

    @Override
    public CompletableFuture<Boolean> deleteWorld(ResourceKey key) {
        Path directory;
        RegistryKey<World> registryKey = SpongeWorldManager.createRegistryKey(Objects.requireNonNull(key, "key"));
        if (World.field_234918_g_.equals(registryKey)) {
            return CompletableFuture.completedFuture(false);
        }
        if (!this.worldExists(key)) {
            return CompletableFuture.completedFuture(false);
        }
        net.minecraft.world.server.ServerWorld loadedWorld = this.worlds.get(registryKey);
        if (loadedWorld != null) {
            boolean disableLevelSaving = loadedWorld.field_73058_d;
            loadedWorld.field_73058_d = true;
            try {
                this.unloadWorld0(loadedWorld);
            }
            catch (IOException e) {
                loadedWorld.field_73058_d = disableLevelSaving;
                return FutureUtil.completedWithException(e);
            }
        }
        boolean isVanillaWorld = this.isVanillaWorld(key);
        String directoryName = this.getDirectoryName(key);
        Path path = directory = isVanillaWorld ? this.defaultWorldDirectory.resolve(directoryName) : this.customWorldsDirectory.resolve(key.getNamespace()).resolve(key.getValue());
        if (Files.exists(directory, new LinkOption[0])) {
            try {
                for (Path path2 : Files.walk(directory, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).collect(Collectors.toList())) {
                    Files.deleteIfExists(path2);
                }
            }
            catch (IOException e) {
                return FutureUtil.completedWithException(e);
            }
        }
        Path configFile = SpongeCommon.getSpongeConfigDirectory().resolve("sponge").resolve("worlds").resolve(key.getNamespace()).resolve(key.getValue() + ".conf");
        try {
            Files.deleteIfExists(configFile);
        }
        catch (IOException e) {
            return FutureUtil.completedWithException(e);
        }
        Path dimensionTemplate = this.getDataPackFile(key);
        try {
            Files.deleteIfExists(dimensionTemplate);
        }
        catch (IOException e) {
            FutureUtil.completedWithException(e);
        }
        return CompletableFuture.completedFuture(true);
    }

    @Override
    public void unloadWorld0(net.minecraft.world.server.ServerWorld world) throws IOException {
        RegistryKey registryKey = world.func_234923_W_();
        if (world.func_217490_a(p -> true).size() != 0) {
            throw new IOException(String.format("World '%s' was told to unload but players remain.", registryKey.func_240901_a_()));
        }
        SpongeCommon.getLogger().info("Unloading World '{}' ({})", (Object)registryKey.func_240901_a_(), (Object)RegistryTypes.WORLD_TYPE.get().valueKey((WorldType)world.func_230315_m_()));
        BlockPos spawnPoint = world.func_241135_u_();
        world.func_72863_F().func_217222_b(SPAWN_CHUNKS, new ChunkPos(spawnPoint), 11, (Object)registryKey.func_240901_a_());
        ((ServerWorldInfoBridge)world.func_72912_H()).bridge$configAdapter().save();
        ((ServerWorldBridge)world).bridge$setManualSave(true);
        try {
            world.func_217445_a(null, true, world.field_73058_d);
            world.close();
            ((ServerWorldBridge)world).bridge$getLevelSave().close();
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        this.worlds.remove(registryKey);
        SpongeCommon.postEvent(SpongeEventFactory.createUnloadWorldEvent(PhaseTracker.getCauseStackManager().getCurrentCause(), (ServerWorld)world));
    }

    @Override
    public void loadLevel() {
        boolean multiworldEnabled;
        ServerWorldInfo defaultLevelData = (ServerWorldInfo)this.server.func_240793_aU_();
        DimensionGeneratorSettings defaultGenerationSettings = defaultLevelData.func_230418_z_();
        WorldSettings defaultLevelSettings = ((ServerWorldInfoAccessor)defaultLevelData).accessor$settings();
        SimpleRegistry templates = defaultGenerationSettings.func_236224_e_();
        boolean bl = multiworldEnabled = this.server.func_71264_H() || this.server.func_71255_r();
        if (!multiworldEnabled) {
            SpongeCommon.getLogger().warn("The option 'allow-nether' has been set to 'false' in the server.properties. Multi-World support has been disabled and no worlds besides the default world will be loaded.");
        }
        for (RegistryEntry registryEntry : ((org.spongepowered.api.registry.Registry)templates).streamEntries().collect(Collectors.toList())) {
            boolean isDebugGeneration;
            ServerWorldInfo levelData;
            SaveFormat.LevelSave storageSource;
            ResourceKey worldKey = registryEntry.key();
            Dimension template = (Dimension)registryEntry.value();
            DimensionBridge templateBridge = (DimensionBridge)template;
            ((ResourceKeyBridge)((Object)templateBridge)).bridge$setKey(worldKey);
            boolean isDefaultWorld = this.isDefaultWorld(worldKey);
            if (!isDefaultWorld && !multiworldEnabled) continue;
            WorldType worldType = (WorldType)template.func_236063_b_();
            ResourceKey worldTypeKey = RegistryTypes.WORLD_TYPE.get().valueKey((WorldType)template.func_236063_b_());
            MinecraftServerAccessor.accessor$LOGGER().info("Loading World '{}' ({})", (Object)worldKey, (Object)worldTypeKey);
            if (!isDefaultWorld && !templateBridge.bridge$loadOnStartup()) {
                SpongeCommon.getLogger().warn("World '{}' has been disabled from loading at startup. Skipping...", (Object)worldKey);
                continue;
            }
            String directoryName = this.getDirectoryName(worldKey);
            boolean isVanillaSubLevel = this.isVanillaSubWorld(directoryName);
            if (isDefaultWorld) {
                storageSource = ((MinecraftServerAccessor)this.server).accessor$storageSource();
            } else {
                try {
                    storageSource = isVanillaSubLevel ? SaveFormat.func_237269_a_((Path)this.defaultWorldDirectory).func_237274_c_(directoryName) : SaveFormat.func_237269_a_((Path)this.customWorldsDirectory).func_237274_c_(worldKey.getNamespace() + File.separator + worldKey.getValue());
                }
                catch (IOException e) {
                    throw new RuntimeException(String.format("Failed to create level data for world '%s'!", worldKey), e);
                }
            }
            if (isDefaultWorld) {
                levelData = defaultLevelData;
                isDebugGeneration = defaultGenerationSettings.func_236227_h_();
            } else {
                levelData = (ServerWorldInfo)storageSource.func_237284_a_(BootstrapProperties.worldSettingsAdapter, defaultLevelSettings.func_234958_g_());
                if (levelData == null) {
                    DimensionGeneratorSettings generationSettings;
                    WorldSettings levelSettings;
                    if (this.server.func_71242_L()) {
                        levelSettings = MinecraftServer.field_213219_c;
                        generationSettings = DimensionGeneratorSettings.func_242752_a((DynamicRegistries)BootstrapProperties.registries);
                    } else {
                        levelSettings = new WorldSettings(directoryName, (GameType)BootstrapProperties.gameMode.get(Sponge.getGame().registries()), templateBridge.bridge$hardcore().orElse(BootstrapProperties.hardcore).booleanValue(), (Difficulty)BootstrapProperties.difficulty.get(Sponge.getGame().registries()), templateBridge.bridge$commands().orElse(BootstrapProperties.commands).booleanValue(), new GameRules(), defaultLevelData.func_230403_C_());
                        generationSettings = ((DimensionGeneratorSettingsBridge)defaultLevelData.func_230418_z_()).bridge$copy();
                    }
                    isDebugGeneration = generationSettings.func_236227_h_();
                    ((DimensionGeneratorSettingsAccessor)generationSettings).accessor$dimensions((SimpleRegistry<Dimension>)new SimpleRegistry(Registry.field_239700_af_, Lifecycle.stable()));
                    levelData = new ServerWorldInfo(levelSettings, generationSettings, Lifecycle.stable());
                } else {
                    isDebugGeneration = levelData.func_230418_z_().func_236227_h_();
                }
            }
            ((ServerWorldInfoBridge)levelData).bridge$populateFromDimension(template);
            InheritableConfigHandle<WorldConfig> configAdapter = SpongeGameConfigs.createWorld(worldTypeKey, worldKey);
            ((ServerWorldInfoBridge)levelData).bridge$configAdapter(configAdapter);
            levelData.func_230412_a_(this.server.getServerModName(), this.server.func_230045_q_().isPresent());
            long seed = BiomeManager.func_235200_a_((long)levelData.func_230418_z_().func_236221_b_());
            RegistryKey<World> registryKey = SpongeWorldManager.createRegistryKey(worldKey);
            IChunkStatusListener chunkStatusListener = ((MinecraftServerAccessor)this.server).accessor$getProgressListenerFactory().create(11);
            ImmutableList spawners = isDefaultWorld ? ImmutableList.of((Object)new PhantomSpawner(), (Object)new PatrolSpawner(), (Object)new CatSpawner(), (Object)new VillageSiege(), (Object)new WanderingTraderSpawner((IServerWorldInfo)levelData)) : ImmutableList.of();
            net.minecraft.world.server.ServerWorld world = new net.minecraft.world.server.ServerWorld(this.server, ((MinecraftServerAccessor)this.server).accessor$executor(), storageSource, (IServerWorldInfo)levelData, registryKey, (DimensionType)worldType, chunkStatusListener, template.func_236064_c_(), isDebugGeneration, seed, (List)spawners, true);
            this.worlds.put(registryKey, world);
            this.prepareWorld(world, isDebugGeneration);
        }
        ((MinecraftServerAccessor)this.server).invoker$forceDifficulty();
        for (Map.Entry entry : this.worlds.entrySet()) {
            try {
                this.postWorldLoad((net.minecraft.world.server.ServerWorld)entry.getValue(), true).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new IllegalStateException(e);
            }
        }
        ((SpongeUserManager)Sponge.getServer().getUserManager()).init();
        ((SpongeServer)SpongeCommon.getServer()).getPlayerDataManager().load();
    }

    private net.minecraft.world.server.ServerWorld prepareWorld(net.minecraft.world.server.ServerWorld world, boolean isDebugGeneration) {
        boolean isDefaultWorld = World.field_234918_g_.equals(world.func_234923_W_());
        ServerWorldInfo levelData = (ServerWorldInfo)world.func_72912_H();
        if (isDefaultWorld) {
            ((MinecraftServerAccessor)this.server).accessor$readScoreboard(world.func_217481_x());
            ((MinecraftServerAccessor)this.server).accessor$commandStorage(new CommandStorage(world.func_217481_x()));
        }
        boolean isInitialized = levelData.func_76070_v();
        SpongeCommon.postEvent(SpongeEventFactory.createLoadWorldEvent(PhaseTracker.getCauseStackManager().getCurrentCause(), (ServerWorld)world, isInitialized));
        ((ServerWorldInfoBridge)world.func_72912_H()).bridge$viewDistance().ifPresent(v -> ((ServerWorldInfoBridge)world.func_72912_H()).bridge$setViewDistance((Integer)v));
        world.func_175723_af().func_235926_a_(levelData.func_230398_q_());
        if (!isInitialized) {
            try {
                boolean hasSpawnAlready = ((ServerWorldInfoBridge)world.func_72912_H()).bridge$customSpawnPosition();
                if (!hasSpawnAlready) {
                    if (isDefaultWorld || ((ServerWorldProperties)world.func_72912_H()).performsSpawnLogic()) {
                        MinecraftServerAccessor.invoker$setInitialSpawn(world, (IServerWorldInfo)levelData, levelData.func_230418_z_().func_236223_d_(), isDebugGeneration, !isDebugGeneration);
                    } else if (World.field_234920_i_.equals(world.func_234923_W_())) {
                        ((ServerWorldInfo)world.func_72912_H()).func_176143_a(net.minecraft.world.server.ServerWorld.field_241108_a_, 0.0f);
                    }
                } else {
                    Features.field_243795_U.func_242765_a((ISeedReader)world, world.func_72863_F().func_201711_g(), world.field_73012_v, new BlockPos(levelData.func_76079_c(), levelData.func_76075_d(), levelData.func_76074_e()));
                }
                levelData.func_76091_d(true);
                if (isDebugGeneration) {
                    ((MinecraftServerAccessor)this.server).invoker$setDebugLevel((IServerConfiguration)levelData);
                }
            }
            catch (Throwable throwable) {
                CrashReport crashReport = CrashReport.func_85055_a((Throwable)throwable, (String)("Exception initializing world '" + world.func_234923_W_().func_240901_a_() + "'"));
                try {
                    world.func_72914_a(crashReport);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw new ReportedException(crashReport);
            }
            levelData.func_76091_d(true);
        }
        this.server.func_184103_al().func_212504_a(world);
        if (levelData.func_230404_D_() != null) {
            ((ServerWorldBridge)world).bridge$getBossBarManager().func_201381_a(levelData.func_230404_D_());
        }
        return world;
    }

    private CompletableFuture<net.minecraft.world.server.ServerWorld> postWorldLoad(net.minecraft.world.server.ServerWorld world, boolean blocking) {
        ServerWorldInfo levelData = (ServerWorldInfo)world.func_72912_H();
        ServerWorldInfoBridge levelBridge = (ServerWorldInfoBridge)levelData;
        boolean isDefaultWorld = this.isDefaultWorld((ResourceKey)world.func_234923_W_().func_240901_a_());
        if (isDefaultWorld || levelBridge.bridge$performsSpawnLogic()) {
            MinecraftServerAccessor.accessor$LOGGER().info("Preparing start region for world '{}' ({})", (Object)world.func_234923_W_().func_240901_a_(), (Object)RegistryTypes.WORLD_TYPE.get().valueKey((WorldType)world.func_230315_m_()));
            if (blocking) {
                this.loadSpawnChunks(world);
                return CompletableFuture.completedFuture(world);
            }
            return this.loadSpawnChunksAsync(world);
        }
        return CompletableFuture.completedFuture(world);
    }

    private CompletableFuture<net.minecraft.world.server.ServerWorld> loadSpawnChunksAsync(net.minecraft.world.server.ServerWorld world) {
        BlockPos spawnPoint = world.func_241135_u_();
        ChunkPos chunkPos = new ChunkPos(spawnPoint);
        ServerChunkProvider serverChunkProvider = world.func_72863_F();
        serverChunkProvider.func_212863_j_().func_215598_a(500);
        int borderRadius = 11;
        int diameter = 21;
        int spawnChunks = 441;
        serverChunkProvider.func_217228_a(SPAWN_CHUNKS, chunkPos, 11, (Object)world.func_234923_W_().func_240901_a_());
        CompletableFuture generationFuture = new CompletableFuture();
        Sponge.getAsyncScheduler().submit(Task.builder().plugin(((Launch)Launch.getInstance()).getPlatformPlugin()).execute(task -> {
            if (serverChunkProvider.func_217229_b() >= 441) {
                Sponge.getServer().getScheduler().submit(Task.builder().plugin(((Launch)Launch.getInstance()).getPlatformPlugin()).execute(() -> generationFuture.complete(world)).build());
                task.cancel();
                MinecraftServerAccessor.accessor$LOGGER().info("Done preparing start region for world '{}' ({})", (Object)world.func_234923_W_().func_240901_a_(), (Object)RegistryTypes.WORLD_TYPE.get().valueKey((WorldType)world.func_230315_m_()));
            }
        }).interval(10L, TimeUnit.MILLISECONDS).build());
        return generationFuture.thenApply(v -> {
            this.updateForcedChunks(world, serverChunkProvider);
            serverChunkProvider.func_212863_j_().func_215598_a(5);
            if (!((ServerWorldInfoBridge)world.func_72912_H()).bridge$performsSpawnLogic()) {
                serverChunkProvider.func_217222_b(SPAWN_CHUNKS, chunkPos, 11, (Object)world.func_234923_W_().func_240901_a_());
            }
            return world;
        });
    }

    private void loadSpawnChunks(net.minecraft.world.server.ServerWorld world) {
        BlockPos spawnPoint = world.func_241135_u_();
        ChunkPos chunkPos = new ChunkPos(spawnPoint);
        IChunkStatusListener chunkStatusListener = ((ServerWorldBridge)world).bridge$getChunkStatusListener();
        chunkStatusListener.func_219509_a(chunkPos);
        ServerChunkProvider serverChunkProvider = world.func_72863_F();
        serverChunkProvider.func_212863_j_().func_215598_a(500);
        ((MinecraftServerAccessor)this.server).accessor$setNextTickTime(Util.func_211177_b());
        serverChunkProvider.func_217228_a(SPAWN_CHUNKS, chunkPos, 11, (Object)world.func_234923_W_().func_240901_a_());
        while (serverChunkProvider.func_217229_b() != 441) {
            ((MinecraftServerAccessor)this.server).accessor$setNextTickTime(Util.func_211177_b() + 10L);
            ((MinecraftServerAccessor)this.server).accessor$waitUntilNextTick();
        }
        ((MinecraftServerAccessor)this.server).accessor$setNextTickTime(Util.func_211177_b() + 10L);
        ((MinecraftServerAccessor)this.server).accessor$waitUntilNextTick();
        this.updateForcedChunks(world, serverChunkProvider);
        ((MinecraftServerAccessor)this.server).accessor$setNextTickTime(Util.func_211177_b() + 10L);
        ((MinecraftServerAccessor)this.server).accessor$waitUntilNextTick();
        chunkStatusListener.func_219510_b();
        serverChunkProvider.func_212863_j_().func_215598_a(5);
        if (!((ServerWorldInfoBridge)world.func_72912_H()).bridge$performsSpawnLogic()) {
            serverChunkProvider.func_217222_b(SPAWN_CHUNKS, chunkPos, 11, (Object)world.func_234923_W_().func_240901_a_());
        }
    }

    private void updateForcedChunks(net.minecraft.world.server.ServerWorld world, ServerChunkProvider serverChunkProvider) {
        ForcedChunksSaveData forcedChunksSaveData = (ForcedChunksSaveData)world.func_217481_x().func_215753_b(ForcedChunksSaveData::new, "chunks");
        if (forcedChunksSaveData != null) {
            LongIterator longIterator = forcedChunksSaveData.func_212438_a().iterator();
            while (longIterator.hasNext()) {
                long i = longIterator.nextLong();
                ChunkPos forceChunkPos = new ChunkPos(i);
                serverChunkProvider.func_217206_a(forceChunkPos, true);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private Dimension loadTemplate0(RegistryKey<World> registryKey, Path file) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static final class SingleTemplateAccess
    implements WorldSettingsImport.IResourceAccess {
        private final RegistryKey<?> key;
        private final JsonElement element;

        public SingleTemplateAccess(RegistryKey<?> key, JsonElement element) {
            this.key = key;
            this.element = element;
        }

        public Collection<ResourceLocation> func_241880_a(RegistryKey<? extends Registry<?>> registryKey) {
            if (this.key.func_244356_a(registryKey)) {
                return Collections.singletonList(new ResourceLocation(this.key.func_240901_a_().func_110624_b(), registryKey.func_240901_a_().func_110623_a() + "/" + this.key.func_240901_a_().func_110623_a() + ".json"));
            }
            return Collections.emptyList();
        }

        public <E> DataResult<Pair<E, OptionalInt>> func_241879_a(DynamicOps<JsonElement> ops, RegistryKey<? extends Registry<E>> registryKey, RegistryKey<E> elementKey, Decoder<E> decoder) {
            DataResult result = decoder.parse(ops, (Object)this.element);
            return result.map(t -> Pair.of((Object)t, (Object)OptionalInt.empty()));
        }
    }
}

