/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.event.cause.entity.damage.source;

import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.entity.FallingBlock;
import org.spongepowered.api.event.cause.entity.damage.source.EntityDamageSource;
import org.spongepowered.api.util.Ticks;

public interface FallingBlockDamageSource
extends EntityDamageSource {
    public static Builder builder() {
        return Sponge.game().builderProvider().provide(Builder.class);
    }

    @Override
    public FallingBlock source();

    default public Value.Immutable<Double> fallDamagePerBlock() {
        return this.source().requireValue(Keys.DAMAGE_PER_BLOCK).asImmutable();
    }

    default public Value.Immutable<Double> maxFallDamage() {
        return this.source().requireValue(Keys.MAX_FALL_DAMAGE).asImmutable();
    }

    default public Value.Immutable<BlockState> blockState() {
        return this.source().requireValue(Keys.BLOCK_STATE).asImmutable();
    }

    default public Value.Immutable<Boolean> canPlaceAsBlock() {
        return this.source().requireValue(Keys.CAN_PLACE_AS_BLOCK).asImmutable();
    }

    default public Value.Immutable<Boolean> canDropAsItem() {
        return this.source().requireValue(Keys.CAN_DROP_AS_ITEM).asImmutable();
    }

    default public Value.Immutable<Ticks> fallTime() {
        return this.source().fallTime().asImmutable();
    }

    default public Value.Immutable<Boolean> canHurtEntities() {
        return this.source().requireValue(Keys.CAN_HURT_ENTITIES).asImmutable();
    }

    public static interface Builder
    extends EntityDamageSource.EntityDamageSourceBuilder<FallingBlockDamageSource, Builder> {
        public Builder places(boolean var1);

        public Builder fallTime(Ticks var1);

        public Builder hurtsEntities(boolean var1);

        public Builder maxDamage(double var1);

        public Builder damagePerBlock(double var1);
    }
}

