/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.item.recipe.cooking;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.recipe.Recipe;
import org.spongepowered.api.item.recipe.RecipeRegistration;
import org.spongepowered.api.item.recipe.RecipeType;
import org.spongepowered.api.item.recipe.cooking.CookingResult;
import org.spongepowered.api.item.recipe.crafting.Ingredient;
import org.spongepowered.api.util.ResourceKeyedBuilder;
import org.spongepowered.api.util.Ticks;

public interface CookingRecipe
extends Recipe {
    public static Builder builder() {
        return Sponge.game().builderProvider().provide(Builder.class);
    }

    public Ingredient ingredient();

    public boolean isValid(ItemStackSnapshot var1);

    public Optional<CookingResult> result(ItemStackSnapshot var1);

    public Ticks cookingTime();

    public float experience();

    public static interface Builder
    extends ResourceKeyedBuilder<RecipeRegistration, Builder> {
        public IngredientStep type(RecipeType<CookingRecipe> var1);

        default public IngredientStep type(Supplier<RecipeType<CookingRecipe>> type) {
            return this.type(type.get());
        }

        public static interface EndStep
        extends Builder,
        org.spongepowered.api.util.Builder<RecipeRegistration, Builder> {
            public EndStep group(@Nullable String var1);

            public EndStep experience(double var1);

            public EndStep cookingTime(Ticks var1);
        }

        public static interface ResultStep
        extends Builder {
            public EndStep result(ItemType var1);

            default public EndStep result(Supplier<? extends ItemType> result) {
                return this.result(result.get());
            }

            public EndStep result(ItemStack var1);

            public EndStep result(ItemStackSnapshot var1);

            public EndStep result(Function<Inventory, ItemStack> var1, ItemStack var2);
        }

        public static interface IngredientStep
        extends Builder {
            public ResultStep ingredient(Ingredient var1);

            default public ResultStep ingredient(ItemType ingredient) {
                return this.ingredient(Ingredient.of(ingredient));
            }

            default public ResultStep ingredient(Supplier<? extends ItemType> ingredient) {
                return this.ingredient(ingredient.get());
            }
        }
    }
}

