/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.volume.game;

import java.time.Duration;
import java.util.Objects;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.world.volume.block.BlockVolume;
import org.spongepowered.api.world.volume.game.LocationBaseDataHolder;
import org.spongepowered.math.vector.Vector3i;

public interface InteractableVolume
extends BlockVolume,
LocationBaseDataHolder {
    default public boolean hitBlock(Vector3i position, Direction side, GameProfile profile) {
        return this.hitBlock(Objects.requireNonNull(position, "position").x(), position.y(), position.z(), side, profile);
    }

    public boolean hitBlock(int var1, int var2, int var3, Direction var4, GameProfile var5);

    default public boolean interactBlock(Vector3i position, Direction side, GameProfile profile) {
        return this.interactBlock(Objects.requireNonNull(position, "position").x(), position.y(), position.z(), side, profile);
    }

    public boolean interactBlock(int var1, int var2, int var3, Direction var4, GameProfile var5);

    default public boolean interactBlockWith(Vector3i position, ItemStack itemStack, Direction side, GameProfile profile) {
        return this.interactBlockWith(Objects.requireNonNull(position, "position").x(), position.y(), position.z(), itemStack, side, profile);
    }

    public boolean interactBlockWith(int var1, int var2, int var3, ItemStack var4, Direction var5, GameProfile var6);

    default public boolean placeBlock(Vector3i position, BlockState block, Direction side, GameProfile profile) {
        return this.placeBlock(Objects.requireNonNull(position, "position").x(), position.y(), position.z(), block, side, profile);
    }

    public boolean placeBlock(int var1, int var2, int var3, BlockState var4, Direction var5, GameProfile var6);

    default public boolean digBlock(Vector3i position, GameProfile profile) {
        return this.digBlock(Objects.requireNonNull(position, "position").x(), position.y(), position.z(), profile);
    }

    public boolean digBlock(int var1, int var2, int var3, GameProfile var4);

    default public boolean digBlockWith(Vector3i position, ItemStack itemStack, GameProfile profile) {
        return this.digBlockWith(Objects.requireNonNull(position, "position").x(), position.y(), position.z(), itemStack, profile);
    }

    public boolean digBlockWith(int var1, int var2, int var3, ItemStack var4, GameProfile var5);

    default public Duration blockDigTimeWith(Vector3i position, ItemStack itemStack, GameProfile profile) {
        return this.blockDigTimeWith(Objects.requireNonNull(position, "position").x(), position.y(), position.z(), itemStack, profile);
    }

    public Duration blockDigTimeWith(int var1, int var2, int var3, ItemStack var4, GameProfile var5);
}

