/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.block.entity;

import java.util.Deque;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedDeque;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.entity.BlockEntityArchetype;
import org.spongepowered.api.block.entity.BlockEntityType;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.common.block.entity.SpongeBlockEntityArchetype;
import org.spongepowered.common.bridge.world.level.block.state.BlockStateBridge;
import org.spongepowered.common.data.persistence.NBTTranslator;
import org.spongepowered.common.util.Constants;

public final class SpongeBlockEntityArchetypeBuilder
extends AbstractDataBuilder<BlockEntityArchetype>
implements BlockEntityArchetype.Builder {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Deque<SpongeBlockEntityArchetypeBuilder> pool = new ConcurrentLinkedDeque<SpongeBlockEntityArchetypeBuilder>();
    @MonotonicNonNull BlockState blockState;
    @MonotonicNonNull BlockEntityType type;
    @Nullable DataContainer data;
    private final boolean pooled;

    public static SpongeBlockEntityArchetypeBuilder unpooled() {
        return new SpongeBlockEntityArchetypeBuilder(false);
    }

    public static SpongeBlockEntityArchetypeBuilder pooled() {
        @Nullable SpongeBlockEntityArchetypeBuilder builder = pool.pollFirst();
        if (builder != null) {
            return builder.reset();
        }
        return new SpongeBlockEntityArchetypeBuilder(true);
    }

    SpongeBlockEntityArchetypeBuilder(boolean pooled) {
        super(BlockEntityArchetype.class, 1);
        this.pooled = pooled;
    }

    @Override
    public SpongeBlockEntityArchetypeBuilder reset() {
        this.blockState = null;
        this.type = null;
        this.data = null;
        return this;
    }

    @Override
    public <V> BlockEntityArchetype.Builder add(Key<? extends Value<V>> key, V value) {
        return null;
    }

    @Override
    public BlockEntityArchetype.Builder from(BlockEntityArchetype value) {
        this.type = value.blockEntityType();
        this.blockState = value.state();
        this.data = value.blockEntityData();
        return this;
    }

    @Override
    public BlockEntityArchetype.Builder state(BlockState state) {
        net.minecraft.world.level.block.state.BlockState blockState = (net.minecraft.world.level.block.state.BlockState)state;
        if (!((BlockStateBridge)blockState).bridge$hasTileEntity()) {
            LOGGER.warn("BlockState {} does not provide BlockEntities!", (Object)state, (Object)new IllegalArgumentException());
        }
        if (this.blockState != state) {
            this.data = null;
        }
        this.blockState = state;
        return this;
    }

    @Override
    public BlockEntityArchetype.Builder blockEntity(BlockEntityType blockEntityType) {
        this.type = Objects.requireNonNull(blockEntityType, "BlockEntityType cannot be null");
        return this;
    }

    @Override
    public BlockEntityArchetype.Builder from(ServerLocation location) {
        org.spongepowered.api.block.entity.BlockEntity tileEntity = location.blockEntity().orElseThrow(() -> new IllegalArgumentException("There is no block entity available at the provided location: " + location));
        return this.blockEntity(tileEntity);
    }

    @Override
    public BlockEntityArchetype.Builder blockEntity(org.spongepowered.api.block.entity.BlockEntity blockEntity) {
        if (!(Objects.requireNonNull(blockEntity, "BlockEntity cannot be null!") instanceof BlockEntity)) {
            throw new IllegalArgumentException("BlockEntity is not compatible with this implementation!");
        }
        CompoundTag compound = new CompoundTag();
        ((BlockEntity)blockEntity).save(compound);
        compound.remove("x");
        compound.remove("y");
        compound.remove("z");
        compound.remove("id");
        this.data = NBTTranslator.INSTANCE.translate(compound);
        this.blockState = blockEntity.block();
        this.type = blockEntity.type();
        return this;
    }

    @Override
    public BlockEntityArchetype.Builder blockEntityData(DataView dataView) {
        DataContainer copy;
        this.data = copy = Objects.requireNonNull(dataView, "DataView cannot be null!").copy();
        return this;
    }

    @Override
    public SpongeBlockEntityArchetype build() {
        if (this.blockState == null) {
            throw new IllegalStateException("BlockState cannot be null!");
        }
        if (this.type == null) {
            throw new IllegalStateException("BlockEntityType cannot be null!");
        }
        if (this.data == null) {
            this.data = DataContainer.createNew();
        }
        SpongeBlockEntityArchetype archetype = new SpongeBlockEntityArchetype(this);
        if (this.pooled) {
            this.reset();
            pool.push(this);
        }
        return archetype;
    }

    @Override
    protected Optional<BlockEntityArchetype> buildContent(DataView container) throws InvalidDataException {
        SpongeBlockEntityArchetypeBuilder builder = SpongeBlockEntityArchetypeBuilder.pooled();
        if (!container.contains(Constants.Sponge.BlockEntityArchetype.BLOCK_ENTITY_TYPE, Constants.Sponge.BlockEntityArchetype.BLOCK_STATE)) {
            throw new InvalidDataException("Missing the BlockEntityType and BlockState! Cannot re-construct a BlockEntityArchetype!");
        }
        builder.blockEntity(container.getRegistryValue(Constants.Sponge.BlockEntityArchetype.BLOCK_ENTITY_TYPE, RegistryTypes.BLOCK_ENTITY_TYPE).orElseThrow(() -> new InvalidDataException("Could not deserialize a BlockEntityType!")));
        builder.state(container.getSerializable(Constants.Sponge.BlockEntityArchetype.BLOCK_STATE, BlockState.class).orElseThrow(() -> new InvalidDataException("Could not deserialize a BlockState!")));
        if (container.contains(Constants.Sponge.BlockEntityArchetype.BLOCK_ENTITY_DATA)) {
            builder.blockEntityData(container.getView(Constants.Sponge.BlockEntityArchetype.BLOCK_ENTITY_DATA).orElseThrow(() -> new InvalidDataException("No DataView found for the 'TileEntity' data tag!")));
        }
        return Optional.of(builder.build());
    }
}

