/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command.parameter.managed.standard;

import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.command.CommandCompletion;
import org.spongepowered.api.command.exception.ArgumentParseException;
import org.spongepowered.common.command.brigadier.argument.ResourceKeyedArgumentValueParser;

public final class SpongeDurationValueParameter
extends ResourceKeyedArgumentValueParser<Duration> {
    public SpongeDurationValueParameter(ResourceKey key) {
        super(key);
    }

    @Override
    public List<CommandCompletion> complete(@NonNull CommandCause context, @NonNull String currentInput) {
        return Collections.emptyList();
    }

    @Override
    public @NonNull Optional<? extends Duration> parseValue(@NonNull CommandCause cause,  @NonNull ArgumentReader.Mutable reader) throws ArgumentParseException {
        String s = reader.parseString().toUpperCase();
        if (!s.contains("T")) {
            if (s.contains("D")) {
                if (s.contains("H") || s.contains("M") || s.contains("S")) {
                    s = s.replace("D", "DT");
                }
            } else {
                s = s.startsWith("P") ? "PT" + s.substring(1) : "T" + s;
            }
        }
        if (!s.startsWith("P")) {
            s = "P" + s;
        }
        try {
            return Optional.of(Duration.parse(s));
        }
        catch (DateTimeParseException ex) {
            throw reader.createException((Component)Component.text((String)"Invalid duration!"));
        }
    }
}

