/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.effect.particle;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.DataQuery;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.effect.particle.ParticleEffect;
import org.spongepowered.api.effect.particle.ParticleOption;
import org.spongepowered.api.effect.particle.ParticleType;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.common.data.DataDeserializer;
import org.spongepowered.common.effect.particle.SpongeParticleEffect;
import org.spongepowered.common.effect.particle.SpongeParticleOption;
import org.spongepowered.common.util.Constants;

public final class SpongeParticleEffectBuilder
extends AbstractDataBuilder<ParticleEffect>
implements ParticleEffect.Builder {
    private ParticleType type;
    private Map<ParticleOption<?>, Object> options;

    public SpongeParticleEffectBuilder() {
        super(ParticleEffect.class, 1);
        this.reset();
    }

    @Override
    protected Optional<ParticleEffect> buildContent(DataView container) throws InvalidDataException {
        if (!container.contains(Constants.Particles.PARTICLE_TYPE, Constants.Particles.PARTICLE_OPTIONS)) {
            return Optional.empty();
        }
        ParticleType particleType = container.getRegistryValue(Constants.Particles.PARTICLE_TYPE, RegistryTypes.PARTICLE_TYPE, Sponge.game()).get();
        HashMap options = new HashMap();
        container.getViewList(Constants.Particles.PARTICLE_OPTIONS).get().forEach(view -> {
            ParticleOption<?> option = view.getRegistryValue(Constants.Particles.PARTICLE_OPTION_KEY, RegistryTypes.PARTICLE_OPTION, Sponge.game()).get();
            BiFunction<DataView, DataQuery, Optional<DataView>> deserializer = DataDeserializer.deserializer(option.valueType());
            Object value = deserializer.apply((DataView)view, Constants.Particles.PARTICLE_OPTION_VALUE).get();
            options.put(option, value);
        });
        return Optional.of(new SpongeParticleEffect(particleType, options));
    }

    @Override
    public ParticleEffect.Builder from(ParticleEffect particleEffect) {
        this.type = particleEffect.type();
        this.options = new HashMap(particleEffect.options());
        return this;
    }

    @Override
    public ParticleEffect.Builder type(ParticleType particleType) {
        this.type = (ParticleType)Preconditions.checkNotNull((Object)particleType, (Object)"particleType");
        return this;
    }

    @Override
    public ParticleEffect.Builder reset() {
        this.type = null;
        this.options = new HashMap();
        return this;
    }

    @Override
    public <V> ParticleEffect.Builder option(ParticleOption<V> option, V value) throws IllegalArgumentException {
        Preconditions.checkNotNull(option, (Object)"option");
        Preconditions.checkNotNull(value, (Object)"value");
        IllegalArgumentException exception = ((SpongeParticleOption)option).validateValue(value);
        if (exception != null) {
            throw exception;
        }
        if (value instanceof List) {
            value = ImmutableList.copyOf((Collection)((List)value));
        }
        this.options.put(option, value);
        return this;
    }

    @Override
    public ParticleEffect build() {
        Preconditions.checkArgument((this.type != null ? 1 : 0) != 0, (Object)"ParticleType must be set");
        return new SpongeParticleEffect(this.type, this.options);
    }
}

