/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.filter;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicInteger;
import org.spongepowered.common.event.filter.EventFilter;
import org.spongepowered.common.event.filter.FilterGenerator;
import org.spongepowered.common.event.gen.DefineableClassLoader;
import org.spongepowered.common.event.manager.ListenerClassVisitor;

public class FilterFactory {
    private final AtomicInteger id = new AtomicInteger();
    private final DefineableClassLoader classLoader;
    private final LoadingCache<ListenerClassVisitor.DiscoveredMethod, Class<? extends EventFilter>> cache = Caffeine.newBuilder().weakValues().build(this::createClass);
    private final String targetPackage;

    public FilterFactory(String targetPackage, DefineableClassLoader classLoader) {
        Preconditions.checkNotNull((Object)targetPackage, (Object)"targetPackage");
        Preconditions.checkArgument((!targetPackage.isEmpty() ? 1 : 0) != 0, (Object)"targetPackage cannot be empty");
        this.targetPackage = targetPackage + '.';
        this.classLoader = (DefineableClassLoader)Preconditions.checkNotNull((Object)classLoader, (Object)"classLoader");
    }

    public Class<? extends EventFilter> createFilter(ListenerClassVisitor.DiscoveredMethod method) throws Exception {
        Class clazz = (Class)this.cache.get((Object)method);
        return clazz == EventFilter.class ? null : clazz;
    }

    Class<? extends EventFilter> createClass(ListenerClassVisitor.DiscoveredMethod method) throws ClassNotFoundException {
        Class<?> handle = method.declaringClass();
        Class<?> eventClass = method.parameterTypes()[0].clazz();
        String name = this.targetPackage + eventClass.getSimpleName() + "Filter_" + handle.getSimpleName() + '_' + method.methodName() + this.id.incrementAndGet();
        byte[] cls = FilterGenerator.getInstance().generateClass(name, method);
        if (cls == null) {
            return EventFilter.class;
        }
        return this.classLoader.defineClass(name, cls);
    }
}

