/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.manager;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicInteger;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.spongepowered.api.event.Event;
import org.spongepowered.common.event.filter.EventFilter;
import org.spongepowered.common.event.filter.FilterFactory;
import org.spongepowered.common.event.gen.DefineableClassLoader;
import org.spongepowered.common.event.gen.LoaderClassWriter;
import org.spongepowered.common.event.manager.AnnotatedEventListener;
import org.spongepowered.common.event.manager.ListenerClassVisitor;
import org.spongepowered.common.util.generator.GeneratorUtils;

public final class ClassEventListenerFactory
implements AnnotatedEventListener.Factory {
    private final AtomicInteger id = new AtomicInteger();
    private final DefineableClassLoader classLoader;
    private final LoadingCache<ListenerClassVisitor.DiscoveredMethod, Class<? extends AnnotatedEventListener>> cache = Caffeine.newBuilder().weakValues().build(this::createClass);
    private final FilterFactory filterFactory;
    private final String targetPackage;
    private static final String BASE_HANDLER = Type.getInternalName(AnnotatedEventListener.class);
    private static final String HANDLE_METHOD_DESCRIPTOR = '(' + Type.getDescriptor(Event.class) + ")V";
    private static final String FILTER_DESCRIPTOR = "(" + Type.getDescriptor(Event.class) + ")[Ljava/lang/Object;";

    public ClassEventListenerFactory(String targetPackage, FilterFactory factory, DefineableClassLoader classLoader) {
        Preconditions.checkNotNull((Object)targetPackage, (Object)"targetPackage");
        Preconditions.checkArgument((!targetPackage.isEmpty() ? 1 : 0) != 0, (Object)"targetPackage cannot be empty");
        this.targetPackage = targetPackage + '.';
        this.filterFactory = (FilterFactory)Preconditions.checkNotNull((Object)factory, (Object)"filterFactory");
        this.classLoader = (DefineableClassLoader)Preconditions.checkNotNull((Object)classLoader, (Object)"classLoader");
    }

    @Override
    public AnnotatedEventListener create(Object handle, ListenerClassVisitor.DiscoveredMethod method) throws Exception {
        return (AnnotatedEventListener)((Class)this.cache.get((Object)method)).getConstructor(method.declaringClass()).newInstance(handle);
    }

    Class<? extends AnnotatedEventListener> createClass(ListenerClassVisitor.DiscoveredMethod method) throws Exception {
        Class<?> handle = method.declaringClass();
        Class<?> eventClass = method.parameterTypes()[0].clazz();
        String name = this.targetPackage + eventClass.getSimpleName() + "Listener_" + handle.getSimpleName() + '_' + method.methodName() + this.id.incrementAndGet();
        Class<? extends EventFilter> filter = this.filterFactory.createFilter(method);
        if (filter == null && method.parameterTypes().length != 1) {
            throw new IllegalStateException("Failed to generate EventFilter for non trivial filtering operation.");
        }
        if (filter != null) {
            filter.newInstance();
            return this.classLoader.defineClass(name, ClassEventListenerFactory.generateClass(name, handle, method, eventClass, filter));
        }
        return this.classLoader.defineClass(name, ClassEventListenerFactory.generateClass(name, handle, method, eventClass));
    }

    private static byte[] generateClass(String name, Class<?> handle, ListenerClassVisitor.DiscoveredMethod method, Class<?> eventClass, Class<? extends EventFilter> filter) {
        name = name.replace('.', '/');
        String handleName = Type.getInternalName(handle);
        String handleDescriptor = Type.getDescriptor(handle);
        String filterName = Type.getInternalName(filter);
        String eventDescriptor = method.descriptor();
        LoaderClassWriter cw = new LoaderClassWriter(handle.getClassLoader(), 3);
        cw.visit(50, 49, name, null, BASE_HANDLER, null);
        FieldVisitor fv = cw.visitField(10, "FILTER", "L" + filterName + ";", null, null);
        fv.visitEnd();
        MethodVisitor mv = cw.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitCode();
        mv.visitTypeInsn(187, filterName);
        mv.visitInsn(89);
        mv.visitMethodInsn(183, filterName, "<init>", "()V", false);
        mv.visitFieldInsn(179, name, "FILTER", "L" + filterName + ";");
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "<init>", '(' + handleDescriptor + ")V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, BASE_HANDLER, "<init>", "(Ljava/lang/Object;)V", false);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "handle", HANDLE_METHOD_DESCRIPTOR, null, new String[]{"java/lang/Exception"});
        mv.visitCode();
        mv.visitFieldInsn(178, name, "FILTER", "L" + filterName + ";");
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(185, Type.getInternalName(EventFilter.class), "filter", FILTER_DESCRIPTOR, true);
        mv.visitVarInsn(58, 2);
        mv.visitVarInsn(25, 2);
        Label l2 = new Label();
        mv.visitJumpInsn(198, l2);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, name, "handle", "Ljava/lang/Object;");
        mv.visitTypeInsn(192, handleName);
        for (int i = 0; i < method.parameterTypes().length; ++i) {
            mv.visitVarInsn(25, 2);
            mv.visitIntInsn(16, i);
            mv.visitInsn(50);
            Type paramType = method.parameterTypes()[i].type();
            GeneratorUtils.visitUnboxingMethod(mv, paramType);
        }
        mv.visitMethodInsn(182, handleName, method.methodName(), eventDescriptor, false);
        mv.visitLabel(l2);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        cw.visitEnd();
        return cw.toByteArray();
    }

    private static byte[] generateClass(String name, Class<?> handle, ListenerClassVisitor.DiscoveredMethod method, Class<?> eventClass) {
        name = name.replace('.', '/');
        String handleName = Type.getInternalName(handle);
        String handleDescriptor = Type.getDescriptor(handle);
        String eventName = Type.getInternalName(eventClass);
        LoaderClassWriter cw = new LoaderClassWriter(handle.getClassLoader(), 3);
        cw.visit(50, 49, name, null, BASE_HANDLER, null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", '(' + handleDescriptor + ")V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, BASE_HANDLER, "<init>", "(Ljava/lang/Object;)V", false);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "handle", HANDLE_METHOD_DESCRIPTOR, null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, name, "handle", "Ljava/lang/Object;");
        mv.visitTypeInsn(192, handleName);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, eventName);
        mv.visitMethodInsn(182, handleName, method.methodName(), "(L" + eventName + ";)V", false);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        cw.visitEnd();
        return cw.toByteArray();
    }
}

