/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.block;

import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.bridge.world.level.block.entity.BlockEntityBridge;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.context.transaction.GameTransaction;
import org.spongepowered.common.event.tracking.context.transaction.TransactionFlow;
import org.spongepowered.common.event.tracking.context.transaction.block.BlockEventBasedTransaction;
import org.spongepowered.common.util.PrettyPrinter;
import org.spongepowered.common.world.BlockChange;

public final class AddTileEntity
extends BlockEventBasedTransaction {
    final BlockEntity added;
    private @MonotonicNonNull SpongeBlockSnapshot oldSnapshot;
    private @MonotonicNonNull SpongeBlockSnapshot addedSnapshot;
    private final Supplier<ServerLevel> worldSupplier;
    private final Supplier<LevelChunk> chunkSupplier;

    public AddTileEntity(BlockEntity blockEntity, Supplier<ServerLevel> worldSupplier, Supplier<LevelChunk> chunkSupplier) {
        super(blockEntity.getBlockPos().immutable(), chunkSupplier.get().getBlockState(blockEntity.getBlockPos()), ((ServerWorld)worldSupplier.get()).key());
        this.added = blockEntity;
        this.worldSupplier = worldSupplier;
        this.chunkSupplier = chunkSupplier;
    }

    @Override
    protected void captureState() {
        super.captureState();
        @Nullable BlockEntity existingTile = this.chunkSupplier.get().getBlockEntity(this.affectedPosition, LevelChunk.EntityCreationType.CHECK);
        SpongeBlockSnapshot added = TrackingUtil.createPooledSnapshot(this.originalState, this.affectedPosition, BlockChangeFlags.NONE, 512, this.added, this.worldSupplier, Optional::empty, Optional::empty);
        SpongeBlockSnapshot existing = TrackingUtil.createPooledSnapshot(this.originalState, this.affectedPosition, BlockChangeFlags.NONE, 512, existingTile, this.worldSupplier, Optional::empty, Optional::empty);
        existing.blockChange = BlockChange.MODIFY;
        this.oldSnapshot = existing;
        this.addedSnapshot = added;
    }

    @Override
    public Optional<TransactionFlow.AbsorbingFlowStep> parentAbsorber() {
        return Optional.of((ctx, tx) -> tx.acceptTileAddition(this.added));
    }

    @Override
    public Optional<BiConsumer<PhaseContext<@NonNull ?>, CauseStackManager.StackFrame>> getFrameMutator(@Nullable GameTransaction<@NonNull ?> parent) {
        return Optional.empty();
    }

    @Override
    public void addToPrinter(PrettyPrinter printer) {
        printer.add("AddTileEntity").addWrapped(120, " %s : %s", this.affectedPosition, ((BlockEntityBridge)this.added).bridge$getPrettyPrinterString());
    }

    @Override
    public void restore(PhaseContext<@NonNull ?> context, ChangeBlockEvent.All event) {
        this.oldSnapshot.restore(true, BlockChangeFlags.NONE);
    }

    @Override
    protected SpongeBlockSnapshot getResultingSnapshot() {
        return this.addedSnapshot;
    }

    @Override
    protected SpongeBlockSnapshot getOriginalSnapshot() {
        return this.oldSnapshot;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", AddTileEntity.class.getSimpleName() + "[", "]").add("added=" + this.added).add("affectedPosition=" + this.affectedPosition).add("originalState=" + this.originalState).add("worldKey=" + this.worldKey).add("cancelled=" + this.cancelled).toString();
    }
}

