/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.effect;

import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.common.accessor.world.level.LevelAccessor;
import org.spongepowered.common.event.tracking.context.transaction.effect.EffectResult;
import org.spongepowered.common.event.tracking.context.transaction.effect.ProcessingSideEffect;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.BlockPipeline;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.PipelineCursor;
import org.spongepowered.common.world.SpongeBlockChangeFlag;

public final class RemoveProposedTileEntitiesDuringSetIfWorldProcessingEffect
implements ProcessingSideEffect {
    public static RemoveProposedTileEntitiesDuringSetIfWorldProcessingEffect getInstance() {
        return Holder.INSTANCE;
    }

    RemoveProposedTileEntitiesDuringSetIfWorldProcessingEffect() {
    }

    @Override
    public EffectResult processSideEffect(BlockPipeline pipeline, PipelineCursor oldState, BlockState newState, SpongeBlockChangeFlag flag, int limit) {
        ServerLevel serverWorld = pipeline.getServerWorld();
        @Nullable BlockEntity tileEntity = oldState.tileEntity;
        BlockPos pos = oldState.pos;
        if (tileEntity == null || tileEntity.isRemoved()) {
            return EffectResult.NULL_RETURN;
        }
        if (((LevelAccessor)serverWorld).accessor$updatingBlockEntities()) {
            Iterator<BlockEntity> iterator = ((LevelAccessor)serverWorld).accessor$pendingBlockEntities().iterator();
            while (iterator.hasNext()) {
                BlockEntity tileentity = iterator.next();
                if (!tileentity.getBlockPos().equals((Object)pos)) continue;
                tileentity.setRemoved();
                iterator.remove();
            }
            serverWorld.blockEntityList.add(tileEntity);
            return EffectResult.NULL_RETURN;
        }
        return EffectResult.NULL_PASS;
    }

    private static final class Holder {
        static final RemoveProposedTileEntitiesDuringSetIfWorldProcessingEffect INSTANCE = new RemoveProposedTileEntitiesDuringSetIfWorldProcessingEffect();

        private Holder() {
        }
    }
}

