/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.effect;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.common.event.tracking.context.transaction.effect.EffectResult;
import org.spongepowered.common.event.tracking.context.transaction.effect.ProcessingSideEffect;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.BlockPipeline;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.PipelineCursor;
import org.spongepowered.common.world.SpongeBlockChangeFlag;

public final class ReplaceTileEntityInWorldEffect
implements ProcessingSideEffect {
    public static ReplaceTileEntityInWorldEffect getInstance() {
        return Holder.INSTANCE;
    }

    ReplaceTileEntityInWorldEffect() {
    }

    @Override
    public EffectResult processSideEffect(BlockPipeline pipeline, PipelineCursor oldState, BlockState newState, SpongeBlockChangeFlag flag, int limit) {
        ServerLevel serverWorld = pipeline.getServerWorld();
        BlockEntity tileEntity = oldState.tileEntity;
        BlockPos pos = oldState.pos;
        if (tileEntity == null || tileEntity.isRemoved()) {
            return EffectResult.NULL_RETURN;
        }
        pipeline.getAffectedChunk().setBlockEntity(pos, tileEntity);
        serverWorld.addBlockEntity(tileEntity);
        return EffectResult.NULL_RETURN;
    }

    private static final class Holder {
        static final ReplaceTileEntityInWorldEffect INSTANCE = new ReplaceTileEntityInWorldEffect();

        private Holder() {
        }
    }
}

