/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.world;

import com.google.common.collect.ImmutableList;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.cause.entity.SpawnType;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.util.Identifiable;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.accessor.server.level.ServerLevelAccessor;
import org.spongepowered.common.bridge.CreatorTrackedBridge;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.context.transaction.GameTransaction;
import org.spongepowered.common.event.tracking.context.transaction.TransactionFlow;
import org.spongepowered.common.event.tracking.context.transaction.block.ChangeBlock;
import org.spongepowered.common.event.tracking.context.transaction.type.TransactionTypes;
import org.spongepowered.common.event.tracking.context.transaction.world.WorldBasedTransaction;
import org.spongepowered.common.util.PrettyPrinter;
import org.spongepowered.math.vector.Vector3d;

public final class SpawnEntityTransaction
extends WorldBasedTransaction<SpawnEntityEvent> {
    final Supplier<ServerLevel> worldSupplier;
    @MonotonicNonNull CompoundTag entityTag;
    public final Entity entityToSpawn;
    final Vector3d originalPosition;
    final Supplier<SpawnType> deducedSpawnType;

    public SpawnEntityTransaction(Supplier<ServerLevel> worldSupplier, Entity entityToSpawn, Supplier<SpawnType> deducedSpawnType) {
        super(TransactionTypes.SPAWN_ENTITY.get(), ((ServerWorld)worldSupplier.get()).key());
        this.worldSupplier = worldSupplier;
        this.entityToSpawn = entityToSpawn;
        this.originalPosition = new Vector3d(entityToSpawn.getX(), entityToSpawn.getY(), entityToSpawn.getZ());
        this.deducedSpawnType = deducedSpawnType;
    }

    @Override
    protected void captureState() {
        super.captureState();
        this.entityTag = this.entityToSpawn.saveWithoutId(new CompoundTag());
    }

    @Override
    public Optional<BiConsumer<PhaseContext<@NonNull ?>, CauseStackManager.StackFrame>> getFrameMutator(@Nullable GameTransaction<@NonNull ?> parent) {
        return Optional.of((context, frame) -> {
            if (parent instanceof ChangeBlock) {
                frame.pushCause(((ChangeBlock)parent).original);
                frame.addContext(EventContextKeys.BLOCK_TARGET, ((ChangeBlock)parent).original);
            }
            frame.addContext(EventContextKeys.SPAWN_TYPE, this.deducedSpawnType);
        });
    }

    @Override
    public void addToPrinter(PrettyPrinter printer) {
    }

    @Override
    protected boolean shouldBuildEventAndRestartBatch(GameTransaction<@NonNull ?> pointer, PhaseContext<@NonNull ?> context) {
        return super.shouldBuildEventAndRestartBatch(pointer, context) || this.deducedSpawnType != ((SpawnEntityTransaction)pointer).deducedSpawnType;
    }

    @Override
    public Optional<TransactionFlow.AbsorbingFlowStep> parentAbsorber() {
        return Optional.of((ctx, tx) -> tx.absorbSpawnEntity(ctx, this));
    }

    @Override
    public Optional<SpawnEntityEvent> generateEvent(PhaseContext<@NonNull ?> context, @Nullable GameTransaction<@NonNull ?> parent, ImmutableList<GameTransaction<SpawnEntityEvent>> gameTransactions, Cause currentCause) {
        ImmutableList collect = (ImmutableList)gameTransactions.stream().map(transaction -> (SpawnEntityTransaction)transaction).map(spawnRequest -> new Tuple<Entity, DummySnapshot>(spawnRequest.entityToSpawn, new DummySnapshot(spawnRequest.originalPosition, spawnRequest.entityTag, spawnRequest.worldSupplier))).collect(ImmutableList.toImmutableList());
        return Optional.of(context.createSpawnEvent(parent, (ImmutableList<Tuple<Entity, DummySnapshot>>)collect, currentCause));
    }

    @Override
    public void restore(PhaseContext<@NonNull ?> context, SpawnEntityEvent event) {
        ServerLevel serverWorld = this.worldSupplier.get();
        if (((ServerLevelAccessor)serverWorld).accessor$tickingEntities()) {
            ((ServerLevelAccessor)serverWorld).accessor$toAddAfterTick().remove(this.entityToSpawn);
            ((ServerLevelAccessor)serverWorld).invoker$removeFromChunk(this.entityToSpawn);
        } else {
            serverWorld.despawn(this.entityToSpawn);
        }
    }

    @Override
    public boolean markCancelledTransactions(SpawnEntityEvent event, ImmutableList<? extends GameTransaction<SpawnEntityEvent>> gameTransactions) {
        boolean cancelledAny = false;
        for (GameTransaction gameTransaction : gameTransactions) {
            if (event.entities().contains(((SpawnEntityTransaction)gameTransaction).entityToSpawn)) continue;
            gameTransaction.markCancelled();
            cancelledAny = true;
        }
        return cancelledAny;
    }

    @Override
    public void postProcessEvent(PhaseContext<@NonNull ?> context, SpawnEntityEvent event) {
        Stream.of(context.getNotifier(), context.getCreator(), context.getSource(ServerPlayer.class).map(Identifiable::uniqueId)).filter(Optional::isPresent).map(Optional::get).findFirst().ifPresent(creator -> event.entities().forEach(entity -> ((CreatorTrackedBridge)((Object)entity)).tracker$setTrackedUUID(PlayerTracker.Type.CREATOR, (UUID)creator)));
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", SpawnEntityTransaction.class.getSimpleName() + "[", "]").add("worldKey=" + this.worldKey).add("entityToSpawn=" + this.entityToSpawn).add("originalPosition=" + this.originalPosition).toString();
    }

    public static final class DummySnapshot {
        final Vector3d originalPosition;
        final CompoundTag entityTag;
        final Supplier<ServerLevel> worldSupplier;

        public DummySnapshot(Vector3d originalPosition, CompoundTag entityTag, Supplier<ServerLevel> worldSupplier) {
            this.originalPosition = originalPosition;
            this.entityTag = entityTag;
            this.worldSupplier = worldSupplier;
        }
    }
}

