/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundChatPacket;
import net.minecraft.network.protocol.game.ServerboundClientCommandPacket;
import net.minecraft.network.protocol.game.ServerboundCommandSuggestionPacket;
import net.minecraft.network.protocol.game.ServerboundContainerAckPacket;
import net.minecraft.network.protocol.game.ServerboundContainerButtonClickPacket;
import net.minecraft.network.protocol.game.ServerboundContainerClickPacket;
import net.minecraft.network.protocol.game.ServerboundContainerClosePacket;
import net.minecraft.network.protocol.game.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.game.ServerboundInteractPacket;
import net.minecraft.network.protocol.game.ServerboundKeepAlivePacket;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.minecraft.network.protocol.game.ServerboundPlaceRecipePacket;
import net.minecraft.network.protocol.game.ServerboundPlayerAbilitiesPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerCommandPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerInputPacket;
import net.minecraft.network.protocol.game.ServerboundResourcePackPacket;
import net.minecraft.network.protocol.game.ServerboundSetCarriedItemPacket;
import net.minecraft.network.protocol.game.ServerboundSetCreativeModeSlotPacket;
import net.minecraft.network.protocol.game.ServerboundSignUpdatePacket;
import net.minecraft.network.protocol.game.ServerboundSwingPacket;
import net.minecraft.network.protocol.game.ServerboundTeleportToEntityPacket;
import net.minecraft.network.protocol.game.ServerboundUseItemOnPacket;
import net.minecraft.network.protocol.game.ServerboundUseItemPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketContext;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketState;
import org.spongepowered.common.event.tracking.phase.packet.PacketContext;
import org.spongepowered.common.event.tracking.phase.packet.PacketState;
import org.spongepowered.common.event.tracking.phase.packet.drag.DragInventoryAddSlotState;
import org.spongepowered.common.event.tracking.phase.packet.drag.DragInventoryStartState;
import org.spongepowered.common.event.tracking.phase.packet.drag.MiddleDragInventoryStopState;
import org.spongepowered.common.event.tracking.phase.packet.drag.PrimaryDragInventoryStopState;
import org.spongepowered.common.event.tracking.phase.packet.drag.SecondaryDragInventoryStopState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.BasicInventoryPacketState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.CloseWindowState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.CreativeInventoryPacketState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.DoubleClickInventoryState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.DropInventoryState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.DropItemInsideWindowState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.DropItemOutsideWindowState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.DropItemWithHotkeyState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.EnchantItemPacketState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.MiddleInventoryClickState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.OpenInventoryState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.PlaceRecipePacketState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.PrimaryInventoryClickState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.PrimaryInventoryShiftClick;
import org.spongepowered.common.event.tracking.phase.packet.inventory.SecondaryInventoryClickState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.SecondaryInventoryShiftClickState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.SetCarriedItemState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.SwapHandItemsState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.SwitchHotbarNumberPressState;
import org.spongepowered.common.event.tracking.phase.packet.player.AnimationPacketState;
import org.spongepowered.common.event.tracking.phase.packet.player.AttackEntityPacketState;
import org.spongepowered.common.event.tracking.phase.packet.player.IgnoredPacketState;
import org.spongepowered.common.event.tracking.phase.packet.player.InteractAtEntityPacketState;
import org.spongepowered.common.event.tracking.phase.packet.player.InteractEntityPacketState;
import org.spongepowered.common.event.tracking.phase.packet.player.InteractionPacketContext;
import org.spongepowered.common.event.tracking.phase.packet.player.InteractionPacketState;
import org.spongepowered.common.event.tracking.phase.packet.player.InvalidPacketState;
import org.spongepowered.common.event.tracking.phase.packet.player.MovementPacketState;
import org.spongepowered.common.event.tracking.phase.packet.player.PacketCommandState;
import org.spongepowered.common.event.tracking.phase.packet.player.PlaceBlockPacketState;
import org.spongepowered.common.event.tracking.phase.packet.player.PlayerCommandPhaseContext;
import org.spongepowered.common.event.tracking.phase.packet.player.ResourcePackState;
import org.spongepowered.common.event.tracking.phase.packet.player.StopSleepingPacketState;
import org.spongepowered.common.event.tracking.phase.packet.player.UnknownPacketState;
import org.spongepowered.common.event.tracking.phase.packet.player.UseItemPacketState;
import org.spongepowered.common.util.Constants;

public final class PacketPhase {
    private final Map<Class<? extends Packet<?>>, Function<Packet<?>, IPhaseState<? extends PacketContext<?>>>> packetTranslationMap = new IdentityHashMap();
    private static final ImmutableMap<ServerboundPlayerCommandPacket.Action, IPhaseState<? extends PacketContext<?>>> PLAYER_ACTION_MAPPINGS = ImmutableMap.builder().put((Object)ServerboundPlayerCommandPacket.Action.PRESS_SHIFT_KEY, General.PRESS_SHIFT_KEY).put((Object)ServerboundPlayerCommandPacket.Action.RELEASE_SHIFT_KEY, General.RELEASE_SHIFT_KEY).put((Object)ServerboundPlayerCommandPacket.Action.STOP_SLEEPING, General.STOP_SLEEPING).put((Object)ServerboundPlayerCommandPacket.Action.START_SPRINTING, General.START_SPRINTING).put((Object)ServerboundPlayerCommandPacket.Action.STOP_SPRINTING, General.STOP_SPRINTING).put((Object)ServerboundPlayerCommandPacket.Action.START_RIDING_JUMP, General.START_RIDING_JUMP).put((Object)ServerboundPlayerCommandPacket.Action.STOP_RIDING_JUMP, General.STOP_RIDING_JUMP).put((Object)ServerboundPlayerCommandPacket.Action.OPEN_INVENTORY, (Object)Inventory.OPEN_INVENTORY).put((Object)ServerboundPlayerCommandPacket.Action.START_FALL_FLYING, General.START_FALL_FLYING).build();
    private static final ImmutableMap<ServerboundPlayerActionPacket.Action, IPhaseState<? extends PacketContext<?>>> INTERACTION_ACTION_MAPPINGS = ImmutableMap.builder().put((Object)ServerboundPlayerActionPacket.Action.DROP_ITEM, (Object)Inventory.DROP_ITEM_WITH_HOTKEY).put((Object)ServerboundPlayerActionPacket.Action.DROP_ALL_ITEMS, (Object)Inventory.DROP_ITEM_WITH_HOTKEY).put((Object)ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK, General.INTERACTION).put((Object)ServerboundPlayerActionPacket.Action.ABORT_DESTROY_BLOCK, General.INTERACTION).put((Object)ServerboundPlayerActionPacket.Action.STOP_DESTROY_BLOCK, General.INTERACTION).put((Object)ServerboundPlayerActionPacket.Action.RELEASE_USE_ITEM, General.INTERACTION).put((Object)ServerboundPlayerActionPacket.Action.SWAP_ITEM_WITH_OFFHAND, (Object)Inventory.SWAP_HAND_ITEMS).build();

    boolean isPacketInvalid(Packet<?> packetIn, ServerPlayer packetPlayer, IPhaseState<? extends PacketContext<?>> packetState) {
        return ((PacketState)packetState).isPacketIgnored(packetIn, packetPlayer);
    }

    IPhaseState<? extends PacketContext<?>> getStateForPacket(Packet<?> packet) {
        Function<Packet<?>, IPhaseState<PacketContext<?>>> packetStateFunction = this.packetTranslationMap.get(packet.getClass());
        if (packetStateFunction != null) {
            return packetStateFunction.apply(packet);
        }
        return General.UNKNOWN;
    }

    public PhaseContext<?> populateContext(Packet<?> packet, ServerPlayer entityPlayerMP, IPhaseState<?> state, PhaseContext<?> context) {
        Preconditions.checkNotNull(packet, (Object)"Packet cannot be null!");
        Preconditions.checkArgument((!context.isComplete() ? 1 : 0) != 0, (Object)"PhaseContext cannot be marked as completed!");
        ((PacketState)state).populateContext(entityPlayerMP, packet, (PacketContext)context);
        return context;
    }

    private static BasicInventoryPacketState fromWindowPacket(ServerboundContainerClickPacket windowPacket) {
        int mode = 512 << windowPacket.getClickType().ordinal();
        int packed = windowPacket.getButtonNum();
        int unpacked = mode == Constants.Networking.MODE_DRAG ? 64 << (packed >> 2 & 3) | 8 << (packed & 3) : 1 << (packed & 3);
        BasicInventoryPacketState inventory = PacketPhase.fromState(PacketPhase.clickType(windowPacket.getSlotNum()) | mode | unpacked);
        if (inventory == Inventory.INVENTORY) {
            SpongeCommon.logger().warn(String.format("Unable to find InventoryPacketState handler for click window packet: %s", windowPacket));
        }
        return inventory;
    }

    private static int clickType(int slotId) {
        return slotId == -999 || slotId == -1 ? 131072 : 65536;
    }

    private static BasicInventoryPacketState fromState(int state) {
        for (BasicInventoryPacketState inventory : Inventory.VALUES) {
            if (!inventory.matches(state)) continue;
            return inventory;
        }
        return Inventory.INVENTORY;
    }

    public static PacketPhase getInstance() {
        return Holder.INSTANCE;
    }

    PacketPhase() {
        this.setupPacketToStateMapping();
    }

    private void setupPacketToStateMapping() {
        this.packetTranslationMap.put(ServerboundKeepAlivePacket.class, packet -> General.IGNORED);
        this.packetTranslationMap.put(ServerboundChatPacket.class, packet -> General.CHAT_COMMAND);
        this.packetTranslationMap.put(ServerboundInteractPacket.class, packet -> {
            ServerboundInteractPacket useEntityPacket = (ServerboundInteractPacket)packet;
            ServerboundInteractPacket.Action action = useEntityPacket.getAction();
            if (action == ServerboundInteractPacket.Action.INTERACT) {
                return General.INTERACT_ENTITY;
            }
            if (action == ServerboundInteractPacket.Action.ATTACK) {
                return General.ATTACK_ENTITY;
            }
            if (action == ServerboundInteractPacket.Action.INTERACT_AT) {
                return General.INTERACT_AT_ENTITY;
            }
            return General.INVALID;
        });
        this.packetTranslationMap.put(ServerboundMovePlayerPacket.class, packet -> General.MOVEMENT);
        this.packetTranslationMap.put(ServerboundMovePlayerPacket.Pos.class, packet -> General.MOVEMENT);
        this.packetTranslationMap.put(ServerboundMovePlayerPacket.Rot.class, packet -> General.MOVEMENT);
        this.packetTranslationMap.put(ServerboundMovePlayerPacket.PosRot.class, packet -> General.MOVEMENT);
        this.packetTranslationMap.put(ServerboundPlayerActionPacket.class, packet -> {
            ServerboundPlayerActionPacket playerDigging = (ServerboundPlayerActionPacket)packet;
            ServerboundPlayerActionPacket.Action action = playerDigging.getAction();
            IPhaseState state = (IPhaseState)INTERACTION_ACTION_MAPPINGS.get((Object)action);
            return state == null ? General.UNKNOWN : state;
        });
        this.packetTranslationMap.put(ServerboundUseItemOnPacket.class, packet -> {
            ServerboundUseItemOnPacket blockPlace = (ServerboundUseItemOnPacket)packet;
            BlockPos blockPos = blockPlace.getHitResult().getBlockPos();
            Direction front = blockPlace.getHitResult().getDirection();
            MinecraftServer server = SpongeCommon.server();
            if (blockPos.getY() < server.getMaxBuildHeight() - 1 || front != Direction.UP && blockPos.getY() < server.getMaxBuildHeight()) {
                return General.PLACE_BLOCK;
            }
            return General.INVALID;
        });
        this.packetTranslationMap.put(ServerboundUseItemPacket.class, packet -> General.USE_ITEM);
        this.packetTranslationMap.put(ServerboundSetCarriedItemPacket.class, packet -> Inventory.SET_CARRIED_ITEM);
        this.packetTranslationMap.put(ServerboundSwingPacket.class, packet -> General.ANIMATION);
        this.packetTranslationMap.put(ServerboundPlayerCommandPacket.class, packet -> {
            ServerboundPlayerCommandPacket playerAction = (ServerboundPlayerCommandPacket)packet;
            ServerboundPlayerCommandPacket.Action action = playerAction.getAction();
            return (IPhaseState)PLAYER_ACTION_MAPPINGS.get((Object)action);
        });
        this.packetTranslationMap.put(ServerboundPlayerInputPacket.class, packet -> General.HANDLED_EXTERNALLY);
        this.packetTranslationMap.put(ServerboundContainerClosePacket.class, packet -> General.CLOSE_WINDOW);
        this.packetTranslationMap.put(ServerboundContainerClickPacket.class, packet -> PacketPhase.fromWindowPacket((ServerboundContainerClickPacket)packet));
        this.packetTranslationMap.put(ServerboundContainerAckPacket.class, packet -> General.UNKNOWN);
        this.packetTranslationMap.put(ServerboundSetCreativeModeSlotPacket.class, packet -> General.CREATIVE_INVENTORY);
        this.packetTranslationMap.put(ServerboundContainerButtonClickPacket.class, packet -> Inventory.ENCHANT_ITEM);
        this.packetTranslationMap.put(ServerboundSignUpdatePacket.class, packet -> General.UPDATE_SIGN);
        this.packetTranslationMap.put(ServerboundPlayerAbilitiesPacket.class, packet -> General.IGNORED);
        this.packetTranslationMap.put(ServerboundCommandSuggestionPacket.class, packet -> General.TAB_COMPLETE);
        this.packetTranslationMap.put(ServerboundClientCommandPacket.class, packet -> {
            ServerboundClientCommandPacket clientStatus = (ServerboundClientCommandPacket)packet;
            ServerboundClientCommandPacket.Action status = clientStatus.getAction();
            if (status == ServerboundClientCommandPacket.Action.PERFORM_RESPAWN) {
                return General.REQUEST_RESPAWN;
            }
            return General.IGNORED;
        });
        this.packetTranslationMap.put(ServerboundCustomPayloadPacket.class, packet -> General.HANDLED_EXTERNALLY);
        this.packetTranslationMap.put(ServerboundTeleportToEntityPacket.class, packet -> General.IGNORED);
        this.packetTranslationMap.put(ServerboundResourcePackPacket.class, packet -> General.RESOURCE_PACK);
        this.packetTranslationMap.put(ServerboundPlaceRecipePacket.class, packet -> Inventory.PLACE_RECIPE);
    }

    private static final class Holder {
        static final PacketPhase INSTANCE = new PacketPhase();

        private Holder() {
        }
    }

    public static final class Inventory {
        static final BasicInventoryPacketState INVENTORY = new BasicInventoryPacketState();
        static final BasicInventoryPacketState PRIMARY_INVENTORY_CLICK = new PrimaryInventoryClickState();
        static final BasicInventoryPacketState SECONDARY_INVENTORY_CLICK = new SecondaryInventoryClickState();
        static final BasicInventoryPacketState MIDDLE_INVENTORY_CLICK = new MiddleInventoryClickState();
        static final BasicInventoryPacketState DROP_ITEM_OUTSIDE_WINDOW = new DropItemOutsideWindowState(Constants.Networking.MODE_CLICK | 1 | 2 | 0x20000);
        static final BasicInventoryPacketState DROP_ITEM_INSIDE_WINDOW = new DropItemInsideWindowState();
        static final BasicInventoryPacketState DROP_ITEM_WITH_HOTKEY = new DropItemWithHotkeyState();
        static final BasicInventoryPacketState DROP_ITEM_OUTSIDE_WINDOW_NOOP = new DropItemOutsideWindowState(Constants.Networking.MODE_DROP | 1 | 2 | 0x20000);
        static final BasicInventoryPacketState DROP_ITEMS = new BasicInventoryPacketState();
        static final BasicInventoryPacketState DROP_INVENTORY = new DropInventoryState();
        static final BasicInventoryPacketState SWITCH_HOTBAR_NUMBER_PRESS = new SwitchHotbarNumberPressState();
        static final BasicInventoryPacketState PRIMARY_INVENTORY_SHIFT_CLICK = new PrimaryInventoryShiftClick();
        static final BasicInventoryPacketState SECONDARY_INVENTORY_SHIFT_CLICK = new SecondaryInventoryShiftClickState();
        static final BasicInventoryPacketState DOUBLE_CLICK_INVENTORY = new DoubleClickInventoryState();
        static final BasicInventoryPacketState PRIMARY_DRAG_INVENTORY_START = new DragInventoryStartState("PRIMARY_DRAG_INVENTORY_START", 64);
        static final BasicInventoryPacketState SECONDARY_DRAG_INVENTORY_START = new DragInventoryStartState("SECONDARY_DRAG_INVENTORY_START", 128);
        static final BasicInventoryPacketState MIDDLE_DRAG_INVENTORY_START = new DragInventoryStartState("MIDDLE_DRAG_INVENTORY_START", 256);
        static final BasicInventoryPacketState PRIMARY_DRAG_INVENTORY_ADDSLOT = new DragInventoryAddSlotState("PRIMARY_DRAG_INVENTORY_ADD_SLOT", 64);
        static final BasicInventoryPacketState SECONDARY_DRAG_INVENTORY_ADDSLOT = new DragInventoryAddSlotState("SECONDARY_DRAG_INVENTORY_ADD_SLOT", 128);
        static final BasicInventoryPacketState MIDDLE_DRAG_INVENTORY_ADDSLOT = new DragInventoryAddSlotState("MIDDLE_DRAG_INVENTORY_ADD_SLOT", 256);
        static final BasicInventoryPacketState PRIMARY_DRAG_INVENTORY_STOP = new PrimaryDragInventoryStopState();
        static final BasicInventoryPacketState SECONDARY_DRAG_INVENTORY_STOP = new SecondaryDragInventoryStopState();
        static final BasicInventoryPacketState MIDDLE_DRAG_INVENTORY_STOP = new MiddleDragInventoryStopState();
        static final BasicInventoryPacketState SET_CARRIED_ITEM = new SetCarriedItemState();
        static final BasicInventoryPacketState OPEN_INVENTORY = new OpenInventoryState();
        static final BasicInventoryPacketState ENCHANT_ITEM = new EnchantItemPacketState();
        static final BasicInventoryPacketState SWAP_HAND_ITEMS = new SwapHandItemsState();
        static final BasicInventoryPacketState PLACE_RECIPE = new PlaceRecipePacketState();
        static final ImmutableList<BasicInventoryPacketState> VALUES = ImmutableList.builder().add((Object)INVENTORY).add((Object)PRIMARY_INVENTORY_CLICK).add((Object)SECONDARY_INVENTORY_CLICK).add((Object)MIDDLE_INVENTORY_CLICK).add((Object)DROP_ITEM_OUTSIDE_WINDOW).add((Object)DROP_ITEM_INSIDE_WINDOW).add((Object)DROP_ITEM_OUTSIDE_WINDOW_NOOP).add((Object)DROP_ITEMS).add((Object)DROP_INVENTORY).add((Object)SWITCH_HOTBAR_NUMBER_PRESS).add((Object)PRIMARY_INVENTORY_SHIFT_CLICK).add((Object)SECONDARY_INVENTORY_SHIFT_CLICK).add((Object)DOUBLE_CLICK_INVENTORY).add((Object)PRIMARY_DRAG_INVENTORY_START).add((Object)SECONDARY_DRAG_INVENTORY_START).add((Object)MIDDLE_DRAG_INVENTORY_START).add((Object)PRIMARY_DRAG_INVENTORY_ADDSLOT).add((Object)SECONDARY_DRAG_INVENTORY_ADDSLOT).add((Object)MIDDLE_DRAG_INVENTORY_ADDSLOT).add((Object)PRIMARY_DRAG_INVENTORY_STOP).add((Object)SECONDARY_DRAG_INVENTORY_STOP).add((Object)MIDDLE_DRAG_INVENTORY_STOP).add((Object)SET_CARRIED_ITEM).add((Object)OPEN_INVENTORY).add((Object)ENCHANT_ITEM).build();
    }

    public static final class General {
        public static final IPhaseState<BasicPacketContext> UNKNOWN = new UnknownPacketState();
        static final IPhaseState<BasicPacketContext> MOVEMENT = new MovementPacketState();
        static final IPhaseState<InteractionPacketContext> INTERACTION = new InteractionPacketState();
        static final IPhaseState<BasicPacketContext> IGNORED = new IgnoredPacketState();
        static final IPhaseState<BasicPacketContext> INTERACT_ENTITY = new InteractEntityPacketState();
        static final IPhaseState<BasicPacketContext> ATTACK_ENTITY = new AttackEntityPacketState();
        static final IPhaseState<BasicPacketContext> INTERACT_AT_ENTITY = new InteractAtEntityPacketState();
        static final IPhaseState<BasicPacketContext> CREATIVE_INVENTORY = new CreativeInventoryPacketState();
        static final IPhaseState<BasicPacketContext> PLACE_BLOCK = new PlaceBlockPacketState();
        static final IPhaseState<BasicPacketContext> REQUEST_RESPAWN = new BasicPacketState();
        static final IPhaseState<BasicPacketContext> USE_ITEM = new UseItemPacketState();
        static final IPhaseState<BasicPacketContext> INVALID = new InvalidPacketState();
        static final IPhaseState<BasicPacketContext> START_RIDING_JUMP = new BasicPacketState();
        static final IPhaseState<BasicPacketContext> ANIMATION = new AnimationPacketState();
        static final IPhaseState<BasicPacketContext> PRESS_SHIFT_KEY = new BasicPacketState();
        static final IPhaseState<BasicPacketContext> RELEASE_SHIFT_KEY = new BasicPacketState();
        static final IPhaseState<BasicPacketContext> START_SPRINTING = new BasicPacketState();
        static final IPhaseState<BasicPacketContext> STOP_SPRINTING = new BasicPacketState();
        static final IPhaseState<BasicPacketContext> STOP_SLEEPING = new StopSleepingPacketState();
        static final IPhaseState<BasicPacketContext> TAB_COMPLETE = new BasicPacketState();
        public static final IPhaseState<BasicPacketContext> CLOSE_WINDOW = new CloseWindowState();
        public static final IPhaseState<BasicPacketContext> UPDATE_SIGN = new BasicPacketState();
        static final IPhaseState<BasicPacketContext> RESOURCE_PACK = new ResourcePackState();
        static final IPhaseState<BasicPacketContext> STOP_RIDING_JUMP = new BasicPacketState();
        static final IPhaseState<BasicPacketContext> HANDLED_EXTERNALLY = new UnknownPacketState();
        static final IPhaseState<BasicPacketContext> START_FALL_FLYING = new BasicPacketState();
        static final IPhaseState<PlayerCommandPhaseContext> CHAT_COMMAND = new PacketCommandState();
    }
}

