/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory.custom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.ItemStack;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.entity.PlayerInventory;
import org.spongepowered.api.item.inventory.menu.ClickTypes;
import org.spongepowered.api.item.inventory.menu.InventoryMenu;
import org.spongepowered.api.item.inventory.menu.handler.ClickHandler;
import org.spongepowered.api.item.inventory.menu.handler.CloseHandler;
import org.spongepowered.api.item.inventory.menu.handler.InventoryCallbackHandler;
import org.spongepowered.api.item.inventory.menu.handler.KeySwapHandler;
import org.spongepowered.api.item.inventory.menu.handler.SlotChangeHandler;
import org.spongepowered.api.item.inventory.menu.handler.SlotClickHandler;
import org.spongepowered.api.item.inventory.type.ViewableInventory;
import org.spongepowered.common.accessor.world.inventory.AbstractContainerMenuAccessor;
import org.spongepowered.common.bridge.world.inventory.container.MenuBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.inventory.custom.ViewableCustomInventory;
import org.spongepowered.common.item.util.ItemStackUtil;

public class SpongeInventoryMenu
implements InventoryMenu {
    private ViewableInventory inventory;
    private Map<Container, ServerPlayer> tracked = new HashMap<Container, ServerPlayer>();
    private Component title;
    private @Nullable SlotClickHandler slotClickHandler;
    private @Nullable ClickHandler clickHandler;
    private @Nullable KeySwapHandler keySwapHandler;
    private @Nullable SlotChangeHandler changeHandler;
    private @Nullable CloseHandler closeHandler;
    private boolean readonly;

    public SpongeInventoryMenu(ViewableInventory inventory) {
        this.inventory = inventory;
    }

    @Override
    public ViewableInventory inventory() {
        return this.inventory;
    }

    @Override
    public void setCurrentInventory(ViewableInventory inventory) {
        if (inventory.getClass().equals(this.inventory.getClass()) && inventory instanceof ViewableCustomInventory && inventory.capacity() == this.inventory.capacity()) {
            this.inventory = inventory;
            for (Map.Entry<Container, ServerPlayer> entry : this.tracked.entrySet()) {
                AbstractContainerMenu container = (AbstractContainerMenu)entry.getKey();
                ServerPlayer player = entry.getValue();
                AbstractContainerMenu newContainer = ((ViewableCustomInventory)((Object)inventory)).createMenu(-1, ((Player)player).inventory, (Player)player);
                for (int i = 0; i < inventory.capacity(); ++i) {
                    net.minecraft.world.inventory.Slot slot = (net.minecraft.world.inventory.Slot)newContainer.slots.get(i);
                    container.slots.set(i, slot);
                    ((AbstractContainerMenuAccessor)container).accessor$lastSlots().set(i, (Object)slot.getItem());
                }
                for (ContainerListener listener : ((AbstractContainerMenuAccessor)container).accessor$containerListeners()) {
                    listener.refreshContainer(container, ((AbstractContainerMenuAccessor)container).accessor$lastSlots());
                }
            }
        } else {
            this.inventory = inventory;
            this.reopen();
        }
    }

    private void reopen() {
        new ArrayList<ServerPlayer>(this.tracked.values()).stream().distinct().forEach(this::open);
    }

    @Override
    public void setTitle(Component title) {
        this.title = title;
        this.reopen();
    }

    @Override
    public Optional<Component> title() {
        return Optional.ofNullable(this.title);
    }

    @Override
    public InventoryMenu setReadOnly(boolean readOnly) {
        this.readonly = readOnly;
        return this;
    }

    @Override
    public void registerHandler(InventoryCallbackHandler handler) {
        if (handler instanceof ClickHandler) {
            this.registerClick((ClickHandler)handler);
        }
        if (handler instanceof SlotClickHandler) {
            this.registerSlotClick((SlotClickHandler)handler);
        }
        if (handler instanceof KeySwapHandler) {
            this.registerKeySwap((KeySwapHandler)handler);
        }
        if (handler instanceof CloseHandler) {
            this.registerClose((CloseHandler)handler);
        }
        if (handler instanceof SlotChangeHandler) {
            this.registerChange((SlotChangeHandler)handler);
        }
    }

    public boolean isReadOnly() {
        return this.readonly;
    }

    @Override
    public void registerClose(CloseHandler handler) {
        this.closeHandler = handler;
    }

    @Override
    public void registerClick(ClickHandler handler) {
        this.clickHandler = handler;
    }

    @Override
    public void registerSlotClick(SlotClickHandler handler) {
        this.slotClickHandler = handler;
    }

    @Override
    public void registerKeySwap(KeySwapHandler handler) {
        this.keySwapHandler = handler;
    }

    @Override
    public void registerChange(SlotChangeHandler handler) {
        this.changeHandler = handler;
    }

    @Override
    public void unregisterAll() {
        this.clickHandler = null;
        this.slotClickHandler = null;
        this.keySwapHandler = null;
        this.changeHandler = null;
        this.closeHandler = null;
    }

    @Override
    public Optional<Container> open(ServerPlayer player) {
        Optional<Container> container = player.openInventory(this.inventory, this.title);
        container.ifPresent(c -> {
            ((MenuBridge)((Object)c)).bridge$setMenu(this);
            this.tracked.put((Container)c, player);
        });
        return container;
    }

    public void onClose(Player player, Container container) {
        if (this.closeHandler != null) {
            try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
                frame.pushCause(player);
                Cause cause = frame.currentCause();
                this.closeHandler.handle(cause, container);
            }
        }
        this.tracked.remove(container);
    }

    public boolean onClick(int slotId, int dragType, ClickType clickTypeIn, Player player, Container container) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(player);
            Cause cause = frame.currentCause();
            if (clickTypeIn == ClickType.QUICK_CRAFT) {
                boolean bl = this.onClickDrag(cause, slotId, dragType, container);
                return bl;
            }
            Optional<Slot> slot = container.slot(slotId);
            if (slot.isPresent()) {
                switch (clickTypeIn) {
                    case SWAP: {
                        if (dragType < 0 || dragType >= 9) break;
                        Optional<Slot> slot2 = container.slot(dragType);
                        if (slot2.isPresent() && this.keySwapHandler != null) {
                            boolean bl = this.keySwapHandler.handle(cause, container, slot.get(), slotId, ClickTypes.KEY_SWAP.get(), slot2.get());
                            return bl;
                        }
                        break;
                    }
                    case CLONE: {
                        if (this.slotClickHandler == null) break;
                        boolean bl = this.slotClickHandler.handle(cause, container, slot.get(), slotId, ClickTypes.CLICK_MIDDLE.get());
                        return bl;
                    }
                    case PICKUP_ALL: {
                        if (this.slotClickHandler == null) break;
                        boolean bl = this.slotClickHandler.handle(cause, container, slot.get(), slotId, ClickTypes.DOUBLE_CLICK.get());
                        return bl;
                    }
                    default: {
                        if (this.slotClickHandler == null) break;
                        if (dragType == 0) {
                            boolean bl = this.onClickLeft(cause, this.slotClickHandler, clickTypeIn, container, slotId, slot.get());
                            return bl;
                        }
                        if (dragType != 1) break;
                        boolean bl = this.onClickRight(cause, this.slotClickHandler, clickTypeIn, container, slotId, slot.get());
                        return bl;
                    }
                }
                boolean bl = true;
                return bl;
            }
            switch (clickTypeIn) {
                case PICKUP: {
                    if (slotId != -999 || this.clickHandler == null) break;
                    if (dragType == 0) {
                        boolean bl = this.clickHandler.handle(cause, container, ClickTypes.CLICK_LEFT_OUTSIDE.get());
                        return bl;
                    }
                    if (dragType != 1) break;
                    boolean bl = this.clickHandler.handle(cause, container, ClickTypes.CLICK_RIGHT_OUTSIDE.get());
                    return bl;
                }
                case THROW: {
                    if (slotId != -999) break;
                }
            }
            boolean bl = true;
            return bl;
        }
    }

    private boolean onClickDrag(Cause cause, int slotId, int dragType, Container container) {
        int dragMode = dragType >> 2 & 3;
        int dragEvent = dragType & 3;
        switch (dragEvent) {
            case 0: {
                if (this.clickHandler == null) break;
                return this.clickHandler.handle(cause, container, ClickTypes.DRAG_START.get());
            }
            case 1: {
                Optional<Slot> slot = container.slot(slotId);
                if (!slot.isPresent() || this.slotClickHandler == null) break;
                switch (dragMode) {
                    case 0: {
                        return this.slotClickHandler.handle(cause, container, slot.get(), slotId, ClickTypes.DRAG_LEFT_ADD.get());
                    }
                    case 1: {
                        return this.slotClickHandler.handle(cause, container, slot.get(), slotId, ClickTypes.DRAG_RIGHT_ADD.get());
                    }
                    case 2: {
                        return this.slotClickHandler.handle(cause, container, slot.get(), slotId, ClickTypes.DRAG_MIDDLE_ADD.get());
                    }
                }
                break;
            }
            case 2: {
                if (this.clickHandler == null) break;
                return this.clickHandler.handle(cause, container, ClickTypes.DRAG_END.get());
            }
        }
        return true;
    }

    private boolean onClickRight(Cause cause, SlotClickHandler handler, ClickType clickTypeIn, Container container, int idx, Slot slot) {
        switch (clickTypeIn) {
            case PICKUP: {
                return handler.handle(cause, container, slot, idx, ClickTypes.CLICK_RIGHT.get());
            }
            case QUICK_MOVE: {
                return handler.handle(cause, container, slot, idx, ClickTypes.SHIFT_CLICK_RIGHT.get());
            }
            case THROW: {
                return handler.handle(cause, container, slot, idx, ClickTypes.KEY_THROW_ALL.get());
            }
        }
        return true;
    }

    private Boolean onClickLeft(Cause cause, SlotClickHandler handler, ClickType clickTypeIn, Container container, int idx, Slot slot) {
        switch (clickTypeIn) {
            case PICKUP: {
                return handler.handle(cause, container, slot, idx, ClickTypes.CLICK_LEFT.get());
            }
            case QUICK_MOVE: {
                return handler.handle(cause, container, slot, idx, ClickTypes.SHIFT_CLICK_LEFT.get());
            }
            case THROW: {
                return handler.handle(cause, container, slot, idx, ClickTypes.KEY_THROW_ONE.get());
            }
        }
        return true;
    }

    public boolean onChange(ItemStack newStack, ItemStack oldStack, Container container, int slotIndex, net.minecraft.world.inventory.Slot slot) {
        if (this.readonly && !(slot.container instanceof PlayerInventory)) {
            return false;
        }
        if (this.changeHandler != null) {
            Cause cause = PhaseTracker.getCauseStackManager().currentCause();
            return this.changeHandler.handle(cause, container, (Slot)slot, slotIndex, ItemStackUtil.snapshotOf(oldStack), ItemStackUtil.snapshotOf(newStack));
        }
        return true;
    }
}

