/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.generation;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackGenerator;
import org.spongepowered.api.util.weighted.TableEntry;
import org.spongepowered.api.util.weighted.WeightedTable;

public final class SpongeItemStackGenerator
implements ItemStackGenerator {
    final WeightedTable<ItemType> baseType;
    final Map<Key<@NonNull ?>, Object> keyValues;
    final List<BiConsumer<ItemStack.Builder, Random>> biConsumers;

    SpongeItemStackGenerator(Builder builder) {
        this.biConsumers = ImmutableList.copyOf(builder.consumers);
        this.baseType = builder.baseItem;
        this.keyValues = builder.keyValues == null ? Collections.emptyMap() : builder.keyValues;
    }

    @Override
    public ItemStack apply(Random random) {
        ItemStack.Builder builder = ItemStack.builder();
        List<ItemType> itemTypes = this.baseType.get(random);
        builder.itemType(itemTypes.get(random.nextInt(itemTypes.size())));
        this.biConsumers.forEach(builderRandomBiConsumer -> builderRandomBiConsumer.accept(builder, random));
        this.keyValues.forEach((k, v) -> builder.add(k, v));
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpongeItemStackGenerator that = (SpongeItemStackGenerator)o;
        return Objects.equals(this.baseType, that.baseType) && Objects.equals(this.biConsumers, that.biConsumers);
    }

    public int hashCode() {
        return Objects.hash(this.baseType, this.biConsumers);
    }

    public String toString() {
        return new StringJoiner(", ", SpongeItemStackGenerator.class.getSimpleName() + "[", "]").add("baseType=" + this.baseType).add("keyValues=" + this.keyValues).add("biConsumers=" + this.biConsumers).toString();
    }

    public static final class Builder
    implements ItemStackGenerator.Builder {
        final List<BiConsumer<ItemStack.Builder, Random>> consumers = new ArrayList<BiConsumer<ItemStack.Builder, Random>>();
        @MonotonicNonNull WeightedTable<ItemType> baseItem;
        @Nullable LinkedHashMap<Key<@NonNull ?>, Object> keyValues;

        @Override
        public Builder add(BiConsumer<ItemStack.Builder, Random> consumer) {
            this.consumers.add(Objects.requireNonNull(consumer, "Consumer cannot be null!"));
            return this;
        }

        @Override
        public Builder addAll(Collection<BiConsumer<ItemStack.Builder, Random>> collection) {
            this.consumers.addAll(Objects.requireNonNull(collection, "Collecton cannot be null!"));
            return this;
        }

        @Override
        public Builder baseItem(ItemType itemType) {
            this.baseItem = new WeightedTable();
            this.baseItem.add(itemType, 1.0);
            return this;
        }

        @Override
        public ItemStackGenerator.Builder baseItem(WeightedTable<ItemType> itemType) {
            this.baseItem = Objects.requireNonNull(itemType, "Item table cannot be null");
            return this;
        }

        @Override
        public <V> ItemStackGenerator.Builder add(Key<? extends Value<V>> key, V value) {
            if (this.keyValues == null) {
                this.keyValues = new LinkedHashMap();
            }
            this.keyValues.put(key, value);
            return this;
        }

        @Override
        public SpongeItemStackGenerator build() {
            Preconditions.checkState((this.baseItem != null || !this.consumers.isEmpty() ? 1 : 0) != 0, (Object)"Must have at least a defined amount of consumers or a base item type!");
            return new SpongeItemStackGenerator(this);
        }

        @Override
        public ItemStackGenerator.Builder from(ItemStackGenerator value) {
            this.reset();
            Objects.requireNonNull(value, "ItemStackGenerator cannot be null!");
            Preconditions.checkArgument((boolean)(value instanceof SpongeItemStackGenerator), (Object)"Cannot use from on a non-Sponge implemented ItemStackGenerator!");
            SpongeItemStackGenerator generator = (SpongeItemStackGenerator)value;
            this.consumers.addAll(generator.biConsumers);
            this.baseItem = new WeightedTable();
            this.baseItem.addAll((Collection<TableEntry<ItemType>>)generator.baseType);
            return this;
        }

        @Override
        public Builder reset() {
            this.consumers.clear();
            this.baseItem = null;
            this.keyValues = null;
            return this;
        }
    }
}

