/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.ingredient;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.Arrays;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.common.accessor.world.item.crafting.IngredientAccessor;
import org.spongepowered.common.item.recipe.ingredient.IngredientResultUtil;
import org.spongepowered.common.item.recipe.ingredient.SpongeIngredient;
import org.spongepowered.common.item.recipe.ingredient.SpongePredicateItemList;
import org.spongepowered.common.item.recipe.ingredient.SpongeStackItemList;
import org.spongepowered.common.item.util.ItemStackUtil;

public class IngredientUtil {
    public static org.spongepowered.api.item.recipe.crafting.Ingredient fromNative(Ingredient ingredient) {
        return (org.spongepowered.api.item.recipe.crafting.Ingredient)ingredient;
    }

    public static Ingredient toNative(org.spongepowered.api.item.recipe.crafting.Ingredient ingredient) {
        return (Ingredient)ingredient;
    }

    public static org.spongepowered.api.item.recipe.crafting.Ingredient of(ItemType ... items) {
        ItemLike[] providers = (ItemLike[])Arrays.stream(items).map(item -> () -> (Item)item).toArray(ItemLike[]::new);
        return IngredientUtil.fromNative(Ingredient.of((ItemLike[])providers));
    }

    public static @Nullable org.spongepowered.api.item.recipe.crafting.Ingredient of(ResourceKey tagKey) {
        Tag itemTag = ItemTags.getAllTags().getTag((ResourceLocation)tagKey);
        if (itemTag == null) {
            return null;
        }
        return IngredientUtil.fromNative(Ingredient.of((Tag)itemTag));
    }

    private static ItemStack[] toNativeStacks(org.spongepowered.api.item.inventory.ItemStack[] stacks) {
        return (ItemStack[])Arrays.stream(stacks).map(ItemStackUtil::toNative).toArray(ItemStack[]::new);
    }

    public static org.spongepowered.api.item.recipe.crafting.Ingredient of(org.spongepowered.api.item.inventory.ItemStack ... stacks) {
        SpongeIngredient ingredient = SpongeIngredient.spongeFromStacks(IngredientUtil.toNativeStacks(stacks));
        return IngredientUtil.fromNative(ingredient);
    }

    public static org.spongepowered.api.item.recipe.crafting.Ingredient of(ResourceKey key, Predicate<org.spongepowered.api.item.inventory.ItemStack> predicate, org.spongepowered.api.item.inventory.ItemStack ... stacks) {
        SpongeIngredient ingredient = SpongeIngredient.spongeFromPredicate(key, predicate, IngredientUtil.toNativeStacks(stacks));
        return IngredientUtil.fromNative(ingredient);
    }

    public static Ingredient spongeDeserialize(JsonElement json) {
        if (json == null || json.isJsonNull()) {
            throw new JsonSyntaxException("Item cannot be null");
        }
        if (json.isJsonObject()) {
            JsonObject ingredientJson = json.getAsJsonObject();
            if (ingredientJson.has("sponge:type")) {
                String type;
                switch (type = GsonHelper.getAsString((JsonObject)ingredientJson, (String)"sponge:type")) {
                    case "sponge:stack": {
                        return new SpongeIngredient(IngredientUtil.spongeDeserializeItemList(ingredientJson));
                    }
                    case "sponge:predicate": {
                        return new SpongeIngredient(IngredientUtil.spongeDeserializePredicateItemList(ingredientJson));
                    }
                }
                throw new JsonSyntaxException("Unknown Sponge ingredient type " + type);
            }
            Ingredient.Value itemList = IngredientAccessor.invoker$valueFromJson(ingredientJson);
            return IngredientAccessor.invoker$fromValues(Stream.of(itemList));
        }
        if (json.isJsonArray()) {
            JsonArray jsonarray = json.getAsJsonArray();
            if (jsonarray.size() == 0) {
                throw new JsonSyntaxException("Item array cannot be empty, at least one item must be defined");
            }
            return IngredientAccessor.invoker$fromValues(StreamSupport.stream(jsonarray.spliterator(), false).map(p_209355_0_ -> IngredientAccessor.invoker$valueFromJson(GsonHelper.convertToJsonObject((JsonElement)p_209355_0_, (String)"item"))));
        }
        throw new JsonSyntaxException("Expected item to be object or array of objects");
    }

    private static Stream<? extends Ingredient.Value> spongeDeserializePredicateItemList(JsonObject json) {
        if (!json.has("sponge:item")) {
            throw new JsonParseException("Sponge Ingredient is missing sponge:item");
        }
        if (!json.has("sponge:predicate")) {
            throw new JsonParseException("Sponge Ingredient Predicate is missing sponge:predicate");
        }
        if (!json.get("sponge:item").isJsonArray()) {
            throw new JsonParseException("Sponge Ingredient sponge:item is not an object");
        }
        String id = GsonHelper.getAsString((JsonObject)json, (String)"sponge:predicate");
        Predicate<ItemStack> predicate = SpongeIngredient.getCachedPredicate(id);
        if (predicate == null) {
            throw new JsonParseException("Sponge Ingredient Predicate not found: " + id);
        }
        JsonArray jsonArray = json.getAsJsonArray("sponge:item");
        return StreamSupport.stream(jsonArray.spliterator(), false).map(JsonElement::getAsJsonObject).map(IngredientResultUtil::deserializeItemStack).map(stacks -> new SpongePredicateItemList(id, predicate, (ItemStack)stacks));
    }

    public static Stream<Ingredient.Value> spongeDeserializeItemList(JsonObject json) {
        if (!json.has("sponge:item")) {
            throw new JsonParseException("Sponge Ingredient is missing sponge:item");
        }
        if (!json.get("sponge:item").isJsonArray()) {
            throw new JsonParseException("Sponge Ingredient sponge:item is not an object");
        }
        JsonArray jsonArray = json.getAsJsonArray("sponge:item");
        return StreamSupport.stream(jsonArray.spliterator(), false).map(JsonElement::getAsJsonObject).map(IngredientResultUtil::deserializeItemStack).map(xva$0 -> new SpongeStackItemList((ItemStack)xva$0));
    }
}

